/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public final class UnresolveXRefsThread
extends ProcessThread {
    private final List<Long> urisToProcess = new ArrayList<Long>();
    private int currentProgress = 0;
    private int totalUris = 0;
    private String lastError = null;

    private UnresolveXRefsThread(String membername, Group group) {
        super(membername, "Unresolve XRefs thread for group " + group.getName(), group);
    }

    public void addURI(Long uriid) {
        this.urisToProcess.add(uriid);
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.totalUris);
        out.field("current", (long)this.currentProgress);
        out.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Transaction tr;
        Database db;
        try {
            db = Database.open();
            tr = new Transaction(db);
        }
        catch (OpenDatabaseException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database");
            return;
        }
        try {
            tr.begin();
            if (this.run(db, tr)) {
                tr.commit();
            } else {
                tr.abort();
            }
        }
        catch (CommitTransactionException | StartTransactionException ex) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to handle transaction");
        }
        finally {
            db.close();
        }
    }

    public boolean run(Database database, Transaction transaction) {
        if (this.urisToProcess.isEmpty()) {
            this.fail("No URI to process!");
            this.complete("Failed");
            return false;
        }
        try {
            Group group = DatabaseQuery.getGroupById((Database)database, (Long)this.getGroupID());
            this.computeURIs(database);
            if (this.hasError() || this.wasCancelled()) {
                if (this.lastError != null) {
                    this.fail(this.lastError);
                }
                this.complete("Failed");
                return false;
            }
            this.totalUris = this.urisToProcess.size();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.totalUris + " URIs to unresolve");
            ArrayList<URI> toIndex = new ArrayList<URI>();
            this.totalUris = this.urisToProcess.size();
            for (Long uriid : this.urisToProcess) {
                toIndex.addAll(this.removeXrefs(uriid, group, database));
            }
            transaction.commitAndStart();
            ChangesManager changes = ChangesManager.getInstance();
            String batchName = "Unresolving xrefs for " + this.totalUris + " document" + (this.totalUris == 1 ? "" : "s");
            ChangesBatch batch = new ChangesBatch(batchName);
            changes.startBatch(database, batch);
            for (URI uri : toIndex) {
                changes.modifyURI(database, batch, uri, DatabaseQuery.getGroupsByURIIdCol((Database)database, (Long)uri.getId()));
            }
            changes.completeBatch(database, batch);
            this.complete("Successfully unresolved " + this.totalUris + " document" + (this.totalUris == 1 ? "" : "s") + (this.hasWarning() ? " with some warnings, see logs" : ""));
        }
        catch (DatabaseException e) {
            this.updateStatus(ProcessStage.Status.FAILED, "Failed to run database query: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void computeURIs(Database db) throws QueryFailedException {
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing URIs to unresolve");
        ArrayList<Long> original = new ArrayList<Long>(this.urisToProcess);
        for (Long uriid : original) {
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
            if (uri != null && URIRule.isFolder((URI)uri)) {
                Collection subURIs = DatabaseQuery.getURIsBySchemeHostPortSubpath((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)(uri.getPath() + "/"), (boolean)false);
                this.urisToProcess.addAll(subURIs.stream().map(URI::getId).collect(Collectors.toList()));
                this.urisToProcess.remove(uriid);
            }
            if (!this.wasCancelled() && !this.hasError()) continue;
            break;
        }
    }

    private List<URI> removeXrefs(Long uriid, Group group, Database db) {
        ArrayList<URI> toIndex = new ArrayList<URI>();
        try {
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
            if (uri != null) {
                Date changed = new Date();
                List xrefs = DatabaseQuery.getXRefsForwardURIGroupFragment((Database)db, (URI)uri, (Group)GroupRule.getEditGroup((Database)db, (Group)group, (URI)uri), null);
                for (XLink xl : xrefs) {
                    xl.setStatus("Documentation-Old");
                    xl.setStatusChangedDate(changed);
                    URI target = new XRef(xl).getTargetURI();
                    if (target == null) continue;
                    target.setLastModified(changed);
                    toIndex.add(target);
                }
                uri.setLastModified(changed);
                toIndex.add(uri);
                ++this.currentProgress;
            }
        }
        catch (DatabaseException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to load forward xrefs URI " + uriid);
        }
        return toIndex;
    }

    public void error(String message) {
        this.lastError = message;
        super.updateStatus(ProcessStage.Status.ERROR, message);
    }

    public static UnresolveXRefsThread newInstance(String username, Group group) {
        return new UnresolveXRefsThread(username, group);
    }
}

