/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.thread;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public final class CreateWorkflowThread
extends ProcessThread {
    private static final int MAX_WORKFLOW_NOTIFICATION_PSML = 20;
    private final Workflow workflow;
    private int total = 0;
    private int current = 0;
    private final Long uriid;
    private final List<Long> uriids = new ArrayList<Long>();

    public CreateWorkflowThread(String username, Group group, URI uri, Workflow wf) {
        super(username, "Creating workflow for " + (String)(uri == null ? "batch" : "folder " + uri.getDisplayTitle()), group);
        this.uriid = uri == null ? null : uri.getId();
        this.workflow = wf;
    }

    public void addURI(Long id) {
        this.uriids.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.fail("Failed to open database: " + ex.getMessage());
            this.complete("");
            return;
        }
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing documents to process");
        Transaction tr = new Transaction(db);
        boolean withWarnings = false;
        int nbcreated = 0;
        try {
            String batchName;
            Collection<URI> uris;
            Group wgroup;
            Member author;
            tr.begin();
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)this.getGroupID());
            Member member = author = this.workflow.authorid == null ? null : DatabaseQuery.getMemberById((Database)db, (Long)this.workflow.authorid);
            if (author == null) {
                this.fail("Workflow has no valid author.");
                return;
            }
            Member assigned = this.workflow.assignMemid == null || Long.valueOf(0L).equals(this.workflow.assignMemid) ? null : DatabaseQuery.getMemberById((Database)db, (Long)this.workflow.assignMemid);
            Group group2 = wgroup = this.workflow.groupid == null ? null : DatabaseQuery.getGroupById((Database)db, (Long)this.workflow.groupid);
            if (wgroup == null) {
                this.fail("Workflow has no valid group.");
                return;
            }
            if (this.uriid != null) {
                URI folder = DatabaseQuery.getURIById((Database)db, (Long)this.uriid);
                if (folder == null || !"folder".equals(folder.getType())) {
                    this.fail("URI " + this.uriid + " is not a valid folder URI.");
                    return;
                }
                uris = DatabaseQuery.getURIsBySchemeHostPortSubpath((Database)db, (String)folder.getScheme(), (String)folder.getHost().getName(), (Integer)folder.getPort(), (String)(folder.getPath() + "/"), (boolean)false);
                batchName = "Bulk workflow on folder " + folder.getDecodedPath();
            } else if (!this.uriids.isEmpty()) {
                uris = new ArrayList();
                for (Long id : this.uriids) {
                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)id);
                    if (!"folder".equals(uri.getType())) {
                        uris.add(uri);
                        continue;
                    }
                    this.updateStatus(ProcessStage.Status.WARNING, "Ignoring URI " + id + " as it is a folder");
                }
                batchName = "Bulk workflow on batch with " + this.uriids.size() + " documents";
            } else {
                this.fail("No objects to create version!");
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + uris.size() + " documents.");
            int maxPSML = GlobalSettings.getInt((String)"maxWorkflowNotifications", (int)20);
            if (uris.size() > maxPSML && this.workflow.notify != Notify.SILENT) {
                this.workflow.notify = Notify.SILENT;
                this.updateStatus(ProcessStage.Status.WARNING, "The notify parameter will be ignored as there were more than " + maxPSML + " workflows to create.");
                withWarnings = true;
            }
            this.total = uris.size() * 2;
            this.current = 0;
            ArrayList<Long[]> created = new ArrayList<Long[]>();
            for (URI psml : uris) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Creating workflow for URI " + psml.getDecodedPath());
                XLink xl = null;
                try {
                    xl = XLinkRule.createWorkflowXLink((Database)db, (URI)psml, (Member)author, (Date)this.workflow.createdate, (String)this.workflow.status, (String)this.workflow.priority, (Long)this.workflow.assignMemid, (Member)assigned, (Date)this.workflow.duedate, (String[])this.workflow.labels, (String)this.workflow.content, (String)this.workflow.contentType, (boolean)false, (Group)wgroup, (boolean)true);
                    XLinkRule.sendWorkflowNotification((Database)db, (Transaction)tr, (URI)psml, (XLink)xl, (Notify)this.workflow.notify, null);
                }
                catch (EmailException ex) {
                    this.updateStatus(ProcessStage.Status.WARNING, "The workflow step has been added, however it could not be emailed to other group members.");
                    withWarnings = true;
                }
                catch (FoundationException ex) {
                    this.updateStatus(ProcessStage.Status.ERROR, RuleUtils.defaultValue((String)ex.getMessage(), (String)"Failed to create workflow"));
                    withWarnings = true;
                }
                if (xl != null) {
                    created.add(new Long[]{psml.getId(), xl.getId()});
                } else {
                    withWarnings = true;
                    this.updateStatus(ProcessStage.Status.ERROR, "Failed to create workflow");
                }
                if (this.wasCancelled()) {
                    tr.abort();
                    return;
                }
                if (this.current++ % 1000 != 0) continue;
                tr.commitAndStart();
            }
            nbcreated = created.size();
            if (this.wasCancelled()) {
                tr.abort();
                return;
            }
            tr.commitAndStart();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Adding documents to index queue.");
            ChangesManager changes = ChangesManager.getInstance();
            ChangesBatch batch = new ChangesBatch(batchName);
            changes.startBatch(db, batch);
            for (Long[] workflow : created) {
                URI psml = DatabaseQuery.getURIById((Database)db, (Long)workflow[0]);
                XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)workflow[1]);
                Collection uri_groups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)psml.getId());
                changes.modifyURI(db, batch, psml, uri_groups);
                changes.createWorkflow(db, batch, xl, uri_groups);
                ++this.current;
            }
            changes.completeBatch(db, batch);
            tr.commit();
            this.current = this.total;
        }
        catch (StartTransactionException e) {
            this.fail("Failed to start transaction");
            tr.abort();
        }
        catch (DatabaseException e) {
            this.fail("Failed to communicate with database: " + e.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            db = null;
            Object msg = nbcreated == 0 ? "No workflows were created" : (nbcreated == 1 ? "1 workflow was successfully created" : nbcreated + " workflows were successfully created - they will be available after indexing is complete");
            if (withWarnings) {
                this.fail((String)msg + " and there were some warnings and/or errors, see process logs for more details.");
            }
            this.complete((String)msg + ".");
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", (long)this.total);
        out.field("current", (long)this.current);
        out.endObject();
    }

    public static class Workflow {
        private final Long authorid;
        private final String status;
        private final Date createdate;
        private final Date duedate;
        private final String priority;
        private final String[] labels;
        private final Long assignMemid;
        private final Long groupid;
        private final String content;
        private final String contentType;
        private Notify notify;

        public Workflow(Member a, Date cd, String s, Date dd, String p, Long amid, Group grp, String c, String ctype, String[] l, Notify not) {
            this.assignMemid = amid;
            this.authorid = a == null ? null : a.getId();
            this.createdate = cd;
            this.notify = not;
            this.content = c;
            this.contentType = ctype;
            this.duedate = dd;
            this.groupid = grp == null ? null : grp.getId();
            this.priority = p;
            this.labels = l;
            this.status = s;
        }
    }
}

