/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.system;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.MD5;
import com.pageseeder.mail.IncomingMailServer;
import java.io.File;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Alerts
implements Generator,
SingleCheck,
Cacheable {
    private transient String cache = null;
    private transient String md5 = null;
    private final ThreadLocal<String> computed = new ThreadLocal();

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public String getETag(GeneratorRequest req) {
        String xml = this.getXML();
        this.computed.set(xml);
        if (!xml.equals(this.cache)) {
            this.cache = xml;
            this.md5 = MD5.hash((String)xml);
        }
        return this.md5;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String xml = this.computed.get();
        if (xml == null) {
            xml = this.getXML();
        }
        XMLWriter out = res.getXMLWriter();
        out.writeXML(xml);
    }

    private String getXML() {
        try (UniversalPrinter out = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
            File[] hprofs;
            String incomingEmailDisbaled;
            out.startObject("alerts");
            if (GlobalSettings.getString((String)"smtpServerAddress", (String)"").isEmpty()) {
                out.field("outgoing-email-disabled", "true");
            }
            if ((incomingEmailDisbaled = IncomingMailServer.getInstance().getDisabledMessage()) != null) {
                out.field("incoming-email-disabled-message", incomingEmailDisbaled);
            }
            out.startCollection("alerts", OutputPrinter.CollectionOption.JSON_ONLY);
            File root = new File(Settings.getContextPath()).getParentFile();
            if (root != null && root.exists() && root.isDirectory() && (hprofs = root.listFiles((file, s) -> s.toLowerCase().endsWith(".hprof"))) != null) {
                for (File file2 : hprofs) {
                    out.writeFile(file2, root, 0, false, (x, f, s) -> x.field("fullpath", f.getAbsolutePath()));
                }
            }
            out.endCollection();
            out.endObject();
            String string = out.toString();
            return string;
        }
    }
}

