/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorFactory;
import com.pageseeder.service.Service;
import com.pageseeder.service.ServiceRegistry;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.pageseeder.furi.URIPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class ServicesHandler10
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesHandler10.class);
    private final GeneratorFactory _factory;
    private final ServiceRegistry _registry;
    private final StringBuilder ch = new StringBuilder();
    private transient URIPattern _pattern;
    private transient Service.HttpMethod _method;
    private transient String _cachecontrol;
    private transient String _resourceId;
    private transient Generator _generator;
    private transient Map<String, String> _parameters;
    private transient List<String> _parametertunnels;
    private String since = null;
    private String deprecated = null;
    private String obsolete = null;

    public ServicesHandler10(ServiceRegistry registry, GeneratorFactory factory) {
        this._registry = registry;
        this._factory = factory;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        this.ch.setLength(0);
        Element element = Element.get(localName);
        switch (element) {
            case GENERATOR: {
                if (this.obsolete != null) break;
                this._generator = this._factory.getInstance(atts.getValue("class"));
                break;
            }
            case PARAMETER: {
                if (this._parameters == null) {
                    this._parameters = new LinkedHashMap<String, String>();
                }
                this._parameters.put(atts.getValue("name"), atts.getValue("value"));
                break;
            }
            case PARAMETER_TUNNEL: {
                if (this._parametertunnels == null) {
                    this._parametertunnels = new LinkedList<String>();
                }
                this._parametertunnels.add(atts.getValue("prefix"));
                break;
            }
            case METHOD: {
                this._method = Service.HttpMethod.valueOf(atts.getValue("type").toUpperCase());
                this.since = atts.getValue("since");
                this.deprecated = atts.getValue("deprecated");
                this.obsolete = atts.getValue("obsolete");
                break;
            }
            case RESOURCE: {
                this._pattern = new URIPattern(atts.getValue("path"));
                this._cachecontrol = atts.getValue("cache-control");
                this._resourceId = atts.getValue("id");
                break;
            }
            case SERVICES: {
                this._registry.clear();
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Element element = Element.get(localName);
        switch (element) {
            case METHOD: {
                Service.Builder builder = new Service.Builder(this._pattern, this._method, this._generator);
                builder.resource(this._resourceId);
                if (this._parameters != null) {
                    builder.parameters(this._parameters);
                }
                if (this._parametertunnels != null) {
                    builder.parameterTunnels(this._parametertunnels);
                }
                if (this._cachecontrol != null) {
                    builder.cacheControl(this._cachecontrol);
                }
                builder.since(this.since);
                builder.deprecated(this.deprecated);
                builder.obsolete(this.obsolete);
                Service service = builder.build();
                LOGGER.debug("Registering {}", (Object)service);
                this._registry.register(service);
                this._parameters = null;
                this._cachecontrol = null;
                this.since = null;
                this.deprecated = null;
                this.obsolete = null;
                break;
            }
        }
        this.ch.setLength(0);
    }

    @Override
    public void characters(char[] buf, int pos, int len) {
        this.ch.append(buf, pos, len);
    }

    private static enum Element {
        GENERATOR,
        PARAMETER,
        PARAMETER_TUNNEL,
        METHOD,
        RESOURCE,
        SERVICES;

        private final String _name = this.name().toLowerCase().replace('_', '-');

        public static Element get(String name) {
            for (Element element : Element.values()) {
                if (!element._name.equals(name)) continue;
                return element;
            }
            return null;
        }

        public String toString() {
            return this._name;
        }
    }
}

