/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.GeneratorFactory;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.service.Service;
import com.pageseeder.service.ServiceException;
import com.pageseeder.service.ServiceRegistry;
import com.pageseeder.service.ServicesHandler10;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceManager.class);
    private static transient SAXParserFactory parsers;
    private final ServiceRegistry _registry = new ServiceRegistry();
    private final File _config;
    private final GeneratorFactory _factory;
    private transient boolean loaded = false;
    private transient boolean loading = false;

    protected ServiceManager(File config, GeneratorFactory factory) {
        this._config = config;
        this._factory = factory;
    }

    public Service getInstance(String uri, Service.HttpMethod method) {
        if (uri == null) {
            return null;
        }
        if (!this.loaded) {
            try {
                this.load();
                this.loaded = true;
            }
            catch (ServiceException ex) {
                LOGGER.error("Error reported while loading services", (Throwable)ex);
            }
        }
        return this._registry.find(uri, method);
    }

    public void load() throws ServiceException {
        this.load(this._config);
    }

    private synchronized void load(File xml) throws ServiceException {
        if (this.loading) {
            return;
        }
        this.loading = true;
        if (xml == null || !xml.exists()) {
            throw new IllegalArgumentException("The generators configuration could not be found in " + String.valueOf(xml));
        }
        SAXParser parser = ServiceManager.getParser();
        try {
            XMLReader reader = parser.getXMLReader();
            HandlingDispatcher dispatcher = new HandlingDispatcher(reader, this._registry, this._factory);
            reader.setContentHandler(dispatcher);
            String path = xml.toURI().toString();
            LOGGER.info("Parsing {}", (Object)path.substring(path.indexOf("WEB-INF") + 7));
            reader.parse(new InputSource(xml.toURI().toString()));
        }
        catch (SAXParseException ex) {
            LOGGER.error("SAX Parsing error line {}: {}", (Object)ex.getLineNumber(), (Object)ex.getMessage());
            throw new ServiceException("Could not parse services: " + ex.getMessage() + " line" + ex.getLineNumber());
        }
        catch (SAXException ex) {
            LOGGER.error("An SAX error occurred while reading XML configuration of generators", (Throwable)ex);
            throw new ServiceException("Could not parse file. " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOGGER.error("An I/O error occurred while reading XML configuration of generators", (Throwable)ex);
            throw new ServiceException("Could not read file.", ex);
        }
        finally {
            this.loading = false;
        }
    }

    public synchronized void clear() {
        this._registry.clear();
        this.loaded = false;
    }

    public static SAXParser getParser() throws ServiceException {
        SAXParserFactory factory = parsers;
        SAXParser parser = null;
        try {
            if (factory == null) {
                factory = XMLHelpers.safeSAXParserFactory();
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/validation", true);
                factory.setFeature("http://xml.org/sax/features/namespaces", true);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                parsers = factory;
            }
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new ServiceException("Could not configure SAX parser.", ex);
        }
        catch (SAXException ex) {
            throw new ServiceException("Could not setup SAX parser factory: " + ex.getMessage(), ex);
        }
        return parser;
    }

    private static final class HandlingDispatcher
    extends DefaultHandler
    implements ContentHandler {
        private final ServiceRegistry _registry;
        private final GeneratorFactory _factory;
        private final XMLReader _reader;

        public HandlingDispatcher(XMLReader reader, ServiceRegistry registry, GeneratorFactory factory) {
            this._reader = reader;
            this._registry = registry;
            this._factory = factory;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            ContentHandler handler = this.getHandler(localName, atts);
            if (handler != null) {
                try {
                    handler.startElement(uri, localName, qName, atts);
                    this._reader.setContentHandler(handler);
                }
                catch (SAXException ex) {
                    LOGGER.warn("Generated by wrapped handler", (Throwable)ex);
                }
            }
        }

        private ContentHandler getHandler(String name, Attributes atts) {
            if ("services".equals(name)) {
                String version = atts.getValue("version");
                if ("1.0".equals(version)) {
                    LOGGER.info("Service configuration 1.0 detected");
                    return new ServicesHandler10(this._registry, this._factory);
                }
                LOGGER.info("Service configuration version unavailable, assuming 1.0");
                return new ServicesHandler10(this._registry, this._factory);
            }
            LOGGER.error("Unable to determine Berlioz configuration");
            return null;
        }
    }
}

