/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.security;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLogViewer;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import java.text.ParseException;
import org.pageseeder.xmlwriter.XMLWriter;

@PublicAPI
public final class GetSecurityLog
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String date = req.getParameter((Parameter)StandardParameters.date);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        SecurityLogViewer viewer = new SecurityLogViewer();
        try {
            if (date != null) {
                viewer.setDate(ISO8601.parseAuto((String)date));
            }
            if (page > 1) {
                viewer.setPage(page);
            }
            viewer.build();
            XMLWriter xml = res.getXMLWriter();
            viewer.toXML(xml);
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid ISO8601 date");
        }
    }
}

