/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.Resource;
import com.pageseeder.common.io.ResourceCompressor;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.resource.CacheEntry;
import com.pageseeder.resource.ResourceManager;
import com.pageseeder.resource.URLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StaticServlet
extends HttpServlet {
    private static final long serialVersionUID = 4005269787730968910L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticServlet.class);
    private static final int READ_BUFFER = 2048;
    private static final int WRITE_BUFFER = 2048;
    private static final int AGE_DAY = 86400;
    private static final int AGE_MONTH = 2592000;
    private static final URLEncoder URL_ENCODER = new URLEncoder();
    private static final Pattern DOCUMENT_STYLE_PATH;
    private static final Pattern ORGANIZATION_STYLE_PATH;
    private static final Pattern PROJECT_STYLE_PATH;
    private ResourceManager resources = null;

    public void destroy() {
        this.resources = null;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config != null) {
            ServletContext context = config.getServletContext();
            File contextPath = new File(context.getRealPath("/"));
            if (!contextPath.exists()) {
                throw new UnavailableException("Cannot create resource manager for '" + String.valueOf(contextPath) + "': does not exist.");
            }
            this.resources = new ResourceManager(contextPath);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.serveResource(request, response, true);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.serveResource(request, response, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected String getRelativePath(HttpServletRequest request) {
        String path = request.getServletPath() + request.getPathInfo();
        if (path.contains("..")) {
            return null;
        }
        return path;
    }

    protected String rewriteURL(String path) {
        return URL_ENCODER.encode(path);
    }

    private void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException {
        CacheEntry cacheEntry;
        Object path = this.getRelativePath(request);
        if (LOGGER.isDebugEnabled()) {
            if (content) {
                LOGGER.debug("Serving resource '{}' headers and data", path);
            } else {
                LOGGER.debug("Serving resource '{}' headers only", path);
            }
        }
        if (path != null) {
            String mimeType;
            Matcher m = DOCUMENT_STYLE_PATH.matcher((CharSequence)path);
            if (m.matches()) {
                path = "/WEB-INF/config/template/" + m.group(1) + "/psml/" + m.group(2) + "/style/" + m.group(3);
            } else {
                m = ORGANIZATION_STYLE_PATH.matcher((CharSequence)path);
                if (m.matches()) {
                    path = "/WEB-INF/config/template/" + m.group(1) + "/organization/style/" + m.group(2);
                } else {
                    m = PROJECT_STYLE_PATH.matcher((CharSequence)path);
                    if (m.matches()) {
                        path = "/WEB-INF/config/template/" + m.group(1) + "/style/" + m.group(2);
                    }
                }
            }
            if (((String)path).startsWith("/WEB-INF/") && ((mimeType = StaticServlet.getMimeType((String)path)) == null || !mimeType.startsWith("image/") && !mimeType.equals("text/css"))) {
                response.sendError(404, "Resource not found");
                LOGGER.debug("Template resource type not allowed: {}", path);
                return;
            }
        }
        if ((cacheEntry = this.resources.lookupCache((String)path)) == null || !cacheEntry.exists()) {
            response.sendError(404, "Resource not found");
            LOGGER.debug("Resource not found: {}", (Object)cacheEntry);
            return;
        }
        if (((String)path).endsWith("/") || ((String)path).endsWith("\\")) {
            response.sendError(404, "Illegal path ending");
            LOGGER.debug("Illegal path ending: {}", path);
            return;
        }
        String contentType = cacheEntry.info.getMimeType();
        if (contentType == null) {
            contentType = StaticServlet.getMimeType(cacheEntry.getName());
            cacheEntry.info.setMimeType(contentType);
        }
        response.setDateHeader("Expires", StaticServlet.getExpiryDate());
        response.setHeader("Cache-Control", StaticServlet.getCacheControl(contentType));
        if (!HttpRequests.checkIfHeaders((HttpServletRequest)request, (HttpServletResponse)response, (EntityInfo)cacheEntry.info)) {
            return;
        }
        long contentLength = -1L;
        if (request.getHeader("Range") != null) {
            response.setHeader("Accept-Ranges", "none");
        }
        String etag = cacheEntry.info.getETag();
        String lastModified = cacheEntry.info.getLastModifiedHttp();
        if (etag != null) {
            response.setHeader("ETag", HttpRequests.toSafeHeader((String)etag));
        }
        if (lastModified != null) {
            response.setHeader("Last-Modified", HttpRequests.toSafeHeader((String)lastModified));
        }
        if ((contentLength = cacheEntry.info.getContentLength()) == 0L) {
            content = false;
        }
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (content) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType == null || contentType.startsWith("text") || contentType.endsWith("xml")) {
                    writer = response.getWriter();
                }
                throw e;
            }
        }
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (cacheEntry.resource != null && contentLength >= 0L) {
            HttpRequests.setContentLength((HttpServletResponse)response, (long)contentLength);
        }
        if (content) {
            if (!(response instanceof HttpServletResponseWrapper)) {
                try {
                    response.setBufferSize(2048);
                }
                catch (IllegalStateException ex) {
                    LOGGER.warn("Response already written to", (Throwable)ex);
                }
            }
            if (ostream != null) {
                Resource resource = cacheEntry.resource;
                if (HttpRequests.isCompressible((String)contentType) && HttpRequests.acceptsGZipCompression((HttpServletRequest)request)) {
                    response.setHeader("Vary", "Accept-Encoding");
                    if (HttpRequests.acceptsGZipCompression((HttpServletRequest)request) && resource.getContent() != null) {
                        File f = cacheEntry.resource.getFile();
                        if (!f.getCanonicalPath().startsWith(this.resources.getRoot().getCanonicalPath())) {
                            LOGGER.error("Path results in a file outside base folder: {}", path);
                            throw new IOException("Path results in a file outside base folder");
                        }
                        resource = new Resource(f);
                        resource.setContent(cacheEntry.resource.getContent());
                        boolean ok = ResourceCompressor.compress((Resource)resource);
                        if (ok) {
                            response.setIntHeader("Content-Length", resource.getContent().length);
                            response.setHeader("Content-Encoding", "gzip");
                            if (etag != null) {
                                response.setHeader("ETag", HttpRequests.toSafeHeader((String)HttpRequests.getETagForGZip((String)etag)));
                            }
                        }
                    }
                }
                this.copy(resource, ostream);
            } else {
                this.copy(cacheEntry.resource, writer);
            }
        }
    }

    protected void copy(Resource resource, ServletOutputStream ostream) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot copy content of null resource");
        }
        byte[] buffer = resource.getContent();
        if (buffer != null) {
            ostream.write(buffer, 0, buffer.length);
            return;
        }
        InputStream resourceInputStream = resource.streamContent();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, 2048);
        IOException exception = this.copy(istream, ostream);
        ((InputStream)istream).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(Resource resource, PrintWriter writer) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot copy content of null resource");
        }
        InputStream resourceInputStream = resource.streamContent();
        InputStreamReader reader = new InputStreamReader(resourceInputStream, StandardCharsets.UTF_8);
        IOException exception = this.copy(reader, writer);
        ((Reader)reader).close();
        if (exception != null) {
            throw exception;
        }
    }

    protected IOException copy(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[2048];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copy(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[2048];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private static String getMimeType(String name) {
        int x = name.lastIndexOf(46);
        String extension = x >= 0 ? name.substring(x + 1) : "html";
        return Settings.get((SettingsFile)SettingsFile.MIME, (String)extension);
    }

    private static long getExpiryDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.roll(1, 1);
        return calendar.getTimeInMillis();
    }

    private static String getCacheControl(String contentType) {
        if (contentType == null) {
            return "max-age=3600, must-revalidate";
        }
        if (contentType.startsWith("image/")) {
            return "max-age=2592000, must-revalidate";
        }
        if (contentType.endsWith("/css") || contentType.endsWith("/javascript")) {
            return "max-age=86400, must-revalidate";
        }
        return "max-age=3600, must-revalidate";
    }

    static {
        URL_ENCODER.addSafeCharacter('-');
        URL_ENCODER.addSafeCharacter('_');
        URL_ENCODER.addSafeCharacter('.');
        URL_ENCODER.addSafeCharacter('*');
        URL_ENCODER.addSafeCharacter('/');
        DOCUMENT_STYLE_PATH = Pattern.compile("\\/woconfig\\/([^\\/]+)\\/psml\\/([^\\/]+)\\/(.+)");
        ORGANIZATION_STYLE_PATH = Pattern.compile("\\/woconfig\\/([^\\/]+)\\/organization\\/(.+)");
        PROJECT_STYLE_PATH = Pattern.compile("\\/woconfig\\/([^\\/]+)\\/(.+)");
    }
}

