/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Resource;
import com.pageseeder.resource.CacheEntry;
import com.pageseeder.resource.ResourceCache;
import com.pageseeder.resource.ResourceInfo;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManager.class);
    private static final int CACHE_OBJECT_MAX_SIZE = 524288;
    private final File _root;
    private final ResourceCache cache;

    public ResourceManager(File root) {
        if (root == null) {
            throw new IllegalArgumentException("Cannot create resource manager from null file.");
        }
        if (!root.exists()) {
            throw new IllegalArgumentException("Cannot create resource manager from " + root.getName() + " - does not exist");
        }
        this._root = root;
        this.cache = new ResourceCache();
        LOGGER.debug("Creating a resource manager for {}", (Object)root.getAbsolutePath());
    }

    public File getRoot() {
        return this._root;
    }

    public CacheEntry lookupCache(String name) throws IOException {
        if (name == null) {
            return null;
        }
        CacheEntry entry = this.cache.lookup(name);
        if (entry == null) {
            entry = new CacheEntry(name);
            this.cacheLoad(entry);
        } else {
            if (!this.validate(entry)) {
                if (!this.revalidate(entry)) {
                    this.cacheUnload(entry.getName());
                    entry = new CacheEntry(name);
                    this.cacheLoad(entry);
                    return entry;
                }
                entry.updateTimestamp();
            }
            ++entry.accessCount;
        }
        return entry;
    }

    protected boolean validate(CacheEntry entry) {
        return (!entry.exists() || entry.resource != null && entry.resource.getContent() != null) && System.currentTimeMillis() < entry.timestamp();
    }

    protected boolean revalidate(CacheEntry entry) {
        if (!entry.exists()) {
            return false;
        }
        if (entry.info == null) {
            return false;
        }
        long lastModified = entry.info.getLastModified();
        long contentLength = entry.info.getContentLength();
        if (lastModified <= 0L) {
            return false;
        }
        ResourceInfo info = ResourceManager.loadInfo(entry.resource.getFile());
        if (info != null) {
            long lastModified2 = info.getLastModified();
            long contentLength2 = info.getContentLength();
            return lastModified == lastModified2 && contentLength == contentLength2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheLoad(CacheEntry entry) throws IOException {
        boolean exists;
        LOGGER.debug("Loading cache entry {}", (Object)entry);
        String name = entry.getName();
        File file = Files.descendantFile((File)this._root, (String)name);
        if (!file.getCanonicalPath().startsWith(this._root.getCanonicalPath())) {
            LOGGER.error("Path results in a file outside base folder: " + name);
            throw new IOException("Path results in a file outside base folder");
        }
        boolean bl = exists = file.exists() && !file.isDirectory();
        if (exists) {
            long length;
            if (entry.info == null) {
                entry.info = ResourceManager.loadInfo(file);
            }
            if (entry.resource == null) {
                entry.resource = new Resource(file);
            }
            if (entry.resource.getContent() == null && (length = entry.info.getContentLength()) >= 0L && length < 524288L) {
                entry.resource.loadContent();
            }
        }
        entry.exists(exists);
        entry.updateTimestamp();
        ResourceCache resourceCache = this.cache;
        synchronized (resourceCache) {
            if (this.cache.lookup(name) == null && this.cache.allocate(entry.size)) {
                this.cache.load(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheUnload(String name) {
        if (this.cache == null) {
            return false;
        }
        LOGGER.debug("Unloading cache entry {}", (Object)name);
        ResourceCache resourceCache = this.cache;
        synchronized (resourceCache) {
            return this.cache.unload(name);
        }
    }

    private static ResourceInfo loadInfo(File file) {
        ResourceInfo info = new ResourceInfo();
        try {
            info.setLastModified(file.lastModified());
            info.setContentLength(file.length());
            info.setName(file.getName());
        }
        catch (SecurityException ex) {
            LOGGER.warn("Security exception while loading resource information", (Throwable)ex);
            return null;
        }
        return info;
    }
}

