/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.security.AntiCSRFToken;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Member;
import com.pageseeder.publish.Publisher;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, member=true, group=true, parameters={"project", "type", "target"})
public final class Start
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        ViewURICheck check = req.getURI() != null ? new ViewURICheck(req.getURI()) : (req.getGroup() != null ? new ViewGroupCheck(req.getGroup()) : new ForbiddenCheck());
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, QueryFailedException {
        String view;
        String downloadWorking;
        Publisher publisher = new Publisher(Publisher.PublisherAction.PUBLISH);
        String sessionid = req.getHttpServletRequest().getSession().getId();
        publisher.setJsessionid(sessionid);
        String loglevel = req.getParameter((Parameter)StandardParameters.log_level);
        if (loglevel != null) {
            publisher.setParameter("log-level", loglevel);
        }
        if ((downloadWorking = req.getParameter((Parameter)StandardParameters.download_working)) != null) {
            publisher.setParameter("download-working", downloadWorking);
        }
        if ((view = (String)req.getHttpServletRequest().getAttribute("com.pageseeder.layout.ps-perspective")) != null) {
            publisher.setParameter("style-view", view);
        }
        if (req.getURI() != null) {
            publisher.setUri(req.getURI(), req.getGroup(), req.getDatabase());
        }
        publisher.setGroup(req.getGroup());
        Member mem = req.getMember();
        publisher.setUsername(mem.getUsername());
        publisher.setUserID(mem.getId().toString());
        publisher.setUserFirstname(mem.getFirstName());
        publisher.setUserSurname(mem.getSurname());
        publisher.setUserToken(SecurityUtils.getUserToken((HttpServletRequest)req.getHttpServletRequest()));
        publisher.setAntiCSRFToken(AntiCSRFToken.generateToken((String)sessionid));
        publisher.setConfigProjectName(req.getParameter((Parameter)StandardParameters.project));
        publisher.setActionType(req.getParameter((Parameter)StandardParameters.type));
        publisher.setSourceDocumentType(req.getParameter((Parameter)StandardParameters.documenttype));
        publisher.setSourceURlType(req.getParameter((Parameter)StandardParameters.urltype));
        publisher.setTarget(req.getParameter((Parameter)StandardParameters.target));
        publisher.setParameter("ps-started", String.valueOf(System.currentTimeMillis()));
        Map params = req.getParameters();
        for (Map.Entry param : params.entrySet()) {
            String pname = (String)param.getKey();
            if (!pname.startsWith("ps-param-")) continue;
            publisher.setParameter(pname, (String)param.getValue());
        }
        publisher.run();
        String response = publisher.getResponse();
        XMLWriter xml = res.getXMLWriter();
        xml.writeXML(response);
    }
}

