/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.publish.PublishEvent;
import com.pageseeder.publish.PublishJobs;
import com.pageseeder.publish.PublishScheduler;
import com.pageseeder.publish.Publisher;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishSchedulerThread
implements Runnable {
    private static final long TIMEOUT_IN_MILLIS = 86400000L;
    private static final long DELAY_IN_MILLIS = 5000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishSchedulerThread.class);
    private final PublishScheduler scheduler;

    public PublishSchedulerThread(PublishScheduler dad) {
        this.scheduler = dad;
    }

    @Override
    public void run() {
        LOGGER.info("Publish Scheduler Thread Started");
        block2: while (true) {
            for (PublishEvent event : this.scheduler.getEvents()) {
                if (event.isCurrentlyRunning() && !event.isManual() && System.currentTimeMillis() - event.getLastStartedDate().getTime() > 86400000L) {
                    event.setCurrentlyRunning(false);
                    event.setLastStatus("timeout expired");
                }
                if (event.isCurrentlyRunning() || !event.isPaused() && !event.isExpired() && event.getNextDate().before(new Date())) {
                    PublishSchedulerThread.publishEvent(event);
                }
                if (!Thread.interrupted()) continue;
                break block2;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        LOGGER.info("Publish Scheduler Thread Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishEvent(PublishEvent event) {
        Database db;
        if (event == null) {
            return;
        }
        Publisher.PublisherAction action = event.isCurrentlyRunning() ? Publisher.PublisherAction.CHECK : Publisher.PublisherAction.PUBLISH;
        Publisher publisher = new Publisher(action);
        publisher.setProcessID(event.getProcessID());
        publisher.setConfigProjectName(event.getProject());
        publisher.setSourceType("schedule");
        publisher.setTarget(event.getTarget());
        publisher.setParameter("ps-started", String.valueOf(System.currentTimeMillis()));
        for (String paramname : event.getParameterNames()) {
            Object name = "ps-param-" + paramname;
            if ("ps-log-level".equals(paramname)) {
                name = "log-level";
            } else if ("ps-download-working".equals(paramname)) {
                name = "download-working";
            }
            publisher.setParameter((String)name, event.getParameterValue(paramname));
        }
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException e) {
            LOGGER.error("Failed to open database", (Throwable)e);
            return;
        }
        Transaction tr = null;
        try {
            tr = new Transaction(db);
            tr.begin();
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)event.getProject());
            if (grp == null) {
                event.setLastStatus("error");
                LOGGER.error("Could not publish event {} because there is no group with name {}", (Object)event.getDescription(), (Object)event.getProject());
                tr.abort();
                return;
            }
            publisher.setGroup(grp);
            if (!event.isCurrentlyRunning() && !event.isManual()) {
                event.setLastStartedDate(event.getNextDate());
            }
            if (action == Publisher.PublisherAction.PUBLISH) {
                event.setLastStatus("in-progress");
            }
            String username = event.getUsername();
            if (!event.isCurrentlyRunning() && !Strings.isEmpty((String)username)) {
                Member member = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
                if (member == null) {
                    event.setLastStatus("error");
                    LOGGER.error("Could not publish event {} because there is no member with username {}", (Object)event.getDescription(), (Object)username);
                    tr.abort();
                    return;
                }
                AccessToken token = AccessTokenManager.singleton().issueInternal("publisher", member.getId().longValue(), 24L);
                publisher.setUsername(member.getUsername());
                publisher.setUserID(member.getId().toString());
                publisher.setUserFirstname(member.getFirstName());
                publisher.setUserSurname(member.getSurname());
                publisher.setUserToken(token.token());
            }
            publisher.run();
            event.setCurrentlyRunning(PublishJobs.hasJob(publisher.getProcessID()));
            tr.commit();
        }
        catch (Exception ex) {
            event.setLastStatus("error");
            LOGGER.error("Error when publishing event {}", (Object)event.getDescription());
            LOGGER.error("{}", (Throwable)ex);
            tr.abort();
        }
        finally {
            db.close();
            db = null;
        }
    }
}

