/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PublishLogMessage
implements XMLWritable,
XLoggable {
    private final String _jobid;
    private final String _groupid;
    private final String _group;
    private final String _type;
    private final String _target;
    private String _uripath = null;
    private String _username = null;
    private long _started = -1L;
    private String _progress = null;
    private String _stacktrace = null;
    private String _title = null;
    private String _content = null;

    @Deprecated
    public PublishLogMessage(String type, String target, String id, String gpid, String group) {
        this._jobid = id;
        this._groupid = gpid != null ? gpid.toString() : null;
        this._group = group;
        this._target = target;
        this._type = type;
    }

    private PublishLogMessage(String type, String target, String id, Group group) {
        this._jobid = id;
        this._groupid = group != null ? group.getId().toString() : null;
        this._group = group != null ? group.getName() : null;
        this._target = target;
        this._type = type;
    }

    public String getProgress() {
        return this._progress;
    }

    public void setContent(String content) {
        this._content = content;
    }

    public String getContent() {
        return this._content;
    }

    public String getJobid() {
        return this._jobid;
    }

    public Long getGroupID() {
        return this._groupid != null ? Long.valueOf(this._groupid) : null;
    }

    public String getUsername() {
        return this._username;
    }

    public long getStarted() {
        return this._started;
    }

    public String getTarget() {
        return this._target;
    }

    public String getEventType() {
        return this._type;
    }

    public String getUripath() {
        return this._uripath;
    }

    public void setStacktrace(String stacktrace) {
        this._stacktrace = stacktrace;
    }

    public String getStacktrace() {
        return this._stacktrace;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setURIPath(String uripath) {
        this._uripath = uripath;
    }

    public void setUser(String username) {
        this._username = username;
    }

    public void setStarted(long started) {
        this._started = started;
    }

    public void setProgress(String progress) {
        this._progress = progress;
    }

    public String getGroup() {
        return this._group;
    }

    public String getTicket() {
        return this._jobid;
    }

    public String getUser() {
        return this._username;
    }

    public String getTitle() {
        return this._title;
    }

    public XLoggable.TYPE getType() {
        return "start".equals(this._type) ? XLoggable.TYPE.START : ("complete".equals(this._type) || "fail".equals(this._type) || "cancel".equals(this._type) ? XLoggable.TYPE.END : null);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("publish");
        if (this._type != null) {
            xml.element("type", this._type.equals("cancel") ? "warning" : this._type);
        }
        if (this._groupid != null) {
            xml.element("groupid", this._groupid);
        }
        if (this._jobid != null) {
            xml.element("jobid", this._jobid);
        }
        if (this._username != null) {
            xml.element("username", this._username);
        }
        if (this._started != -1L) {
            xml.element("started", String.valueOf(this._started));
        }
        if (this._uripath != null) {
            xml.element("uripath", this._uripath);
        }
        if (this._target != null) {
            xml.element("target", this._target);
        }
        if (this._content != null) {
            xml.openElement("message");
            xml.writeXML(this._content);
            xml.closeElement();
        }
        if (this._stacktrace != null) {
            xml.element("stacktrace", this._stacktrace);
        }
        xml.closeElement();
    }

    public String toXML() {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            this.toXML((XMLWriter)xml);
        }
        catch (IOException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
        return xml.toString();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this._type != null) {
            out.append('[').append(this._type).append(']');
        }
        if (this._content != null) {
            out.append(' ').append(this._content);
        }
        out.append(" (");
        if (this._jobid != null) {
            out.append(" J:").append(this._jobid);
        }
        if (this._groupid != null) {
            out.append(" G:").append(this._groupid);
        }
        if (this._username != null) {
            out.append(" U:").append(this._username);
        }
        if (this._started != -1L) {
            out.append(" S:").append(this._started);
        }
        if (this._target != null) {
            out.append(" T:").append(this._target);
        }
        if (this._uripath != null) {
            out.append(" P:").append(this._uripath);
        }
        out.append(')');
        if (this._stacktrace != null) {
            out.append('\n');
            out.append(this._stacktrace);
        }
        return out.toString();
    }

    public void toXMLLog(Appendable xml) throws IOException {
        xml.append("<publish");
        if (this._type != null) {
            PublishLogMessage.attribute(xml, "type", this._type.equals("cancel") ? "warning" : this._type);
        }
        if (this._uripath != null) {
            PublishLogMessage.attribute(xml, "uripath", this._uripath);
        }
        if (this._started != -1L) {
            PublishLogMessage.attribute(xml, "started", String.valueOf(this._started));
        }
        if (this._target != null) {
            PublishLogMessage.attribute(xml, "target", this._target);
        }
        xml.append('>');
        if (this._content != null) {
            xml.append("<message>");
            xml.append(this._content);
            xml.append("</message>");
        }
        if (this._stacktrace != null) {
            xml.append("<stacktrace>");
            xml.append(XMLUtils.escapeText((String)this._stacktrace));
            xml.append("</stacktrace>");
        }
        xml.append("</publish>");
    }

    public static PublishLogMessage newInstance(String type, String target, String id, Group group) {
        return new PublishLogMessage(type, target, id, group);
    }

    private static void attribute(Appendable xml, String name, String value) throws IOException {
        xml.append(' ');
        xml.append(name).append('=').append('\"');
        xml.append(XMLUtils.escapeAttValue((String)value));
        xml.append('\"');
    }
}

