/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.MD5;
import com.pageseeder.common.util.Strings;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PublishEvent
implements XMLWritable,
UniversallyPrintable {
    private static final long HOUR = 3600000L;
    private final String _project;
    private String _description = null;
    private Repeat _repeatType = Repeat.HOURS;
    private int _repeatDelay = 0;
    private Date _startDate = null;
    private Date _endDate = null;
    private Date _nextDate = null;
    private Date _lastStartedDate = null;
    private String _daysOfWeek = null;
    private String _target = null;
    private String _username = null;
    private boolean _paused = false;
    private boolean _currentlyRunning = false;
    private String _processID = null;
    private String _eventID = null;
    private String _lastStatus = null;
    private boolean _manual = false;
    private final Map<String, String> parameters = new ConcurrentHashMap<String, String>();

    public PublishEvent(String project) {
        this._project = project;
        this._eventID = MD5.hash((String)("id-" + System.nanoTime())).toLowerCase();
    }

    public void setDescription(String description) {
        if (this._processID != null) {
            return;
        }
        this._description = description;
    }

    public void setRepeat(int delay, Repeat repeat) {
        if (this._processID != null) {
            return;
        }
        this._repeatDelay = delay;
        this._repeatType = repeat;
    }

    public void setDaysOfWeek(String days) {
        if (this._processID != null) {
            return;
        }
        this._daysOfWeek = days;
    }

    public void setTarget(String target) {
        if (this._processID != null) {
            return;
        }
        this._target = target;
    }

    public void setUsername(String username) {
        if (this._processID != null) {
            return;
        }
        this._username = username;
    }

    public void setStartDate(Date start) {
        if (this._processID != null) {
            return;
        }
        this._startDate = start;
    }

    public void setEndDate(Date end) {
        if (this._processID != null) {
            return;
        }
        this._endDate = end;
    }

    public void setLastStatus(String lastStatus) {
        this._lastStatus = lastStatus;
    }

    public void addParameter(String name, String value) {
        if (this._processID != null) {
            return;
        }
        this.parameters.put(name, value);
    }

    public String getProcessID() {
        return this._processID;
    }

    public String getProject() {
        return this._project;
    }

    public String getLastStatus() {
        return this._lastStatus;
    }

    public Collection<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public String getParameterValue(String param) {
        return this.parameters.get(param);
    }

    public String getID() {
        return this._eventID;
    }

    public String getDescription() {
        return this._description;
    }

    public String getTarget() {
        return this._target;
    }

    public String getUsername() {
        return this._username;
    }

    public String getDaysOfWeek() {
        return this._daysOfWeek;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public boolean isExpired() {
        return this._endDate != null && this._nextDate != null && !this._endDate.after(this._nextDate);
    }

    public Date getNextDate() {
        return this._nextDate;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Date getLastStartedDate() {
        return this._lastStartedDate;
    }

    public void setPaused(boolean paused) {
        this._paused = paused;
        if (!this._paused) {
            this.computeNextDate();
        }
    }

    public void setLastStartedDate(Date lastStartedDate) {
        this._lastStartedDate = lastStartedDate;
        this.computeNextDate();
    }

    private void computeNextDate() {
        if (this._nextDate == null) {
            this._nextDate = this._startDate;
        } else if (this._repeatDelay <= 0) {
            this._endDate = this._startDate;
        }
        if (this._repeatDelay <= 0) {
            return;
        }
        if (!(this._daysOfWeek == null || this._daysOfWeek.contains("mon") || this._daysOfWeek.contains("tue") || this._daysOfWeek.contains("wed") || this._daysOfWeek.contains("thu") || this._daysOfWeek.contains("fri") || this._daysOfWeek.contains("sat") || this._daysOfWeek.contains("sun"))) {
            throw new IllegalStateException("Event daysOfWeek is invalid: " + this._daysOfWeek);
        }
        long dayMillis = 86400000L;
        long repeatMillis = this._repeatType.toDelayMs(this._repeatDelay);
        int nbtimes = 1;
        SimpleDateFormat dayFormat = new SimpleDateFormat("EEE");
        String dayOfWeek = "-";
        boolean lastInDaylightSaving = TimeZone.getDefault().inDaylightTime(this._lastStartedDate);
        while (this._nextDate.getTime() < System.currentTimeMillis() || this._daysOfWeek != null && repeatMillis <= dayMillis && !this._daysOfWeek.contains(dayOfWeek)) {
            long delay = (long)nbtimes++ * repeatMillis;
            this._nextDate = new Date(this._lastStartedDate.getTime() + delay);
            boolean nextInDayLightSaving = TimeZone.getDefault().inDaylightTime(this._nextDate);
            if (lastInDaylightSaving && !nextInDayLightSaving) {
                this._nextDate = new Date(this._nextDate.getTime() + 3600000L);
            } else if (!lastInDaylightSaving && nextInDayLightSaving) {
                this._nextDate = new Date(this._nextDate.getTime() - 3600000L);
            }
            dayOfWeek = dayFormat.format(this._nextDate).toLowerCase().substring(0, 3);
        }
    }

    public void setCurrentlyRunning(boolean currentlyRunning) {
        if (!currentlyRunning) {
            this._processID = "id-" + MD5.hash((String)(this._description.hashCode() + "-" + System.nanoTime())).toLowerCase();
            this._manual = false;
        }
        this._currentlyRunning = currentlyRunning;
    }

    public boolean isCurrentlyRunning() {
        return this._currentlyRunning;
    }

    public boolean isPaused() {
        return this._paused;
    }

    public PublishEvent completeInitialisation() {
        if (this._startDate == null) {
            throw new IllegalStateException("No start date specified.");
        }
        if (this._description == null) {
            throw new IllegalStateException("No description specified.");
        }
        if (this._target == null) {
            throw new IllegalStateException("No publish target specified.");
        }
        this.setLastStartedDate(this._startDate);
        this._processID = "id-" + MD5.hash((String)(this._description.hashCode() + "-" + System.nanoTime())).toLowerCase();
        return this;
    }

    @Deprecated
    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("event");
        out.field("id", this._eventID);
        if (this._processID != null) {
            out.field("process-id", this._processID);
        }
        if (this._currentlyRunning) {
            out.field("running", true);
        }
        if (this.isExpired()) {
            out.field("finished", true);
        }
        if (this._paused) {
            out.field("paused", true);
        }
        out.field("project", this._project, OutputPrinter.FieldOption.XML_ELEMENT);
        out.field("start", ISO8601.DATETIME.format(this._startDate.getTime()), OutputPrinter.FieldOption.XML_ELEMENT);
        if (this._nextDate != null) {
            out.field("next", ISO8601.DATETIME.format(this._nextDate.getTime()), OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (this._endDate != null) {
            out.field("end", ISO8601.DATETIME.format(this._endDate.getTime()), OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (this._lastStatus != null) {
            out.field("status", this._lastStatus, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        out.startObject("target");
        out.field("name", this._target);
        if (!Strings.isEmpty((String)this._username)) {
            out.field("username", this._username);
        }
        out.field("description", this._description, OutputPrinter.FieldOption.XML_ELEMENT);
        out.startCollection("params", OutputPrinter.CollectionOption.JSON_ONLY);
        for (String param : this.parameters.keySet()) {
            out.startObject("param");
            out.field("name", param);
            out.field("value", this.parameters.get(param));
            out.endObject();
        }
        out.endCollection();
        out.endObject();
        out.endObject();
    }

    public boolean isManual() {
        return this._manual;
    }

    public void setManual(boolean manual) {
        this._manual = manual;
    }

    public static enum Repeat {
        DAYS(86400000L),
        HOURS(3600000L),
        MINUTES(60000L);

        private final long _factor;

        private Repeat(long factor) {
            this._factor = factor;
        }

        public long toDelayMs(int count) {
            return this._factor * (long)count;
        }
    }
}

