/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.publish.PublishJobDetails;
import com.pageseeder.publish.PublishJobs;
import com.pageseeder.publish.Publisher;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, member=true, parameters={"jobid"})
public final class Cancel
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        PublishJobDetails job = PublishJobs.getJob(req.getParameter((Parameter)StandardParameters.jobid));
        if (job == null) {
            return new ForbiddenCheck();
        }
        Member m = DatabaseQuery.getMemberByUsername((Database)req.getDatabase(), (String)job.getUsername());
        Group gp = DatabaseQuery.getGroupByName((Database)req.getDatabase(), (String)job.getGroup());
        if (m == null || gp == null) {
            return new AdminSystemCheck();
        }
        if (m.getId().equals(req.getMember().getId())) {
            return new ViewMemberCheck(m);
        }
        return new EditGroupCheck(gp);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Publisher publisher = new Publisher(Publisher.PublisherAction.CANCEL);
        publisher.setProcessID(req.getParameter((Parameter)StandardParameters.jobid));
        publisher.run();
        String response = publisher.getResponse();
        XMLWriter xml = res.getXMLWriter();
        xml.writeXML(response);
    }
}

