/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.publication.RepairPublicationsThread;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, member=true, database=true)
@PublicAPI
public final class RepairPublications
implements Generator,
SingleCheck {
    @ContentPermission(value=EditGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Group group = req.getGroup();
        if (!"false".equals(req.getParameter((Parameter)StandardParameters.start_thread))) {
            RepairPublicationsThread thread = RepairPublicationsThread.newInstance(req.getMember().getUsername(), group);
            ProcessManager manager = ProcessManager.getInstance();
            manager.start((ProcessThread)thread);
            XMLWriter xml = res.getXMLWriter();
            xml.openElement("publication-repair");
            thread.toXML(xml);
            xml.closeElement();
            res.setStatus(GeneratorStatus.ACCEPTED);
        } else {
            List publications = DatabaseQuery.getPublicationsByGroups((Database)db, Collections.singleton(group.getName()), (int)1, (int)-1);
            XMLWriter xml = res.getXMLWriter();
            xml.element("total-publications", Long.toString(publications.size()));
        }
    }
}

