/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Publication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Requires(database=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListPublicationsForMember
implements Generator,
SingleCheck,
Cacheable {
    private static final String PUBLICATIONS_LIST_ATTRIBUTE = "com.pageseeder.publication.ListPublicationsForMember.publications";
    private static final int DEFAULT_MAX_NB = 100;

    public String getETag(GeneratorRequest req) throws DatabaseException {
        List<Publication> pubs = this.loadPublications(req);
        if (pubs == null) {
            return null;
        }
        req.getHttpServletRequest().setAttribute(PUBLICATIONS_LIST_ATTRIBUTE, pubs);
        StringBuilder etag = new StringBuilder();
        for (Publication pub : pubs) {
            etag.append(pub.getRootModified()).append('|');
        }
        return MD5.hash((String)etag.toString());
    }

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        List<Publication> pubs = (List<Publication>)req.getHttpServletRequest().getAttribute(PUBLICATIONS_LIST_ATTRIBUTE);
        if (pubs == null) {
            pubs = this.loadPublications(req);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("publications");
        out.startCollection("publications", OutputPrinter.CollectionOption.JSON_ONLY);
        if (pubs != null) {
            for (Publication pub : pubs) {
                Publications.print((Publication)pub, (UniversalPrinter)out);
            }
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private List<Publication> loadPublications(GeneratorRequest req) throws DatabaseException {
        ArrayList groups = new ArrayList(new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), false).flags().keySet());
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 100L);
        return DatabaseQuery.getPublicationsByGroups((Database)req.getDatabase(), groups, (int)page, (int)pagesize);
    }
}

