/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.MD5;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.psml.toc.XRefLoopException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, uri=true, group=true)
@Output(types={OutputType.XML})
public final class GetTOC
implements Generator,
SingleCheck,
Cacheable {
    private static final String PUBLICATIONS_LIST_ATTRIBUTE = "com.pageseeder.publication.GetTOC.publications";

    public String getETag(GeneratorRequest req) throws DatabaseException {
        List<Publication> publications = this.loadPublications(req);
        if (publications == null) {
            return null;
        }
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        if (publicationid == null) {
            publicationid = req.getHttpServletRequest().getParameter("publicationid");
        }
        boolean documenttoc = req.getParameter((Parameter)StandardParameters.documenttoc, false);
        int position = (int)req.getParameter((Parameter)StandardParameters.position, 1L);
        boolean reloadtoc = req.getParameter((Parameter)StandardParameters.reload, false);
        boolean loadall = req.getParameter((Parameter)StandardParameters.loadall, false);
        String version = req.getParameter((Parameter)StandardParameters.version);
        req.getHttpServletRequest().setAttribute(PUBLICATIONS_LIST_ATTRIBUTE, publications);
        StringBuilder etag = new StringBuilder();
        etag.append("pubid:").append(publicationid).append('|');
        etag.append("dtoc:").append(documenttoc).append('|');
        etag.append("pos:").append(position).append('|');
        etag.append("load:").append(reloadtoc).append('|');
        etag.append("all:").append(loadall).append('|');
        if (version != null) {
            return MD5.hash((String)etag.toString());
        }
        etag.append("urimod:").append(req.getURI().getLastModified().getTime()).append('|');
        boolean first = true;
        for (Publication pub : publications) {
            etag.append("mod:").append(pub.getRootModified().getTime()).append('|');
            if (publicationid != null && publicationid.equals(pub.getId()) || publicationid == null && first) {
                if (reloadtoc) {
                    etag.append("toc:0|");
                } else {
                    try {
                        NumberedTOC toc = PublicationManager.singleton().getNumberedTOC(req.getDatabase(), pub, true);
                        etag.append("toc:").append(toc == null ? 0L : toc.getLastUpdated().getTime()).append('|');
                    }
                    catch (XRefLoopException xRefLoopException) {
                        // empty catch block
                    }
                }
            }
            first = false;
        }
        return MD5.hash((String)etag.toString());
    }

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        block24: {
            String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
            if (publicationid == null) {
                publicationid = req.getHttpServletRequest().getParameter("publicationid");
            }
            boolean documenttoc = req.getParameter((Parameter)StandardParameters.documenttoc, false);
            int position = (int)req.getParameter((Parameter)StandardParameters.position, 1L);
            boolean reloadtoc = req.getParameter((Parameter)StandardParameters.reload, false);
            boolean loadall = req.getParameter((Parameter)StandardParameters.loadall, false);
            boolean loadparas = req.getParameter((Parameter)StandardParameters.loadparas, false);
            String version = req.getParameter((Parameter)StandardParameters.version);
            URI uri = req.getURI();
            Group group = req.getGroup();
            Database db = req.getDatabase();
            List<Publication> publications = (List<Publication>)req.getHttpServletRequest().getAttribute(PUBLICATIONS_LIST_ATTRIBUTE);
            if (publications == null) {
                publications = this.loadPublications(req);
            }
            if (publications == null) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load publications");
                return;
            }
            Publication version_pub = Publications.findValidURIVersionPublication((Database)db, (String)publicationid, (String)version, (URI)uri, (Group)group);
            XMLWriter xml = res.getXMLWriter();
            xml.openElement("toc");
            try {
                if (publications.isEmpty()) {
                    if (version_pub != null) {
                        Publications.print((Publication)version_pub, (UniversalPrinter)new UniversalPrinter((OutputPrinter)new XMLOutputPrinter(xml)), (boolean)false);
                        try {
                            this.outputPublicationToc(version_pub, uri, group, version, documenttoc, loadparas, position, loadall, db, reloadtoc, xml);
                            break block24;
                        }
                        finally {
                            xml.closeElement();
                        }
                    }
                    this.outputStandAloneToc(uri, group, version, loadparas, db, xml);
                    break block24;
                }
                boolean first = true;
                if (version_pub != null && !publications.contains(version_pub)) {
                    Publications.print((Publication)version_pub, (UniversalPrinter)new UniversalPrinter((OutputPrinter)new XMLOutputPrinter(xml)), (boolean)false);
                    try {
                        this.outputPublicationToc(version_pub, uri, group, version, documenttoc, loadparas, position, loadall, db, reloadtoc, xml);
                    }
                    finally {
                        xml.closeElement();
                    }
                    first = false;
                } else if ("".equals(publicationid)) {
                    this.outputStandAloneToc(uri, group, version, loadparas, db, xml);
                }
                for (Publication pub : publications) {
                    Publications.print((Publication)pub, (UniversalPrinter)new UniversalPrinter((OutputPrinter)new XMLOutputPrinter(xml)), (boolean)false);
                    try {
                        if (publicationid != null && publicationid.equals(pub.getId()) || publicationid == null && first) {
                            this.outputPublicationToc(pub, uri, group, version, documenttoc, loadparas, position, loadall, db, reloadtoc, xml);
                        }
                    }
                    finally {
                        xml.closeElement();
                    }
                    first = false;
                }
            }
            catch (XRefLoopException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.XREF_LOOP, ex.getMessage());
            }
            finally {
                xml.closeElement();
            }
        }
    }

    private void outputPublicationToc(Publication pub, URI uri, Group group, @Nullable String version, boolean documenttoc, boolean loadparas, int position, boolean loadall, Database db, boolean reloadtoc, XMLWriter xml) throws XRefLoopException, DatabaseException, IOException {
        PublicationTree pubtree;
        PublicationManager pubmanager = PublicationManager.singleton();
        if (reloadtoc) {
            pubmanager.reloadPublicationConfig(group, pub.getType());
            String globalTemplate = GlobalSettings.getGlobalTemplate();
            if (!Strings.isEmpty((String)globalTemplate)) {
                pubmanager.reloadPublicationConfig(globalTemplate, pub.getType());
            }
            if (version != null) {
                pubmanager.clearCachedTOCVersion(pub, version);
            } else {
                pubmanager.getNumberedTOC(db, pub, true);
                pubmanager.clearCachedTOC(pub);
            }
        }
        NumberedTOC toc = version != null && !"".equals(version) && !"current".equals(version) ? pubmanager.getNumberedTOC(db, pub, version, uri) : pubmanager.getNumberedTOC(db, pub, true);
        PublicationTree publicationTree = pubtree = toc == null ? null : toc.getPublicationTree();
        if (pubtree != null && pubtree.id() == pub.getRootURIId()) {
            PublicationConfig pubconfig = pubmanager.getPublicationConfig(group, pub.getType());
            if (loadparas) {
                pubconfig = pubconfig.clone();
                pubconfig.setTocParaIndents("0,1,2,3,4,5,6");
            }
            pubtree.toXML(xml, loadall ? -1L : uri.getId(), documenttoc && !loadall ? position : -1, toc.getFragmentNumbering(), pubconfig, false);
        }
    }

    private void outputStandAloneToc(URI uri, Group group, String version, boolean loadparas, Database db, XMLWriter xml) throws XRefLoopException, IOException {
        PublicationManager pubmanager = PublicationManager.singleton();
        DocumentTree doctree = pubmanager.parseDocument(db, uri.getId().longValue(), group, true, version, null);
        if (doctree != null) {
            PublicationConfig pubconfig = pubmanager.getPublicationConfig(group, "default");
            if (loadparas) {
                pubconfig = pubconfig.clone();
                pubconfig.setTocParaIndents("0,1,2,3,4,5,6");
            }
            PublicationTree pubtree = new PublicationTree(doctree.normalize(pubconfig.getTocTitleCollapse()));
            FragmentNumbering numbering = new FragmentNumbering(pubtree, pubconfig);
            pubtree.toXML(xml, -1L, -1, numbering, pubconfig, true);
        }
    }

    private List<Publication> loadPublications(GeneratorRequest req) throws QueryFailedException {
        UserDetails userdetails = req.getMember() == null ? SecurityUtils.getDefaultUserDetails() : new UserDetailsManager().get(req.getDatabase(), req.getMember().getId());
        return Publications.getAncestorPublications((Database)req.getDatabase(), (URI)req.getURI(), (UserDetails)userdetails);
    }
}

