/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

@Requires(database=true, group=true, parameters={"publicationid"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class DeletePublication
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Publication pub = this.loadPublication(req);
        if (pub == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Invalid publicationid");
        } else {
            URI uri;
            Set publicationURIs = Publications.delete((Database)db, (Publication)pub);
            if (pub.getRootURIId() != -1L && (uri = DatabaseQuery.getURIById((Database)db, (Long)pub.getRootURIId())) != null) {
                uri.setLastModified(new Date());
            }
            req.getTransaction().commitAndStart();
            ChangesManager manager = ChangesManager.getInstance();
            manager.deletePublication(db, null, pub, (Collection)publicationURIs);
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("publication-delete");
            Publications.print((Publication)pub, (UniversalPrinter)out);
            out.endObject();
            out.flush();
        }
    }

    private Publication loadPublication(GeneratorRequest req) throws DatabaseException {
        Host host = GroupURIRule.getDefaultGroupURI((Group)req.getGroup()).getHost();
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        Publication pub = DatabaseQuery.getPublicationByPublicationIDHost((Database)req.getDatabase(), (String)publicationid, (Host)host);
        if (pub == null) {
            pub = DatabaseQuery.getPublicationByPublicationNoHost((Database)req.getDatabase(), (String)publicationid);
        }
        return pub;
    }
}

