/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddVersionCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.psml.mediator.DocumentMediator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(uri=true, group=true, member=true, parameters={"versionid"})
public final class RevertDocument
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevertDocument.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)(URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new AddVersionCheck(req.getGroup(), req.getURI())));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        boolean updated;
        URI uri = req.getURI();
        Group group = req.getGroup();
        Member author = req.getMember();
        Database db = req.getDatabase();
        Long versionid = req.getParameter((Parameter)StandardParameters.versionid, -1L);
        boolean overwriteProperties = "true".equals(req.getParameter((Parameter)StandardParameters.overwrite_properties, "false"));
        XLink version = null;
        if (versionid != 0L && (version = DatabaseQuery.getXLinkById((Database)db, (Long)versionid)) == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Version ID not found: " + versionid);
            return;
        }
        DocumentMediator mediator = new DocumentMediator(group, uri, author, db);
        mediator.setCreateXRefs(true);
        mediator.setEditMetadata(true);
        try {
            updated = mediator.mediateDocument(this.getContent(versionid, uri, group, db), this.getContent(null, uri, group, db));
        }
        catch (URIException ex) {
            LOGGER.error("Failed to load content for document {} in group {}", new Object[]{uri.getId(), group.getName(), ex});
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document content.");
            return;
        }
        ArrayList<String> errors = new ArrayList<String>(mediator.getErrors());
        ArrayList<String> warnings = new ArrayList<String>(mediator.getWarnings());
        XLink root = uri.getXLink();
        if (overwriteProperties && root != null) {
            XLink correctOne;
            if (versionid == 0L) {
                correctOne = root;
            } else {
                List reps = DatabaseQuery.getRepliesByGroupContentRoleDates((Database)db, (XLink)root, (Long)group.getId(), (String[])new String[]{"uri-properties"}, null, null, (Date)version.getDate());
                correctOne = reps.stream().reduce((a, b) -> b).orElse(root);
            }
            boolean bl = updated = this.setProperties(uri, correctOne, db, warnings) || updated;
        }
        String version_title = versionid == 0L ? "original" : (XLinks.isVersion((XLink)version) && version.getContentTitle() != null ? version.getContentTitle() : ISO8601.format((long)version.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
        URIRule.addURIHistoryXLink((URI)uri, (Member)author, null, null, (String)"revert", null, null, (String)version_title, (Database)db);
        if (updated) {
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            Publications.updateURI((URI)uri);
            for (Long uriid : mediator.getEmbedTargetUris()) {
                Publications.updateURI((Long)uriid);
            }
            ChangesManager changes = ChangesManager.getInstance();
            ChangesBatch batch = new ChangesBatch("Reverting document " + uri.getDecodedPath());
            changes.startBatch(db, batch);
            changes.modifyURI(db, batch, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
            for (Long uriid : mediator.getTargetTranscludingUris()) {
                URI turi = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                changes.modifyURI(db, batch, turi, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)turi.getId()));
            }
            changes.completeBatch(db, batch);
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("document-revert");
        xml.attribute("modified", updated ? "true" : "false");
        if (!errors.isEmpty()) {
            xml.openElement("errors");
            for (String error : errors) {
                xml.element("error", error);
            }
            xml.closeElement();
        }
        if (!warnings.isEmpty()) {
            xml.openElement("warnings");
            for (String warning : warnings) {
                xml.element("warning", warning);
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    private InputStream getContent(Long versionid, URI uri, Group group, Database db) throws URIException {
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        resolver.setPSMLFormat(true);
        if (versionid != null) {
            resolver.setReleaseId(versionid);
        }
        return resolver.getContent(db);
    }

    private boolean setProperties(URI uri, XLink from, Database db, List<String> warnings) {
        String newDocID;
        String newDescription;
        String oldDescription;
        String newTitle;
        String[] newLabels;
        boolean changed = false;
        String[] oldLabels = Labels.getLabels((URI)uri);
        if (Labels.labelsAreDifferent((String[])oldLabels, (String[])(newLabels = Labels.getLabels((XLink)from)))) {
            Labels.setLabels((URI)uri, (String[])newLabels);
            changed = true;
        }
        Map props = ObjectProperties.toMap((String)from.getProperties());
        String oldTitle = uri.getUserTitle();
        if (RevertDocument.differentStrings(oldTitle, newTitle = from.getContentTitle())) {
            uri.setUserTitle(newTitle);
            changed = true;
        }
        if (RevertDocument.differentStrings(oldDescription = uri.getDescription(), newDescription = props.getOrDefault("description", Collections.singletonList("")).get(0))) {
            uri.setDescription(newDescription);
            changed = true;
        }
        changed = this.setDocumentID(newDocID = props.getOrDefault("docid", Collections.singletonList("")).get(0), uri, db, warnings) || changed;
        return changed;
    }

    private static boolean differentStrings(@Nullable String a, @Nullable String b) {
        if (a == null || a.isEmpty()) {
            return b != null && !b.isEmpty();
        }
        return b == null || b.isEmpty() || !a.equals(b);
    }

    private boolean setDocumentID(@Nullable String newDocID, URI uri, Database db, List<String> warnings) {
        URI otherURI;
        String oldDocID = uri.getDocID();
        if (!RevertDocument.differentStrings(newDocID, oldDocID)) {
            return false;
        }
        try {
            otherURI = newDocID == null ? null : DatabaseQuery.getUriByHostDocumentID((Database)db, (String)uri.getHost().getName(), (String)newDocID);
        }
        catch (QueryFailedException ex) {
            warnings.add("Failed to set document ID: " + ex.getMessage());
            return false;
        }
        if (otherURI != null) {
            warnings.add("Removing existing Document ID (" + newDocID + ") of document \"" + otherURI.getDecodedPath() + "\"");
            otherURI.setDocID(null);
            otherURI.setLastModified(new Date());
        }
        uri.setDocID(newDocID);
        if (oldDocID != null) {
            if (newDocID == null) {
                warnings.add("Removing existing Document ID (" + oldDocID + ") of document \"" + uri.getDisplayTitle() + "\"");
            } else {
                warnings.add("Changing the existing Document ID (" + oldDocID + ") of document \"" + uri.getDisplayTitle() + "\" to the new Document ID \"" + newDocID + "\"");
            }
        }
        return true;
    }
}

