/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class LabelsContentHandler
extends DefaultHandler {
    private static final String LABELS_ATTRIBUTE = "labels";
    private XMLWriter xml = null;
    private String fragLabels;

    LabelsContentHandler(Writer output, @Nullable String labels) {
        this.xml = new XMLWriterNSImpl(output);
        this.fragLabels = labels;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.xml.setPrefixMapping(uri, prefix);
    }

    @Override
    public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
        boolean isFragment = PSMLContentUtils.isFragmentElement((String)lName);
        try {
            this.xml.openElement(Strings.isEmpty((String)uri) ? null : uri, lName, true);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.xml.attribute(Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
            }
            if (isFragment) {
                if (atts.getValue(LABELS_ATTRIBUTE) == null && this.fragLabels != null && !this.fragLabels.isEmpty()) {
                    this.xml.attribute(LABELS_ATTRIBUTE, this.fragLabels);
                }
                this.fragLabels = null;
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + lName, ex);
        }
    }

    @Override
    public void endElement(String uri, String lName, String qName) throws SAXException {
        try {
            this.xml.closeElement();
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close element " + lName, ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.xml.writeText(ch, start, length);
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }
}

