/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelConfigManager;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.url.URLFiles;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.PSML;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.url.URLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Requires(group=true)
public final class GetConfig
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetConfig.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, GeneratorException {
        String config;
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = req.getGroup();
        String template = GroupRule.getTemplate((Group)group);
        String ext = req.getParameter((Parameter)StandardParameters.extension, "");
        String type = req.getParameter((Parameter)StandardParameters.documenttype, "");
        String urltype = req.getParameter((Parameter)StandardParameters.urltype, "");
        String mediatype = req.getParameter((Parameter)StandardParameters.mediatype, "");
        String urlString = req.getParameter((Parameter)StandardParameters.url, "");
        URL url = null;
        if (!urlString.isEmpty()) {
            try {
                url = RuleUtils.urlEncodeNormalize((String)urlString);
            }
            catch (MalformedURLException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_URL);
                return;
            }
        }
        File xrefConfigs = GetConfig.findProjectXRefConfig(template);
        XMLWriter xml = res.getXMLWriter();
        if (URIs.isExternal((URI)uri) || uri == null && (!urltype.isEmpty() || !mediatype.isEmpty() && url != null)) {
            if (uri != null) {
                urltype = URIRule.getStyleConfig((URI)uri);
            } else if (urltype.isEmpty()) {
                try {
                    URLConfig config2 = URLUtils.findURLConfig(url, null, mediatype);
                    if (config2 != null) {
                        urltype = config2.getURLType();
                    }
                }
                catch (FoundationException e) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.INVALID_PSML_CONFIG_FILE, "Failed to load URL config file for mediatype " + mediatype);
                    return;
                }
            }
            if (Strings.isEmpty((String)urltype)) {
                urltype = "default";
            }
            String folder = "url" + File.separator + urltype;
            xml.openElement("url-type");
            xml.attribute("definedby", String.join((CharSequence)",", PSMLFiles.listDefinedBy((String)template, (String)folder)));
            xml.attribute("name", urltype);
            if (xrefConfigs != null && xrefConfigs.exists()) {
                GetConfig.includeFile(xml, xrefConfigs, "xref-config.xml");
            }
            try {
                String owner = GlobalSettings.getGlobalTemplate((String)"default");
                LabelConfig labels = LabelConfigManager.getLabelConfig((String)owner);
                URLConfig config3 = URLFiles.loadURLConfig((String)urltype, (LabelConfig)labels);
                if (config3 != null) {
                    XMLOutputPrinter out = new XMLOutputPrinter(xml);
                    config3.print((OutputPrinter)out);
                    out.flush();
                }
            }
            catch (FoundationException | SAXException ex) {
                LOGGER.error("Failed to load label config", ex);
            }
            GetConfig.includeFile(xml, template, folder, "url-template.psml");
            GetConfig.includeFile(xml, template, folder, "editor-config.xml");
            xml.closeElement();
            return;
        }
        if (uri != null && !URIRule.isPSML((URI)uri) || uri == null && !ext.isEmpty()) {
            if (uri != null) {
                ext = PSML.getFileExtension(uri);
            }
            String folder = "document" + File.separator + ext;
            xml.openElement("document-extension");
            xml.attribute("definedby", String.join((CharSequence)",", PSMLFiles.listDefinedBy((String)template, (String)folder)));
            xml.attribute("name", ext);
            if (xrefConfigs != null && xrefConfigs.exists()) {
                GetConfig.includeFile(xml, xrefConfigs, "xref-config.xml");
            }
            GetConfig.includeFile(xml, template, folder, "media-template.psml");
            GetConfig.includeFile(xml, template, folder, "editor-config.xml");
            try {
                LabelConfig labels = LabelConfigManager.getLabelConfig((String)template);
                XMLOutputPrinter out = new XMLOutputPrinter(xml);
                labels.print((OutputPrinter)out);
                out.flush();
            }
            catch (SAXException ex) {
                LOGGER.error("Failed to load label config", (Throwable)ex);
            }
            xml.closeElement();
            return;
        }
        if (uri != null) {
            type = URIRule.getStyleConfig((URI)uri);
        }
        if (Strings.isEmpty((String)type)) {
            type = "default";
        }
        LabelConfig labelConfig = null;
        try {
            labelConfig = LabelConfigManager.getLabelConfig((String)template);
        }
        catch (SAXException ex) {
            throw new GeneratorException("Unable to load project labels", (Throwable)ex);
        }
        UserDetailsManager user_manager = new UserDetailsManager();
        UserDetails userdetails = user_manager.get(db, req.getMember().getId());
        Role role = MemberRule.isApproverForGroup((UserDetails)userdetails, (String)group.getName()) ? Role.APPROVER : (MemberRule.isManagerForGroup((UserDetails)userdetails, (String)group.getName()) ? Role.MANAGER : (MemberRule.isContributorForGroup((UserDetails)userdetails, (String)group.getName()) ? Role.CONTRIBUTOR : Role.REVIEWER));
        try {
            config = PSMLFiles.findDocumentConfig((String)template, (String)type, (LabelConfig)labelConfig, (Role)role);
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Invalid document config file: " + ex.getMessage());
            return;
        }
        String folder = "psml" + File.separator + type;
        xml.openElement("document-type");
        xml.attribute("definedby", String.join((CharSequence)",", PSMLFiles.listDefinedBy((String)template, (String)folder)));
        xml.attribute("name", type);
        String css = PSMLFiles.findCSS((String)template, (String)type);
        if (css != null) {
            xml.attribute("css", css);
        }
        if (config != null) {
            xml.writeXML(config);
        }
        if (xrefConfigs != null && xrefConfigs.exists()) {
            GetConfig.includeFile(xml, xrefConfigs, "xref-config.xml");
        }
        GetConfig.includeFile(xml, template, folder, "document-template.psml");
        GetConfig.includeFile(xml, template, folder, "editor-config.xml");
        xml.closeElement();
    }

    public static void includeFile(XMLWriter xml, String template, String folder, String filename) throws IOException {
        TemplateFiles resources = new TemplateFiles(template);
        File config = resources.findFile(folder + File.separator + filename);
        if (config != null) {
            GetConfig.includeFile(xml, config, filename);
        }
    }

    public static void includeFile(XMLWriter xml, File file, String filename) throws IOException {
        boolean exists;
        String nodetype;
        block8: {
            String nodename = filename.substring(0, filename.lastIndexOf(46)).toLowerCase();
            nodetype = filename.substring(nodename.length() + 1);
            boolean bl = exists = file.exists() && file.length() > 0L;
            if (!"xml".equals(nodetype) || !exists) {
                xml.openElement(nodename);
                if (nodetype != null) {
                    xml.attribute("type", nodetype);
                }
            }
            if (exists) {
                try {
                    String xmlContent = GetConfig.toXMLWithDeclaration(file);
                    if (nodetype == null || "xml".equals(nodetype) || "sch".equals(nodetype) || "psml".equals(nodetype)) {
                        xml.writeXML(xmlContent);
                        break block8;
                    }
                    xml.writeXML("<![CDATA[");
                    xml.writeXML(xmlContent);
                    xml.writeXML("]]>");
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to add config file", (Throwable)ex);
                }
            } else {
                xml.attribute("unspecified", "true");
            }
        }
        if (!"xml".equals(nodetype) || !exists) {
            xml.closeElement();
        }
    }

    protected static File findProjectXRefConfig(String template) {
        if (Template.isDefault((String)template)) {
            return null;
        }
        return TemplateFiles.findFile((Template)new Template(template), (File)new File(Settings.getContextPath()), (String)"config/xref-config.xml");
    }

    private static String toXMLWithDeclaration(File file) throws IOException {
        int bufferSize = 8192;
        StringWriter xmlWriter = new StringWriter();
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buffer = new byte[8192];
            int read = in.read(buffer);
            while (read != -1) {
                xmlWriter.write(new String(buffer, 0, read, StandardCharsets.UTF_8));
                read = in.read(buffer);
            }
        }
        xmlWriter.close();
        String xmlContent = xmlWriter.toString().trim();
        if (xmlContent.startsWith("<?xml ")) {
            xmlContent = xmlContent.substring(xmlContent.indexOf(62) + 1);
        }
        return xmlContent;
    }
}

