/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLContentResolver;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.HTMLSanitizer;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.IncomingContentHandler;
import com.pageseeder.psml.PSML;
import com.pageseeder.ws.ChannelManager;
import com.pageseeder.xref.XRefException;
import com.pageseeder.xref.XRefMediator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.md.BlockParser;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class FragmentEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentEditor.class);
    private static Templates theHTMLToPSMLTemplates = null;
    private final URI uri;
    private final String fragment;
    private final Group group;
    private Collection<Group> uriGroups = null;
    private Collection<Group> editGroups = null;
    private final Member author;
    private boolean html = false;
    private boolean markdown = false;
    private String notesContent = null;
    private String notesTitle = null;
    private String[] notesLabels = null;
    private boolean draft = false;
    private Status status = Status.NOT_MODIFIED;
    private XLink createdEdit = null;
    private final Collection<String> errors = new ArrayList<String>();

    public FragmentEditor(URI u, String frag, Member mem, Group grp) {
        this.uri = u;
        this.fragment = frag;
        this.author = mem;
        this.group = grp;
    }

    private static Templates createTemplates() throws IOException {
        if (theHTMLToPSMLTemplates == null) {
            try {
                theHTMLToPSMLTemplates = XMLHelpers.safeTransformerFactory().newTemplates(new StreamSource(FragmentEditor.class.getResourceAsStream("/" + FragmentEditor.class.getPackage().getName().replace('.', '/') + "/html-to-psml.xsl")));
            }
            catch (TransformerConfigurationException e) {
                throw new IOException("Failed to load HTML to PSML stylesheet: " + e.getMessageAndLocation(), e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new IOException("Failed to load HTML to PSML stylesheet", e);
            }
        }
        return theHTMLToPSMLTemplates;
    }

    public void setHTMLTransform(boolean ishtml) {
        this.html = ishtml;
    }

    public void setMarkdown(boolean ismarkdown) {
        this.markdown = ismarkdown;
    }

    public void setDraft(boolean isdraft) {
        this.draft = isdraft;
    }

    public void setNotes(String content, String title, String[] labels) {
        this.notesContent = content;
        this.notesTitle = title;
        this.notesLabels = labels;
    }

    public Status getStatus() {
        return this.status;
    }

    public XLink getCreatedEdit() {
        return this.createdEdit;
    }

    public Collection<Group> getEditGroups() {
        return this.editGroups;
    }

    public Collection<Group> getURIGroups() {
        return this.uriGroups;
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    public void edit(Database db, String origContent, String contentType, @Nullable String fragmentType, String[] labels, boolean createOriginal) throws DatabaseException, IOException {
        String fragtype;
        this.loadGroups(db);
        if (this.status != Status.NOT_MODIFIED) {
            return;
        }
        String content = origContent;
        if (this.markdown) {
            if ((content = this.markdownToPSML(content)) == null) {
                this.status = Status.UNKNOWN_ERROR;
                return;
            }
        } else if (this.html && (content = this.handleHTML(content)) == null) {
            this.status = Status.UNKNOWN_ERROR;
            return;
        }
        LOGGER.debug("PSML:\n{}", (Object)content);
        StringWriter newcontent = new StringWriter();
        IncomingContentHandler handler = new IncomingContentHandler(newcontent, this.fragment, fragmentType);
        try {
            XMLHelpers.parse((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (ContentHandler)handler);
        }
        catch (FoundationException ex) {
            this.status = Status.VALIDATION_ERROR;
            this.errors.add("Failed to parse incoming content: " + ex.getMessage());
            return;
        }
        content = newcontent.toString().trim();
        if (handler.isMetadata() && !"default".equals(this.fragment) || !handler.isMetadata() && "default".equals(this.fragment)) {
            this.status = Status.VALIDATION_ERROR;
            this.errors.add("Only metadata properties can be on default fragment.");
            return;
        }
        String mediatype = handler.getLoadedMediaType() == null ? contentType : handler.getLoadedMediaType();
        String string = fragtype = handler.getLoadedFragType() == null ? fragmentType : handler.getLoadedFragType();
        if (!"application/vnd.pageseeder.psml+xml".equals(mediatype)) {
            if (RuleUtils.isXMLMediaType((String)mediatype)) {
                String tovalidate = "<media-fragment id='" + XML.escapeAttr((String)this.fragment) + "'";
                if (fragtype != null) {
                    tovalidate = tovalidate + " type='" + fragtype + "'";
                }
                if (mediatype != null) {
                    tovalidate = tovalidate + " mediatype='" + mediatype + "'";
                }
                if (!this.validate(tovalidate = tovalidate + ">" + content + "</media-fragment>")) {
                    return;
                }
            }
        } else {
            String root = handler.getRootElement();
            if (!("fragment".equals(root) || "xref-fragment".equals(root) || "properties-fragment".equals(root) || "properties".equals(root) && "default".equals(this.fragment))) {
                this.status = Status.VALIDATION_ERROR;
                this.errors.add("Root element must be one of <fragment>, <xref-fragment>, <properties-fragment>, <media-fragment mediatype=\"x\"> or <properties> (for default fragment)");
                return;
            }
            if (!this.validate(content)) {
                return;
            }
        }
        Date creationDate = new Date();
        if (createOriginal) {
            try {
                this.ensureOriginalEdit(this.uri.getDateCreated(), db);
            }
            catch (FoundationException ex) {
                this.status = Status.UNKNOWN_ERROR;
                this.errors.add("Failed to load fragment's original content: " + ex.getMessage());
                return;
            }
        }
        Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)this.uri, (String)this.fragment);
        if (!this.draft && "application/vnd.pageseeder.psml+xml".equals(mediatype)) {
            XRefMediator mediator = new XRefMediator(this.group, this.uri, this.author, creationDate, db);
            mediator.setCreateEdit(false);
            mediator.setFailOnFirstError(true);
            try {
                String updatedcontent;
                mediator.mediateFragment(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), loc);
                if (!mediator.getErrors().isEmpty()) {
                    this.errors.addAll(mediator.getErrors());
                }
                if ((updatedcontent = mediator.getNewFragmentContent()) != null) {
                    content = updatedcontent;
                }
            }
            catch (XRefException e) {
                this.errors.add(e.getMessage());
                this.status = Status.XREF_ERROR;
                return;
            }
        }
        this.createEdit("Documentation", content, mediatype, fragtype, labels, loc, creationDate, db);
    }

    public void delete(Database db) throws DatabaseException {
        this.loadGroups(db);
        if (this.status != Status.NOT_MODIFIED) {
            return;
        }
        Date creationDate = new Date();
        try {
            this.ensureOriginalEdit(this.uri.getDateCreated(), db);
        }
        catch (FoundationException ex) {
            this.status = Status.UNKNOWN_ERROR;
            this.errors.add("Failed to load fragment's original content: " + ex.getMessage());
            return;
        }
        Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)this.uri, (String)this.fragment);
        XRefMediator mediator = new XRefMediator(this.group, this.uri, this.author, creationDate, db);
        mediator.setCreateEdit(false);
        mediator.setFailOnFirstError(true);
        try {
            String content = "<fragment />";
            mediator.mediateFragment(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), loc);
            if (!mediator.getErrors().isEmpty()) {
                this.errors.addAll(mediator.getErrors());
                this.status = Status.XREF_ERROR;
                return;
            }
        }
        catch (XRefException e) {
            this.errors.add(e.getMessage());
            this.status = Status.XREF_ERROR;
            return;
        }
        this.createEdit("Documentation-Hidden", "Content Deleted", "text/plain", null, null, loc, creationDate, db);
        XLinkRule.archiveReverseXRefsForFragment((Database)db, (URI)this.uri, (String)this.fragment, (Group)this.group, (Date)creationDate);
    }

    private void createEdit(String role, String content, String contentType, String fragmentType, String[] labels, Locator loc, Date creationDate, Database db) throws DatabaseException {
        XLink xltemp;
        if (!this.draft) {
            Iterator nonOldLinks = null;
            nonOldLinks = loc.getXLinksForLocator((Object)Predicates.predicateLocatorForXLinkByGroupContentrolesAndNotStatuses((Database)db, (Long)this.group.getId(), (String[])new String[]{"Documentation", "Documentation-Original", "Documentation-Hidden", "Documentation-Deleted"}, (String[])new String[]{"Documentation-Draft", "Documentation-Old"}));
            while (nonOldLinks.hasNext()) {
                XLink xl = ((LocatorForXLink)nonOldLinks.next()).getXLink();
                xl.setStatus("Documentation-Old");
            }
        }
        String theStatus = this.draft ? "Documentation-Draft" : null;
        Iterator xltemps = DatabaseQuery.getXLinksByDraftGroupLocatorMember((Database)db, (Long)this.group.getId(), (Long)loc.getId(), (Long)this.author.getId(), (boolean)true);
        XLink xLink = xltemp = xltemps.hasNext() ? (XLink)xltemps.next() : null;
        if (xltemp != null && "Documentation-Draft".equals(xltemp.getStatus()) && this.draft) {
            this.updateEditXLink(xltemp, "Document Change", role, theStatus, this.editGroups, labels, content, contentType, creationDate, db);
            this.status = Status.OK;
            this.createdEdit = xltemp;
            ChannelManager.get().publishFragmentEvent(this.uri.getId(), this.fragment, this.author, this.createdEdit, "save-draft");
            return;
        }
        if (xltemp != null) {
            XLinkRule.deleteXLink((Database)db, (XLink)xltemp);
        }
        this.createdEdit = this.createEditXLink("Document Change", role, theStatus, this.editGroups, labels, content, contentType, creationDate, db);
        PSMLContentUtils.setFragmentType((XLink)this.createdEdit, (String)fragmentType);
        XLink notesXl = this.createNotes(this.editGroups, db);
        if (notesXl != null) {
            this.createdEdit.addReplies(notesXl);
        }
        ChannelManager.get().publishFragmentEvent(this.uri.getId(), this.fragment, this.author, this.createdEdit, this.draft ? "save-draft" : "save");
        this.status = Status.OK;
    }

    private XLink createEditXLink(String title, String role, String astatus, Collection<Group> grpc, String[] labels, String content, String contentType, Date date, Database db) throws DatabaseException {
        XLink xl = XLink.create((Database)db);
        xl.setContentRole(role);
        xl.setAccepted(Boolean.valueOf(true));
        xl.setModeratorOnly(Boolean.valueOf(false));
        xl.setContentTitle(title);
        xl.setMember("Documentation-Original".equals(role) ? URIRule.getOriginalAuthor((URI)this.uri, (Database)db) : this.author);
        xl.setDate(date == null ? new Date() : date);
        Labels.setLabels((XLink)xl, (String[])labels);
        xl.setStatus(astatus);
        XLinkRule.addGroups((Database)db, (XLink)xl, grpc);
        Content cont = Content.create((Database)db);
        cont.setType(contentType);
        cont.setData(content);
        xl.addContents(cont);
        xl = xl.insert(db);
        XLinkRule.addXLink((Database)db, (XLink)xl, (URI)this.uri, (String)this.fragment, null);
        return xl;
    }

    public void updateEditXLink(XLink xl, String title, String role, String theStatus, Collection<Group> grpc, String[] labels, String content, String contentType, Date date, Database db) throws DatabaseException {
        boolean note_required;
        xl.setContentRole(role);
        xl.setContentTitle(title);
        xl.setDate(date == null ? new Date() : date);
        Labels.setLabels((XLink)xl, (String[])labels);
        xl.setStatus(theStatus);
        XLinkRule.modifyGroups((Database)db, (XLink)xl, grpc);
        Content currentContent = null;
        Iterator conts = xl.getContents();
        if (conts.hasNext()) {
            currentContent = (Content)conts.next();
        } else {
            currentContent = Content.create((Database)db);
            xl.addContents(currentContent);
        }
        currentContent.setData(content);
        currentContent.setType(contentType);
        Iterator notei = xl.getReplies();
        boolean bl = note_required = this.notesContent != null || this.notesLabels != null;
        if (notei.hasNext() && !note_required) {
            XLinkRule.deleteXLink((Database)db, (XLink)((XLink)notei.next()));
        } else if (notei.hasNext()) {
            XLink note = (XLink)notei.next();
            note.setContentRole("Documentation-Note");
            note.setContentTitle(this.notesTitle == null ? "Edit note" : this.notesTitle);
            note.setDate(date == null ? new Date() : date);
            Labels.setLabels((XLink)note, (String[])this.notesLabels);
            XLinkRule.modifyGroups((Database)db, (XLink)note, grpc);
            Content noteContent = null;
            Iterator nconts = note.getContents();
            if (nconts.hasNext()) {
                noteContent = (Content)nconts.next();
            } else {
                noteContent = Content.create((Database)db);
                note.addContents(noteContent);
            }
            noteContent.setType("text/plain");
            noteContent.setData(this.notesContent);
        } else {
            XLink note = this.createNotes(this.editGroups, db);
            if (note != null) {
                xl.addReplies(note);
            }
        }
    }

    private void loadGroups(Database db) throws DatabaseException {
        if (this.uriGroups == null) {
            if (URIs.isExternal((URI)this.uri)) {
                this.uriGroups = Collections.singletonList(this.group);
                this.editGroups = this.uriGroups;
                return;
            }
            Collection grpc = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)this.uri.getId());
            this.uriGroups = GroupRule.removePublicGroup((Collection)grpc);
            this.editGroups = Collections.singletonList(GroupRule.getEditGroup((Database)db, (Group)this.group, (URI)this.uri));
            return;
        }
    }

    public @Nullable XLink ensureOriginalEdit(Date creationDate, Database db) throws FoundationException, DatabaseException {
        this.loadGroups(db);
        Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)this.uri, (String)this.fragment);
        Iterator lfxi = loc.getXLinksForLocator((Object)Predicates.predicateLocatorForXLinkByContentrolesDescending((Database)db, (String[])new String[]{"Documentation", "Documentation-Original", "Documentation-Hidden"}));
        if (!lfxi.hasNext() && URIRule.isPSML((URI)this.uri)) {
            PSMLContentResolver resolver = new PSMLContentResolver(db, this.uri, this.group.getName());
            resolver.setFragment(this.fragment, null, true, false);
            OriginalFragmentParser parser = new OriginalFragmentParser();
            XMLHelpers.parse((InputStream)resolver.getContent(), (ContentHandler)parser);
            Object oldContent = parser.textContent != null ? parser.textContent.toString() : parser.content.toString();
            String oldMediaType = parser.mediaType != null ? parser.mediaType : "application/vnd.pageseeder.psml+xml";
            oldContent = oldContent == null || ((String)oldContent).length() == 0 ? "<fragment id=\"" + XML.escapeAttr((String)this.fragment) + "\" />" : ((String)oldContent).replaceAll("<\\?xml(.*?)\\>", "");
            XLink xl = this.createEditXLink("Document Original", "Documentation-Original", "Documentation-Old", this.editGroups, parser.fragmentLabels, (String)oldContent, oldMediaType, creationDate, db);
            PSMLContentUtils.setFragmentType((XLink)xl, (String)parser.fragType);
            for (String[] note : parser.notes) {
                XLink notes = XLink.create((Database)db);
                notes.setContentRole("Documentation-Note");
                notes.setContentTitle(note[0] == null ? "Edit note" : note[0]);
                notes.setAccepted(Boolean.valueOf(true));
                notes.setModeratorOnly(Boolean.valueOf(false));
                notes.setMember(this.author);
                notes.setDate(creationDate);
                XLinkRule.addGroups((Database)db, (XLink)notes, Collections.singleton(this.group));
                if (!Strings.isEmpty((String)note[2])) {
                    Labels.setLabels((XLink)notes, (String[])note[2].split(","));
                }
                Content cont = Content.create((Database)db);
                cont.setType("text/plain");
                if (note[1] != null) {
                    cont.setData(note[1]);
                }
                notes.addContents(cont);
                notes = notes.insert(db);
                xl.addReplies(notes);
            }
            return xl;
        }
        while (lfxi.hasNext()) {
            XLink xl = ((LocatorForXLink)lfxi.next()).getXLink();
            if ("Documentation-Draft".equals(xl.getStatus())) continue;
            return xl;
        }
        return null;
    }

    private XLink createNotes(Collection<Group> groups, Database db) throws DatabaseException {
        XLink notes = null;
        if (this.notesContent != null || this.notesLabels != null) {
            notes = XLink.create((Database)db);
            notes.setContentRole("Documentation-Note");
            notes.setContentTitle(this.notesTitle == null ? "Edit note" : this.notesTitle);
            notes.setAccepted(Boolean.valueOf(true));
            notes.setModeratorOnly(Boolean.valueOf(false));
            notes.setMember(this.author);
            notes.setDate(new Date());
            XLinkRule.addGroups((Database)db, (XLink)notes, groups);
            Labels.setLabels((XLink)notes, (String[])this.notesLabels);
            Content cont = Content.create((Database)db);
            cont.setType("text/plain");
            if (this.notesContent != null) {
                cont.setData(this.notesContent);
            }
            notes.addContents(cont);
            notes = notes.insert(db);
        }
        return notes;
    }

    private boolean validate(String content) {
        String err;
        if (content == null || content.isEmpty()) {
            return true;
        }
        boolean hasError = false;
        try {
            err = PSML.validateWithSchematron(new StringReader(content));
            if (err != null && !err.isEmpty()) {
                hasError = true;
                this.errors.add(err);
            }
        }
        catch (SchematronException ex) {
            hasError = true;
            this.errors.add("Failed to validate XML with schematron: " + ex.getMessage());
        }
        try {
            err = XMLHelpers.validateXmlFileWithSchema((String)content, (String)"ps://com/pageseeder/load/psml-portable.xsd", null);
            if (err != null && !err.isEmpty()) {
                hasError = true;
                this.errors.add(err);
            }
        }
        catch (SAXException e) {
            hasError = true;
            this.errors.add("Failed to validate XML with schema: " + e.getMessage());
        }
        catch (IOException e) {
            hasError = true;
            this.errors.add("Failed to read XML: " + e.getMessage());
        }
        if (hasError) {
            this.status = Status.VALIDATION_ERROR;
        }
        return !hasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleHTML(String content) {
        String uri_folder;
        int i;
        LOGGER.debug("HTML (Received):\n{}", (Object)content);
        String cleaned = HTMLSanitizer.sanitizeForPSML((String)content);
        StreamSource source = new StreamSource(new StringReader("<html xmlns=\"http://www.w3.org/1999/xhtml\">" + cleaned + "</html>"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("HTML (Sanitized):\n{}", (Object)cleaned);
        }
        if ((i = (uri_folder = URIRule.getURIString((URI)this.uri)).lastIndexOf(47)) != -1) {
            uri_folder = uri_folder.substring(0, i + 1);
        }
        StringWriter result = new StringWriter();
        try {
            Transformer t = FragmentEditor.createTemplates().newTransformer();
            try (StringWriter stringWriter = result;){
                t.setParameter("urifolder", uri_folder);
                t.setParameter("fragment", this.fragment);
                t.setParameter("siteprefix", GlobalSettings.getSitePrefix());
                t.transform(source, new StreamResult(result));
            }
            finally {
                t = null;
            }
        }
        catch (TransformerConfigurationException ex) {
            this.errors.add("Failed to create XSLT transformer: " + ex.getMessage());
            return null;
        }
        catch (TransformerException ex) {
            this.errors.add("Failed to transform HTML to PSML: " + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            this.errors.add("Failed to read HTML: " + ex.getMessage());
            return null;
        }
        return result.toString();
    }

    private String markdownToPSML(String markdown) {
        LOGGER.debug("Text (Received):{}", (Object)markdown);
        BlockParser parser = new BlockParser();
        XMLStringWriter result = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            result.openElement("fragment");
            List psml = parser.parse(Arrays.asList(markdown.split("\n")));
            for (PSMLElement elem : psml) {
                elem.toXML((XMLWriter)result);
            }
            result.closeElement();
        }
        catch (IOException ex) {
            this.errors.add("Failed to convert markdown to PSML: " + ex.getMessage());
            return null;
        }
        return result.toString();
    }

    private static class OriginalFragmentParser
    extends DefaultHandler {
        private static final String TYPE_ATTRIBUTE = "type";
        private static final String MEDIATYPE_ATTRIBUTE = "mediatype";
        private static final String LABELS_ATTRIBUTE = "labels";
        private final XMLStringWriter content = new XMLStringWriter(XML.NamespaceAware.Yes);
        private StringBuilder textContent = null;
        private final List<String[]> notes = new ArrayList<String[]>();
        private String[] fragmentLabels = null;
        private String noteTitle = null;
        private String noteContent = null;
        private String noteLabels = null;
        private boolean storeText = false;
        private boolean inContent = false;
        private final StringBuilder text = new StringBuilder();
        private String fragType = null;
        private String mediaType = null;
        private int inMediaFragment = 0;

        private OriginalFragmentParser() {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.content.setPrefixMapping(uri, prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String s;
            boolean isFragment;
            boolean bl = isFragment = PSMLContentUtils.isFragmentElement((String)localName) && this.inMediaFragment == 0;
            if (PSMLContentUtils.isMediaFragmentElement((String)localName)) {
                this.fragType = atts.getValue(TYPE_ATTRIBUTE);
                this.mediaType = atts.getValue(MEDIATYPE_ATTRIBUTE);
                if (!RuleUtils.isXMLMediaType((String)this.mediaType)) {
                    this.textContent = new StringBuilder();
                }
                this.inContent = true;
                ++this.inMediaFragment;
            } else {
                if (this.inMediaFragment == 0) {
                    if (LABELS_ATTRIBUTE.equals(localName) || this.noteTitle != null && "content".equals(localName)) {
                        this.storeText = true;
                    } else if ("note".equals(localName)) {
                        this.noteTitle = atts.getValue("title");
                    } else if (isFragment) {
                        this.inContent = true;
                    }
                }
                if (this.inContent) {
                    this.content.openElement(uri, localName, true);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        if (isFragment && LABELS_ATTRIBUTE.equals(atts.getLocalName(i))) continue;
                        String auri = atts.getURI(i);
                        if (auri != null && auri.length() == 0) {
                            auri = null;
                        }
                        this.content.attribute(auri, atts.getLocalName(i), atts.getValue(i));
                    }
                }
            }
            if (isFragment && !Strings.isEmpty((String)(s = atts.getValue(LABELS_ATTRIBUTE)))) {
                this.fragmentLabels = s.split(",");
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            String s;
            if (PSMLContentUtils.isMediaFragmentElement((String)localName)) {
                --this.inMediaFragment;
            }
            if (this.inMediaFragment != 0) {
                this.content.closeElement();
                return;
            }
            if (this.noteTitle != null) {
                if (LABELS_ATTRIBUTE.equals(localName)) {
                    this.noteLabels = this.text.toString();
                } else if ("content".equals(localName)) {
                    this.noteContent = this.text.toString();
                } else if ("note".equals(localName)) {
                    this.notes.add(new String[]{this.noteTitle, this.noteContent, this.noteLabels});
                    this.noteTitle = null;
                }
            } else if (LABELS_ATTRIBUTE.equals(localName) && !Strings.isEmpty((String)(s = this.text.toString()))) {
                this.fragmentLabels = s.split(",");
            }
            if (this.inContent && !PSMLContentUtils.isMediaFragmentElement((String)localName)) {
                this.content.closeElement();
            }
            if (PSMLContentUtils.isFragmentElement((String)localName)) {
                this.inContent = false;
            }
            this.text.setLength(0);
            this.storeText = false;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inContent) {
                if (this.textContent != null) {
                    this.textContent.append(ch, start, length);
                } else {
                    this.content.writeText(ch, start, length);
                }
            } else if (this.storeText) {
                this.text.append(ch, start, length);
            }
        }
    }

    public static enum Status {
        NOT_MODIFIED,
        VALIDATION_ERROR,
        XREF_ERROR,
        UNKNOWN_ERROR,
        OK;

    }
}

