/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.Structure;
import com.pageseeder.uri.URIEditLock;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.pageseeder.psml.template.Template;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Requires(uri=true, group=true, member=true)
public final class CreateFragment
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateFragment.class);
    private static final String TEMPLATE_PARAMETER_PREFIX = "template.";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddEditXLinksCheck(req.getGroup(), req.getURI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI uri = req.getURI();
        if (!URIRule.isPSML((URI)uri) || uri.getExternal().booleanValue()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URI must be an internal PSML document");
            return;
        }
        String section = req.getParameter((Parameter)StandardParameters.section);
        String beforefragment = req.getParameter((Parameter)StandardParameters.beforefragment);
        String afterfragment = req.getParameter((Parameter)StandardParameters.afterfragment);
        if (section == null && beforefragment == null && afterfragment == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing parameter: one of 'section', 'beforefragment' or 'afterfragment' is required");
            return;
        }
        String fragment = req.getParameter((Parameter)StandardParameters.fragment, null);
        String fragmentprefix = req.getParameter((Parameter)StandardParameters.fragmentprefix);
        String content = req.getParameter((Parameter)StandardParameters.content);
        String contentType = "application/vnd.pageseeder.psml+xml";
        boolean draft = req.getParameter((Parameter)StandardParameters.draft, false);
        String type = req.getParameter((Parameter)StandardParameters.type);
        if (content == null && type == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing parameter: one of 'content' or 'type' is required");
            return;
        }
        Member author = req.getMember();
        Database db = req.getDatabase();
        URIEditLock lock = URIEditLock.newInstance(req.getURI().getId());
        if (!lock.lock()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Another edit for this URI is currently being saved.");
            return;
        }
        String new_content = null;
        try {
            Object messages;
            Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
            if (afterfragment != null || beforefragment != null) {
                String frag;
                String string = frag = afterfragment == null ? beforefragment : afterfragment;
                if (!URIRule.hasFragment((URI)uri, (Group)group, (String)frag, (Database)req.getDatabase())) {
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + frag);
                    return;
                }
            }
            if (content == null || content.isEmpty()) {
                HashMap<String, String> params = new HashMap<String, String>();
                for (String pname : req.getParameters().keySet()) {
                    if (!pname.startsWith(TEMPLATE_PARAMETER_PREFIX)) continue;
                    params.put(pname.substring(TEMPLATE_PARAMETER_PREFIX.length()), req.getParameter(pname));
                }
                content = this.buildFragmentContent(uri, group, author, type, params, res);
                if (content == null) {
                    return;
                }
            }
            XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null);
            if (fragment != null) {
                if (this.existingFragment(fragment, structure, uri, group, db, res)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FRAGMENT_EXISTS);
                    return;
                }
            } else {
                fragment = this.computeFragment(fragmentprefix, structure, uri, group, db, res);
                if (fragment == null) {
                    return;
                }
            }
            if (!LocatorRule.isValidFragmentID((String)fragment)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FRAGMENT_INVALID);
                return;
            }
            Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)fragment);
            req.getTransaction().commitAndStart();
            String[] fragDetails = new String[]{fragment, section, afterfragment, beforefragment};
            try {
                if (!Structure.addFragmentToStructureXLink(fragDetails, false, structure, uri, group, author, db)) {
                    String msg = section != null ? "there are no sections named " + section : (afterfragment != null ? "there are no fragments named " + afterfragment : "there are no fragments named " + beforefragment);
                    res.setError(GeneratorStatus.BAD_REQUEST, "No valid location to add the new fragment: " + msg);
                    loc.delete(db);
                    return;
                }
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to update URI structure XLink", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to update URI's structure: " + ex.getMessage());
                loc.delete(db);
                return;
            }
            Date previousModified = uri.getLastModified();
            FragmentEditor editor = new FragmentEditor(uri, fragment, author, group);
            editor.setMarkdown(req.getParameter((Parameter)StandardParameters.markdown, false));
            editor.setHTMLTransform(req.getParameter((Parameter)StandardParameters.html, false));
            editor.setDraft(draft);
            String notesContent = req.getParameter((Parameter)StandardParameters.note, "");
            if (notesContent.isEmpty()) {
                notesContent = null;
            }
            String notesTitle = req.getParameter((Parameter)StandardParameters.note_title, "Edit note");
            String nLabels = req.getParameter((Parameter)StandardParameters.note_labels, "");
            String[] notesLabels = nLabels.isEmpty() ? null : nLabels.split(",");
            editor.setNotes(notesContent, notesTitle, notesLabels);
            String labs = req.getParameter((Parameter)StandardParameters.labels);
            if (!URIUtils.checkLabels(res, labs)) {
                return;
            }
            String[] labels = labs == null ? null : (labs.isEmpty() ? new String[]{} : labs.split(","));
            editor.edit(db, content, contentType, type, labels, false);
            FragmentEditor.Status status = editor.getStatus();
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            Object object = messages = msg.length() > 0 ? msg.substring(1) : "";
            if (status != FragmentEditor.Status.OK) {
                URIErrorID err = null;
                switch (status) {
                    case XREF_ERROR: {
                        err = URIErrorID.XREF_PROCESSING_ERROR;
                        break;
                    }
                    case VALIDATION_ERROR: {
                        err = URIErrorID.VALIDATION_ERROR;
                        break;
                    }
                    case UNKNOWN_ERROR: {
                        err = URIErrorID.FRAGMENT_CREATION_ERROR;
                        messages = "Not modified: " + (String)messages;
                        break;
                    }
                    case NOT_MODIFIED: {
                        err = URIErrorID.FRAGMENT_CREATION_ERROR;
                    }
                }
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)err, (String)messages);
                loc.delete(db);
                req.getTransaction().commitAndStart();
                Structure.cancelLatestStructureChange(uri, group, db);
                return;
            }
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            if (!draft) {
                PSML.indexFragmentAndTargetURIs(db, uri, editor, loc, previousModified, "Creating");
            }
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setFragment(fragment);
            resolver.setFragmentInfo(true);
            if (draft) {
                resolver.includeDraftContent(author.getId());
            }
            if (req.getParameter((Parameter)StandardParameters.transclude, false)) {
                UserDetails userdetails = new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), false);
                resolver.setTransclude(userdetails);
            }
            try (InputStream in = resolver.getContent(req.getDatabase());){
                new_content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (URIException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document's content: " + ex.getMessage());
                lock.unlock();
                return;
            }
        }
        finally {
            lock.unlock();
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("fragment-creation");
        new_content = new_content == null || new_content.isEmpty() ? "<document-fragment/>" : new_content.replaceAll("<\\?xml(.*?)\\>", "");
        xml.writeXML(new_content);
        xml.closeElement();
    }

    private String buildFragmentContent(URI uri, Group group, Member author, String type, Map<String, String> params, GeneratorResponse res) {
        Template template;
        try {
            template = PSMLFiles.findFragmentTemplate((String)group.getOwnerDirectory(), (String)URIRule.getStyleConfig((URI)uri), (String)type);
            if (template == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Fail to load fragment template for " + type);
                return null;
            }
        }
        catch (IOException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Fail to read fragment template for " + type + ": " + ex.getMessage());
            return null;
        }
        catch (TemplateException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Fail to load fragment template for " + type + ": " + ex.getMessage());
            return null;
        }
        HashMap<String, Object> processParams = new HashMap<String, Object>();
        processParams.putAll(params);
        processParams.put("ps.title", uri.getDisplayTitle());
        String[] fn = URIRule.getFilename((URI)uri);
        processParams.put("ps.filename", fn[0] + "." + fn[1]);
        processParams.put("ps.description", uri.getDescription());
        processParams.put("ps.author", author.getFirstName() + " " + author.getSurname());
        if (uri.getDocID() != null) {
            processParams.put("ps.docid", uri.getDocID());
        }
        processParams.put("ps.group", group.getName());
        processParams.put("ps.path", uri.getDecodedPath());
        Date today = new Date();
        processParams.put("ps.currentdate", ISO8601.format((long)today.getTime(), (ISO8601)ISO8601.CALENDAR_DATE));
        processParams.put("ps.currentdatetime", ISO8601.format((long)today.getTime(), (ISO8601)ISO8601.DATETIME));
        processParams.put("ps.currenttime", ISO8601.format((long)today.getTime(), (ISO8601)ISO8601.TIME));
        StringWriter contentsWriter = new StringWriter();
        template.process(new PrintWriter(contentsWriter), processParams);
        return contentsWriter.toString();
    }

    private String computeFragment(String fragmentprefix, XLink structure, URI uri, Group group, Database db, GeneratorResponse res) {
        ArrayList<String> existingFragments = new ArrayList<String>();
        for (Locator loc : uri.getLocatorsCol()) {
            existingFragments.add(loc.getFragment());
        }
        try {
            InputStream in = Structure.getStructureContent(structure, uri, group, db);
            FragmentIDsLoader loader = new FragmentIDsLoader();
            XMLHelpers.parse((InputStream)in, (ContentHandler)loader);
            existingFragments.addAll(loader.fragmentIDs);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to parse structure of URI {} to compute fragment ID", (Object)uri.getId(), (Object)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to parse structure to compute fragment ID: " + ex.getMessage());
            return null;
        }
        String prefix = fragmentprefix == null ? "" : fragmentprefix;
        int index = 1;
        while (existingFragments.contains(prefix + index)) {
            ++index;
        }
        return prefix + index;
    }

    private boolean existingFragment(String fragment, XLink structure, URI uri, Group group, Database db, GeneratorResponse res) {
        try {
            InputStream in = Structure.getStructureContent(structure, uri, group, db);
            FragmentIDsLoader loader = new FragmentIDsLoader();
            XMLHelpers.parse((InputStream)in, (ContentHandler)loader);
            return loader.fragmentIDs.contains(fragment);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to parse structure of URI {} to compute fragment ID", (Object)uri.getId(), (Object)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to parse structure to compute fragment ID: " + ex.getMessage());
            return false;
        }
    }

    private static class FragmentIDsLoader
    extends DefaultHandler {
        private static final String ID_ATTRIBUTE = "id";
        private final List<String> fragmentIDs = new ArrayList<String>();

        private FragmentIDsLoader() {
        }

        @Override
        public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
            String id;
            if ((PSMLContentUtils.isFragmentElement((String)lName) || "fragment-ref".equals(lName)) && (id = atts.getValue(ID_ATTRIBUTE)) != null) {
                this.fragmentIDs.add(id);
            }
        }
    }
}

