/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Rules;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.Structure;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import com.pageseeder.utils.DynamicStrings;
import com.pageseeder.utils.PSMLFileCreator;
import com.pageseeder.xref.XRefException;
import com.pageseeder.xref.XRefMediator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pageseeder.psml.template.Processor;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.schematron.SchematronException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Requires(database=true, group=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateDocument
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDocument.class);
    private static final String TEMPLATE_PARAMETER_PREFIX = "template.";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        URL dest;
        URI uri = req.getURI();
        String url = req.getParameter((Parameter)StandardParameters.url);
        String dadurl = req.getParameter((Parameter)StandardParameters.parenturl);
        if (url != null) {
            int lastSlash = url.lastIndexOf(47);
            if (lastSlash == -1) {
                return new NoCheck();
            }
            dadurl = url.substring(0, lastSlash);
        }
        String dadname = req.getParameter((Parameter)StandardParameters.parentfolder);
        try {
            dest = this.computeDestination(uri, dadurl, dadname, req.getGroup());
        }
        catch (URIException ex) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup(), dest.toString()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI turi;
        String[] groupnames;
        URL destination;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        Member member = req.getMember();
        URI uri = req.getURI();
        String filename = req.getParameter((Parameter)StandardParameters.name);
        String title = req.getParameter((Parameter)StandardParameters.title);
        String documentid = req.getParameter((Parameter)StandardParameters.docid);
        String description = req.getParameter((Parameter)StandardParameters.description);
        String doctype = req.getParameter((Parameter)StandardParameters.type, "default");
        String notify = req.getParameter((Parameter)StandardParameters.notify, "silent");
        String labels = req.getParameter((Parameter)StandardParameters.labels);
        String groups = req.getParameter((Parameter)StandardParameters.notification_groups, group.getName());
        Object message = req.getParameter((Parameter)StandardParameters.notification_content);
        String subject = req.getParameter((Parameter)StandardParameters.notification_subject);
        String msglabels = req.getParameter((Parameter)StandardParameters.notification_labels);
        String url = req.getParameter((Parameter)StandardParameters.url);
        String dadurl = req.getParameter((Parameter)StandardParameters.parenturl);
        String dadname = req.getParameter((Parameter)StandardParameters.parentfolder);
        if (!URIUtils.checkLabels(res, labels)) {
            return;
        }
        if (!this.checkParameters(url, dadurl, filename, dadname, res)) {
            return;
        }
        if (url != null) {
            int lastSlash = url.lastIndexOf(47);
            if (lastSlash == -1) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DESTINATION, "Invalid URL destination " + url);
                return;
            }
            dadurl = url.substring(0, lastSlash);
            filename = URLCoder.decode((String)url.substring(lastSlash + 1));
            if (!filename.endsWith(".psml")) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DESTINATION, "The URL must end in \".psml\"");
                return;
            }
            filename = filename.replaceAll("\\.psml$", "");
        }
        try {
            destination = this.computeDestination(uri, dadurl, dadname, group);
        }
        catch (URIException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DESTINATION, ex.getMessage());
            return;
        }
        if (!Strings.isEmpty((String)filename) && filename.charAt(0) == '.') {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.ILLEGAL_FILENAME, "Filename cannot start with a dot '.'");
            return;
        }
        if (!URIRule.isValidDocumentType((String)doctype)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The document type is not valid");
            return;
        }
        UserDetailsManager user_manager = new UserDetailsManager();
        UserDetails userdetails = user_manager.get(db, req.getAuthenticatedMember().getId());
        ArrayList<Group> notify_groups = new ArrayList<Group>();
        for (String groupname : groupnames = groups.split(",")) {
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            if (grp == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Invalid group name: " + (String)groupname);
                return;
            }
            if (!GroupRule.userHasAccess((Group)grp, (UserDetails)userdetails)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "You do not have access to group: " + (String)groupname);
                return;
            }
            notify_groups.add(grp);
        }
        int port = destination.getPort();
        if (port == -1) {
            port = Rules.getDefaultPort((String)destination.getProtocol());
        }
        ArrayList<URI> toindex = new ArrayList<URI>();
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        for (String name : req.getParameters().keySet()) {
            if (!name.startsWith(TEMPLATE_PARAMETER_PREFIX)) continue;
            templateParameters.put(name.substring(TEMPLATE_PARAMETER_PREFIX.length()), req.getParameter(name));
        }
        CreatedFile cfile = this.createPSMLFile(doctype, group, member, filename, title == null ? filename : title, documentid, description, destination, templateParameters, db, member, toindex);
        if (cfile.status != GeneratorStatus.OK) {
            if (cfile.error == null) {
                res.setError(cfile.status, cfile.message);
            } else {
                res.setError(cfile.status, (ErrorID)cfile.error, cfile.message);
            }
            return;
        }
        try {
            turi = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)cfile.path);
            if (turi != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EXISTING_URL, "The URI already exists.");
                return;
            }
            if (!Strings.isEmpty((String)cfile.documentid)) {
                if (!URIRule.isValidDocumentID((String)cfile.documentid)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DOCUMENT_ID);
                    return;
                }
                turi = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)destination.getHost(), (String)cfile.documentid);
                if (turi != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.DOCUMENT_ID_EXISTING, "The document id " + cfile.documentid + " is already being used (" + turi.getDecodedPath() + ").");
                    return;
                }
            }
            if (!Strings.isEmpty((String)cfile.publicationType) && !Publications.isValidPublicationType((String)cfile.publicationType)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_PUBLICATION_TYPE, "The publication type " + cfile.publicationType + " is invalid.");
                return;
            }
            if (!Strings.isEmpty((String)cfile.publicationId)) {
                Publication existing;
                if (!Publications.isValidPublicationID((String)cfile.publicationId)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_PUBLICATION_ID, "The publication id " + cfile.publicationId + " is invalid.");
                    return;
                }
                Host h = DatabaseQuery.getHostByName((Database)db, (String)destination.getHost());
                Publication publication = existing = h == null ? null : DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)cfile.publicationId, (Host)h);
                if (existing != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.PUBLICATION_ID_EXISTING, "The publication id " + cfile.publicationId + " is already being used (URI id " + existing.getRootURIId() + ").");
                    return;
                }
            }
            toindex.addAll(URIRule.ensureFolderURIsExist((Database)db, (Member)member, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)cfile.path));
            try {
                String[] labelsArray = Strings.isEmpty((String)labels) ? null : labels.split(",");
                turi = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabels((Database)db, null, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)cfile.path, (String)cfile.behavior, (String)cfile.description, (String)cfile.title, (String)Medias.getMediaType((File)cfile.file), (String[])labelsArray, (boolean)true);
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to create URI in DB", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create URI in DB: " + ex.getMessage());
            }
            if (turi == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "No group URI for path: " + cfile.path);
                return;
            }
            toindex.add(turi);
            if (!Strings.isEmpty((String)cfile.documentid)) {
                turi.setDocID(cfile.documentid);
            }
            String[] msgLabelsArray = Strings.isEmpty((String)msglabels) ? null : msglabels.split(",");
            URIRule.addURIHistoryXLink((URI)turi, (Member)member, (Date)turi.getDateCreated(), null, (String)"creation", (String[])msgLabelsArray, null, null, (byte[])cfile.content, (Database)db);
            Group editgroup = GroupRule.getEditGroup((Database)db, (Group)group, (URI)turi);
            XRefMediator mediator = new XRefMediator(editgroup, turi, member, turi.getDateCreated(), db);
            mediator.setCreateEdit(true);
            mediator.setFailOnFirstError(false);
            mediator.setBuildStructure(true);
            try {
                mediator.mediateNewDocument(new ByteArrayInputStream(cfile.content));
            }
            catch (XRefException ex) {
                LOGGER.error("Failed to create XRefs", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.XREF_PROCESSING_ERROR, "Failed to create XRefs: " + ex.getMessage());
                return;
            }
            try {
                Structure.createStructureXLink(mediator.getStructureXML(), turi, editgroup, member, turi.getDateCreated(), "Document Create", db);
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to create structure in DB", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create structure: " + ex.getMessage());
                return;
            }
            if (!Strings.isEmpty((String)cfile.publicationId)) {
                try {
                    Publications.create((Database)db, (Member)member, (String)cfile.publicationId, (URI)turi, (Group)group, (String)(Strings.isEmpty((String)cfile.publicationType) ? "default" : cfile.publicationType));
                }
                catch (DatabaseException ex) {
                    LOGGER.error("Failed to create publication for new document {}", (Object)cfile.path, (Object)ex);
                    res.setError(GeneratorStatus.BAD_REQUEST, "Failed to create publication: " + ex.getMessage());
                    return;
                }
            }
            try {
                if ("normal".equals(notify) || "announce".equals(notify)) {
                    if (subject == null) {
                        String string = subject = title == null || "".equals(title) ? "Document Created" : "Document Created: " + title;
                    }
                    if (message == null) {
                        message = "A new document has been created";
                        message = cfile.description != null && cfile.description.length() > 0 ? (String)message + " with the following description:\n\n" + cfile.description : (String)message + ".";
                    }
                    for (Group grp : notify_groups) {
                        Emails.sendNewURI((Database)db, (Member)member, (String)subject, (String)message, (String)"File Creation", (String[])msgLabelsArray, Collections.singleton(turi), (Group)grp, (boolean)"announce".equals(notify), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to create notification", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create notification: " + ex.getMessage());
                return;
            }
            req.getTransaction().commitAndStart();
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to create document", ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create document: " + ex.getMessage());
            return;
        }
        ChangesManager changes = ChangesManager.getInstance();
        ChangesBatch batch = new ChangesBatch("Creating new document " + turi.getDecodedPath());
        changes.startBatch(db, batch);
        for (URI auri : toindex) {
            changes.createURI(db, batch, auri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)auri.getId()));
        }
        PSML.indexXRefSourceTargetURIsWithBatch(db, turi, batch);
        changes.completeBatch(db, batch);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("document-creation");
        if (cfile.originalFileName != null) {
            out.field("renamed", "true");
            out.field("original-name", cfile.originalFileName);
        }
        out.writeURI(turi);
        out.endObject();
        out.flush();
    }

    private boolean checkParameters(String url, String dadurl, String filename, String dadname, GeneratorResponse res) {
        if (filename != null && url != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both url and name parameters");
            return false;
        }
        if (dadurl != null && url != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both url and parenturl parameters");
            return false;
        }
        if (dadurl != null && dadname != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both parentfolder and parenturl parameters");
            return false;
        }
        if (url != null && dadname != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.AMBIGUOUS_REQUEST, "Cannot specify both parentfolder and url parameters");
            return false;
        }
        return true;
    }

    private ValidationResult validateContents(String contents) {
        ValidationResult result = new ValidationResult();
        result.validated = true;
        String schemaPath = "ps://com/pageseeder/load/psml-portable.xsd";
        try {
            result.errors = XMLHelpers.validateXmlFileWithSchema((String)contents, (String)schemaPath, null);
        }
        catch (SAXException ex) {
            result.errors = "XML error when validating new file with schema: " + ex.getMessage();
        }
        catch (IOException ex) {
            result.errors = "IO error when validating new file with schema: " + ex.getMessage();
        }
        if (result.errors.isEmpty()) {
            result.errors = null;
        }
        String err = null;
        try {
            err = PSML.validateWithSchematron(new StringReader(contents));
        }
        catch (SchematronException ex) {
            result.errors = "XML error when validating new file with schematron: " + ex.getMessage();
        }
        if (err != null) {
            String string = result.errors = result.errors == null ? err : result.errors + ", " + err;
        }
        if (result.errors != null && result.errors.isEmpty()) {
            result.errors = null;
        }
        return result;
    }

    private URL computeDestination(URI uri, String dadurl, String dadname, Group group) throws DatabaseException, URIException {
        URL dadURL;
        if (uri != null) {
            if (!"folder".equals(uri.getType())) {
                throw new URIException("Invalid parent URI specified (not a folder)");
            }
            try {
                return RuleUtils.urlEncodeNormalize((String)URIRule.getURIString((URI)uri));
            }
            catch (MalformedURLException ex) {
                throw new URIException("Invalid URL " + URIRule.getURIString((URI)uri) + ": " + ex.getMessage());
            }
        }
        String parenturl = dadurl;
        if (parenturl == null) {
            GroupURI defaultguri = group.getFlags() != null && group.getFlags().contains("f") ? GroupRule.getFolderGroupURI((Group)group) : GroupURIRule.getDefaultGroupURI((Group)group);
            Object dad = dadname != null && dadname.charAt(0) != '/' ? "/" + dadname : (dadname != null ? dadname : "");
            parenturl = URIRule.getURIString((String)defaultguri.getScheme(), (String)defaultguri.getHost().getName(), (Integer)defaultguri.getPort(), (String)(GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + (String)dad));
        }
        parenturl = parenturl.replaceAll("/$", "");
        try {
            dadURL = RuleUtils.urlEncodeNormalize((String)parenturl);
        }
        catch (MalformedURLException ex) {
            throw new URIException("Invalid URL " + parenturl + ": " + ex.getMessage());
        }
        return dadURL;
    }

    private CreatedFile createPSMLFile(String doctype, Group group, Member member, String userFilename, String title, String docid, String description, URL destination, Map<String, String> params, Database db, Member mem, Collection<URI> toindex) throws IOException {
        PSMLFileCreator creator;
        try {
            String config = PSMLFiles.findCreationConfig((String)group.getOwnerDirectory(), (String)doctype);
            creator = PSMLFileCreator.buildCreator(config);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to load/parse config file", (Throwable)ex);
            return new CreatedFile("Failed to parse config file: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, null);
        }
        if (userFilename == null && !creator.isFilenameSpecified()) {
            return new CreatedFile("Filename is required for document type " + doctype, GeneratorStatus.BAD_REQUEST, null);
        }
        URI contextURI = null;
        int port = destination.getPort();
        if (port == -1) {
            port = Rules.getDefaultPort((String)destination.getProtocol());
        }
        String context = creator.getFolderContext();
        String escapedParentPath = RuleUtils.replaceNonFolderCharsKeepSlashes((String)URLCoder.decode((String)destination.getPath()));
        String encodedParentPath = RuleUtils.urlEncodeFilepath((String)escapedParentPath);
        String destinationPath = encodedParentPath.replaceAll("/$", "");
        Group cgroup = group;
        try {
            Group g;
            if (!(destinationPath + "/").startsWith(GroupRule.getDefaultPath((Group)group)) && (g = URIRule.getDefaultGroupForURL((Database)db, (URL)destination)) != null) {
                cgroup = g;
            }
            if (!Strings.isEmpty((String)context)) {
                if (context.indexOf(42) == -1 && context.charAt(0) == '/') {
                    Object newpath = GlobalSettings.getSitePrefix() + "/" + cgroup.getName().replace('-', '/') + context;
                    GroupURI guri = cgroup.getFlags() != null && cgroup.getFlags().contains("f") ? GroupRule.getFolderGroupURI((Group)cgroup) : GroupURIRule.getDefaultGroupURI((Group)cgroup);
                    newpath = RuleUtils.replaceNonFolderCharsKeepSlashes((String)newpath).replaceAll("/$", "");
                    contextURI = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)RuleUtils.urlEncodeFilepath((String)newpath));
                    if (contextURI == null) {
                        List created = URIRule.ensureFolderURIsExist((Database)db, (Member)member, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)((String)newpath + "/file"));
                        contextURI = (URI)created.get(0);
                        toindex.addAll(created);
                    }
                    destinationPath = contextURI.getPath();
                } else {
                    String contextFolder = creator.retrieveFolderContext(URLCoder.decode((String)destination.getPath()), cgroup.getName());
                    if (contextFolder == null) {
                        return new CreatedFile("Unable to create " + doctype + " document in " + destination.getPath(), GeneratorStatus.BAD_REQUEST, URIErrorID.INVALID_DESTINATION);
                    }
                    contextFolder = RuleUtils.replaceNonFolderCharsKeepSlashes((String)contextFolder).replaceAll("/$", "");
                    contextURI = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)RuleUtils.urlEncodeFilepath((String)contextFolder));
                    if (contextURI == null) {
                        List created = URIRule.ensureFolderURIsExist((Database)db, (Member)member, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)(contextFolder + "/file"));
                        contextURI = (URI)created.get(0);
                        toindex.addAll(created);
                    }
                    destinationPath = contextURI.getPath();
                }
                if (cgroup != group && !PermissionManager.check((Long)member.getId(), (UserDetails)new UserDetailsManager().get(db, member.getId()), (Database)db, (Permissions)new Permissions(), (PermissionCheck)new EditURICheck(contextURI))) {
                    return new CreatedFile("Edit access denied for folder: " + contextURI.getDecodedPath(), GeneratorStatus.FORBIDDEN, null);
                }
            } else {
                List created = URIRule.ensureFolderURIsExist((Database)db, (Member)member, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)(destinationPath + "/file"));
                toindex.addAll(created);
                contextURI = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)destination.getProtocol(), (String)destination.getHost(), (Integer)port, (String)(GlobalSettings.getSitePrefix() + "/" + cgroup.getName().replace('-', '/')));
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to retrieve context target URI from DB", (Throwable)ex);
            return new CreatedFile("Failed to retrieve context target URI from DB: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, null);
        }
        CreatedFile cf = new CreatedFile();
        Date today = new Date();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("ui.title", title);
        parameters.put("ui.docid", docid);
        if (params != null) {
            for (String pname : params.keySet()) {
                parameters.put("ui." + pname, params.get(pname));
            }
        }
        int number = -1;
        if ((creator.hasAutoIncrementNumbering() || creator.hasAutoIncrementDocID()) && contextURI != null) {
            try {
                number = creator.computeAutoNumbering(contextURI, doctype, parameters, today, db);
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to retrieve auto number from DB", (Throwable)ex);
                return new CreatedFile("Failed to retrieve auto number from DB: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, null);
            }
            catch (ParseException ex) {
                LOGGER.error("Failed to parse ", (Throwable)ex);
                return new CreatedFile("Failed to retrieve auto number from DB: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
            }
        }
        cf.documentid = docid;
        if (creator.getDocumentID() != null) {
            try {
                cf.documentid = DynamicStrings.process(creator.getDocumentID(), parameters, number, today);
            }
            catch (ParseException ex) {
                LOGGER.error("Failed to parse document ID", (Throwable)ex);
                return new CreatedFile("Failed to parse document ID: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
            }
        }
        cf.publicationType = creator.getPublicationType();
        cf.publicationId = creator.getPublicationId();
        if (cf.publicationId != null) {
            try {
                cf.publicationId = DynamicStrings.process(cf.publicationId, parameters, number, today);
            }
            catch (ParseException ex) {
                LOGGER.error("Failed to create publication ID", (Throwable)ex);
                return new CreatedFile("Failed to create publication ID: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
            }
        }
        cf.title = title;
        if (creator.getDocumentTitle() != null) {
            try {
                cf.title = DynamicStrings.process(creator.getDocumentTitle(), parameters, number, today);
            }
            catch (ParseException ex) {
                LOGGER.error("Failed to create document title", (Throwable)ex);
                return new CreatedFile("Failed to create document title: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
            }
        }
        cf.description = description;
        if (creator.getDocumentDescription() != null) {
            try {
                cf.description = DynamicStrings.process(creator.getDocumentDescription(), parameters, number, today);
            }
            catch (ParseException ex) {
                LOGGER.error("Failed to create document description", (Throwable)ex);
                return new CreatedFile("Failed to create document description: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
            }
        }
        String dadpath = URIRule.getRealPath((String)Settings.getContextPath(), (String)destinationPath);
        try {
            cf.file = creator.computeDestinationFile(number, dadpath, userFilename, parameters, today);
            if (userFilename != null && !userFilename.isEmpty() && !(userFilename + ".psml").equals(cf.file.getName())) {
                if (number < 0) {
                    cf.originalFileName = userFilename + ".psml";
                }
                if (cf.title == null) {
                    cf.title = userFilename + ".psml";
                }
            }
        }
        catch (ParseException ex) {
            LOGGER.error("Failed to create document filename", (Throwable)ex);
            return new CreatedFile("Failed to create document filename: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
        }
        File dir = cf.file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return new CreatedFile("Failed to create parent directory: " + Files.path((File)new File(Settings.getDocumentPath()), (File)dir), GeneratorStatus.SERVER_ERROR, null);
        }
        if (!dir.isDirectory()) {
            return new CreatedFile("Parent is not a directory: " + Files.path((File)new File(Settings.getDocumentPath()), (File)dir), GeneratorStatus.SERVER_ERROR, null);
        }
        if (cf.file.exists()) {
            return new CreatedFile("The file " + cf.file.getName() + " already exists.", GeneratorStatus.BAD_REQUEST, URIErrorID.INVALID_DESTINATION);
        }
        String relativePath = Files.path((File)new File(dadpath), (File)cf.file);
        if (relativePath.charAt(0) == File.separatorChar) {
            relativePath = relativePath.substring(1);
        }
        cf.path = destinationPath + "/" + URLCoder.encode((String)relativePath.replace(File.separatorChar, '/')).replaceAll("%2F", "/");
        TemplateFiles resources = new TemplateFiles(group.getOwnerDirectory());
        File template = resources.findFile("psml/" + doctype + "/document-template.psml");
        if (template == null || !template.exists()) {
            template = resources.findFile("psml/default/document-template.psml");
        }
        StringWriter contentsWriter = new StringWriter();
        try {
            PrintWriter page = new PrintWriter(contentsWriter);
            if (template == null || !template.exists()) {
                return new CreatedFile("Could not find Document template: psml/" + doctype + "/document-template.psml", GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
            }
            Processor processor = new Processor(StandardCharsets.UTF_8);
            processor.setFailOnError(true);
            HashMap<String, String> processParams = new HashMap<String, String>(params);
            processParams.put("ps.title", cf.title);
            processParams.put("ps.filename", cf.file.getName());
            processParams.put("ps.description", cf.description);
            processParams.put("ps.author", MemberRule.getFullName((Member)mem));
            processParams.put("ps.docid", cf.documentid);
            processParams.put("ps.group", cgroup.getName());
            processParams.put("ps.path", cf.path);
            processParams.put("ps.currentdate", ISO8601.format((long)today.getTime(), (ISO8601)ISO8601.CALENDAR_DATE));
            processParams.put("ps.currentdatetime", ISO8601.format((long)today.getTime(), (ISO8601)ISO8601.DATETIME));
            processParams.put("ps.currenttime", ISO8601.format((long)today.getTime(), (ISO8601)ISO8601.TIME));
            if (number >= 0) {
                processParams.put("ps.autonumber", Integer.toString(number));
            }
            processor.process(new InputSource(template.toURI().toASCIIString()), page, processParams);
        }
        catch (TemplateException ex) {
            return new CreatedFile("Failed to create content: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, URIErrorID.INVALID_PSML_CONFIG_FILE);
        }
        String contents = contentsWriter.toString();
        cf.content = contents.getBytes(StandardCharsets.UTF_8);
        ValidationResult result = this.validateContents(contents);
        if (!result.validated) {
            LOGGER.warn("new file could not be validated because no schema/schematron was found.");
        }
        if (result.errors != null) {
            return new CreatedFile("The document could not be created as it is not valid: \n" + result.errors, GeneratorStatus.BAD_REQUEST, URIErrorID.INVALID_PSML_CONFIG_FILE);
        }
        if (number > 0) {
            try {
                PSMLFileCreator.setAutonumbering(contextURI, doctype, number, mem, db);
            }
            catch (DatabaseException ex) {
                LOGGER.debug("Failed to set counter on parent folder", (Throwable)ex);
                return new CreatedFile("Failed to set counter " + number + " on parent folder: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR, null);
            }
        }
        cf.behavior = "psml-" + ("default".equals(doctype) ? "" : doctype) + "-";
        return cf;
    }

    private static final class CreatedFile {
        private String path = null;
        private String behavior = null;
        private String title = null;
        private String documentid = null;
        private String publicationId = null;
        private String publicationType = null;
        private String description = null;
        private byte[] content = null;
        private File file = null;
        private String originalFileName = null;
        private String message = null;
        private URIErrorID error = null;
        private GeneratorStatus status = GeneratorStatus.OK;

        private CreatedFile() {
        }

        private CreatedFile(String err, GeneratorStatus s, URIErrorID id) {
            this.message = err;
            this.status = s;
            this.error = id;
        }
    }

    private static final class ValidationResult {
        private boolean validated = false;
        private String errors = null;

        private ValidationResult() {
        }
    }
}

