/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.LabelsContentHandler;
import com.pageseeder.uri.URIErrorID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.diff.PSMLDiffer;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

@Requires(group=true, uri=true, parameters={"fragment"})
@Output(types={OutputType.XML})
public final class CompareFragmentEdits
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompareFragmentEdits.class);
    private static final int INTERMEDIATES_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_EVENTS = 4000000;
    private Cache cache = null;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new ViewURICheck(req.getGroup(), req.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        boolean ascending;
        if (this.cache == null) {
            this.cache = CacheManager.getInstance().getCache("edit-comparisons");
        }
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        Long start_editid = req.getParameter((Parameter)StandardParameters.start_editid, -2L);
        Long end_editid = req.getParameter((Parameter)StandardParameters.end_editid, -2L);
        String intermediates = req.getParameter((Parameter)StandardParameters.intermediates, "none");
        if (!URIRule.hasFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
            return;
        }
        List alledits = DatabaseQuery.getXLinksByURIGroupEditsFragment((Database)db, (URI)req.getURI(), (Group)group, (String)fragment, (boolean)true);
        long startid = 0L;
        long endid = 0L;
        boolean bl = ascending = start_editid < end_editid || start_editid == -2L || end_editid == -2L;
        if (!alledits.isEmpty()) {
            if (ascending) {
                startid = start_editid < 0L ? ((XLink)alledits.get(0)).getId() : start_editid;
                endid = end_editid < 0L ? ((XLink)alledits.get(alledits.size() - 1)).getId() : end_editid;
            } else {
                startid = end_editid < 0L ? ((XLink)alledits.get(0)).getId() : end_editid;
                endid = start_editid < 0L ? ((XLink)alledits.get(alledits.size() - 1)).getId() : start_editid;
            }
        }
        ArrayList<CompareEdit> edits = new ArrayList<CompareEdit>();
        int skipped = 0;
        XLink previous_edit = null;
        CompareEdit cprevious_edit = null;
        Long original_editid = null;
        for (int i = 0; i < alledits.size(); ++i) {
            XLink edit = (XLink)alledits.get(i);
            Long editid = edit.getId();
            if ("Documentation-Original".equals(edit.getContentRole()) && edit.equals(alledits.get(0))) {
                original_editid = editid;
            }
            if (editid < startid) {
                previous_edit = edit;
                continue;
            }
            if (editid > endid) continue;
            if ("none".equals(intermediates) && !editid.equals(startid) && !editid.equals(endid)) {
                ++skipped;
                continue;
            }
            if ("members".equals(intermediates) && i + 1 < alledits.size() && ((XLink)alledits.get(i + 1)).getId() <= endid && !edit.getId().equals(original_editid) && !"Documentation-Draft".equals(edit.getStatus()) && !"Documentation-Draft".equals(((XLink)alledits.get(i + 1)).getStatus()) && ((XLink)alledits.get(i + 1)).getMember() != null && ((XLink)alledits.get(i + 1)).getMember().equals((Object)edit.getMember())) {
                ++skipped;
                continue;
            }
            CompareEdit cedit = new CompareEdit(edit, previous_edit, skipped, cprevious_edit);
            edits.add(cedit);
            previous_edit = edit;
            cprevious_edit = cedit;
            skipped = 0;
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("edits");
        try {
            int i;
            long start = System.currentTimeMillis();
            int n = i = ascending ? 0 : edits.size() - 1;
            while (ascending && i < edits.size() || !ascending && i >= 0) {
                CompareEdit cedit = (CompareEdit)edits.get(i);
                XLink edit = cedit.edit;
                previous_edit = cedit.previousEdit;
                skipped = cedit.skipped;
                Long editid = edit.getId();
                boolean isDraft = "Documentation-Draft".equals(edit.getStatus());
                boolean isOriginal = edit.getId().equals(original_editid);
                xml.openElement(isDraft ? "draft" : "edit");
                xml.attribute("id", editid.toString());
                if (cedit.creationDate != null) {
                    xml.attribute("created", ISO8601.format((long)cedit.creationDate.getTime(), (ISO8601)ISO8601.DATETIME));
                }
                if ("Documentation-Hidden".equals(edit.getContentRole())) {
                    xml.attribute("deleted", "true");
                }
                if (isOriginal) {
                    xml.attribute("original", "true");
                }
                if (skipped > 0) {
                    xml.attribute("skipped", skipped);
                }
                if (!isOriginal) {
                    XMLOutputPrinter out = new XMLOutputPrinter();
                    try (UniversalPrinter uout = new UniversalPrinter((OutputPrinter)out);){
                        uout.writeEditMembers(edit);
                        uout.flush();
                        xml.writeXML(out.toString());
                    }
                }
                if (!"Documentation-Hidden".equals(edit.getContentRole())) {
                    this.writeContent(xml, fragment, edit);
                }
                if (editid.equals(startid) || editid.equals(endid) || start + 10000L > System.currentTimeMillis()) {
                    this.writeDiff(xml, fragment, edit, previous_edit);
                } else {
                    xml.openElement("diff");
                    xml.attribute("error", "This diff was not generated because the previous diffs took too long.");
                    xml.closeElement();
                }
                List notes = DatabaseQuery.getRepliesByContentRole((Database)db, (XLink)edit, (String[])new String[]{"Documentation-Note"}, null);
                if (!notes.isEmpty()) {
                    xml.openElement("notes");
                    for (XLink note : notes) {
                        XMLOutputPrinter out = new XMLOutputPrinter();
                        PSMLContentBuilder.note((XLink)note, (OutputPrinter)out);
                        xml.writeXML(out.toString());
                    }
                    xml.closeElement();
                }
                xml.closeElement();
                i += ascending ? 1 : -1;
            }
        }
        finally {
            xml.closeElement();
        }
    }

    private String buildCacheKey(XLink oldxl, XLink newxl) {
        return String.valueOf(newxl.getId()) + ":" + (newxl.getDate() != null ? String.valueOf(newxl.getDate().getTime()) : "") + "-" + oldxl.getId() + ":" + (oldxl.getDate() != null ? String.valueOf(oldxl.getDate().getTime()) : "");
    }

    private void writeContent(XMLWriter xml, String fragment, XLink edit) throws IOException {
        Iterator conti = edit.getContents();
        if (conti.hasNext()) {
            Content cont = (Content)conti.next();
            xml.openElement("content");
            String data = cont.getData();
            if (!"application/vnd.pageseeder.psml+xml".equals(cont.getType())) {
                String fragtype = PSMLContentUtils.getFragmentType((XLink)edit);
                data = this.wrapWithMediaFragment(data, fragment, fragtype, cont.getType());
            }
            data = this.addLabelsAttribute(data, edit);
            xml.writeXML(data);
            xml.closeElement();
        }
    }

    private void writeDiff(XMLWriter xml, String fragment, XLink edit, @Nullable XLink previous_edit) throws IOException {
        if (previous_edit == null || edit == null) {
            return;
        }
        Content oldcontent = (Content)previous_edit.getContents().next();
        Content newcontent = (Content)edit.getContents().next();
        xml.openElement("diff");
        if ("Documentation-Hidden".equals(previous_edit.getContentRole())) {
            String newdata = newcontent.getData();
            Object olddata = RuleUtils.generateEmptyFragment((String)newdata);
            if (newcontent.getType() != null && !"application/vnd.pageseeder.psml+xml".equals(newcontent.getType())) {
                newdata = this.wrapWithMediaFragment(newdata, fragment, PSMLContentUtils.getFragmentType((XLink)edit), newcontent.getType());
                olddata = "<media-fragment mediatype=\"" + newcontent.getType() + "\" />";
            }
            this.writeDiffContent(xml, edit, previous_edit, newdata, (String)olddata);
        } else if ("Documentation-Hidden".equals(edit.getContentRole())) {
            String olddata = oldcontent.getData();
            Object newdata = RuleUtils.generateEmptyFragment((String)olddata);
            if (oldcontent.getType() != null && !"application/vnd.pageseeder.psml+xml".equals(oldcontent.getType())) {
                olddata = this.wrapWithMediaFragment(olddata, fragment, PSMLContentUtils.getFragmentType((XLink)previous_edit), oldcontent.getType());
                newdata = "<media-fragment mediatype=\"" + oldcontent.getType() + "\" />";
            }
            this.writeDiffContent(xml, edit, previous_edit, (String)newdata, olddata);
        } else if (newcontent.getType() == null || oldcontent.getType() == null || !newcontent.getType().equals(oldcontent.getType())) {
            xml.attribute("error", "Could not compare two XLinks with different Content Types (" + oldcontent.getType() + " and " + newcontent.getType() + ")");
        } else if (newcontent.getType().endsWith("xml") || newcontent.getType().startsWith("text/") || newcontent.getType().equals("application/x-tex")) {
            String newdata = newcontent.getData();
            String olddata = oldcontent.getData();
            if (!"application/vnd.pageseeder.psml+xml".equals(newcontent.getType())) {
                newdata = this.wrapWithMediaFragment(newdata, fragment, PSMLContentUtils.getFragmentType((XLink)edit), newcontent.getType());
                olddata = this.wrapWithMediaFragment(olddata, fragment, PSMLContentUtils.getFragmentType((XLink)previous_edit), oldcontent.getType());
            }
            this.writeDiffContent(xml, edit, previous_edit, newdata, olddata);
        } else {
            xml.attribute("error", "Unsupported content type: " + newcontent.getType());
        }
        xml.closeElement();
    }

    private void writeDiffContent(XMLWriter xml, XLink edit, XLink previous_edit, @Nullable String content, @Nullable String previous_content) throws IOException {
        try {
            if (content == null || previous_content == null) {
                LOGGER.error("Content null for xlinkid: {} or xlinkid: {}", (Object)previous_edit.getId(), (Object)edit.getId());
                xml.attribute("error", "Failed to compare contents as one is null");
                return;
            }
            String key = this.buildCacheKey(previous_edit, edit);
            Element diffcache = this.cache.get((Serializable)((Object)key));
            if (diffcache != null) {
                LOGGER.debug("Found diff in cache: " + key);
                xml.writeXML((String)diffcache.getObjectValue());
                return;
            }
            LOGGER.debug("Generating diff: " + key);
            content = this.addLabelsAttribute(content, edit);
            previous_content = this.addLabelsAttribute(previous_content, previous_edit);
            StringWriter diffout = new StringWriter();
            PSMLDiffer differ = new PSMLDiffer(GlobalSettings.getInt((String)"diffXMaxEvents", (int)4000000));
            differ.diff((Reader)new StringReader(content), (Reader)new StringReader(previous_content), (Writer)diffout);
            String diff = diffout.toString();
            xml.writeXML(diff);
            this.cache.put(new Element((Serializable)((Object)key), (Serializable)((Object)diff)));
        }
        catch (Exception ex) {
            xml.attribute("error", "The content comparison hasn't been calculated. " + ex.getMessage());
        }
    }

    private String wrapWithMediaFragment(String data, String fragment, @Nullable String fragtype, @Nullable String mediatype) {
        if (mediatype == null) {
            return data;
        }
        return "<media-fragment id=\"" + XML.escapeAttr((String)fragment) + "\"" + (String)(fragtype != null ? " type=\"" + XML.escapeAttr((String)fragtype) + "\"" : "") + " mediatype=\"" + XML.escapeAttr((String)mediatype) + "\">" + (mediatype.endsWith("xml") ? data : XML.escape((String)data)) + "</media-fragment>";
    }

    private String addLabelsAttribute(String data, XLink xl) throws IOException {
        String labels = String.join((CharSequence)",", Labels.getLabels((XLink)xl));
        if (labels.isEmpty()) {
            return data;
        }
        StringWriter newdata = new StringWriter();
        LabelsContentHandler handler = new LabelsContentHandler(newdata, labels);
        try {
            XMLHelpers.parse((InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)), (ContentHandler)handler);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to parse incoming content", (Throwable)ex);
            throw new IOException("Failed to parse incoming content: " + ex.getMessage(), ex);
        }
        return newdata.toString();
    }

    private final class CompareEdit {
        public final XLink edit;
        public final XLink previousEdit;
        public final Date creationDate;
        final int skipped;

        public CompareEdit(XLink current, XLink previous, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable int skipped, CompareEdit cprevious) {
            this.edit = current;
            this.previousEdit = previous;
            this.skipped = skipped;
            this.creationDate = cprevious != null && cprevious.creationDate != null && current.getDate() != null && !cprevious.creationDate.before(current.getDate()) ? new Date(cprevious.creationDate.getTime() + 1000L) : current.getDate();
        }
    }
}

