/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ArchiveXLinkCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.FragmentIDsLoader;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.psml.CreateFragment;
import com.pageseeder.psml.Structure;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

@Requires(uri=true, member=true, parameters={"editid"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class ArchiveDraft
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateFragment.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Long editid = req.getParameter((Parameter)StandardParameters.editid, -1L);
        XLink edit = DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)editid);
        if (edit == null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ArchiveXLinkCheck(req.getURI(), edit));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Long editid;
        Database db = req.getDatabase();
        XLink edit = DatabaseQuery.getXLinkById((Database)db, (Long)(editid = Long.valueOf(req.getParameter((Parameter)StandardParameters.editid, -1L))));
        if (edit == null || !"Documentation".equals(edit.getContentRole()) && !"Documentation-Hidden".equals(edit.getContentRole()) || !"Documentation-Draft".equals(edit.getStatus())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.EDIT_NOT_FOUND, "Draft was not found with ID: " + editid);
            return;
        }
        Locator loc = LocatorRule.getLocatorByXLink((Database)db, (XLink)edit);
        if (!req.getURI().equals((Object)URIRule.getURIByLocator((Database)db, (Locator)loc))) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.EDIT_NOT_FOUND, "Draft with this ID not found on URI: " + editid);
            return;
        }
        String fragment = loc.getFragment();
        URI uri = req.getURI();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("draft-delete");
        if (this.hasContent(loc, editid, uri, db) || req.getGroup() == null) {
            XLinkRule.archiveXLink((XLink)edit);
            edit.setModifiedBy(req.getMember());
            Date modified = new Date();
            edit.setModifiedDate(modified);
        } else {
            LocatorRule.deleteLocator((Database)db, (URI)uri, (Locator)loc);
            try {
                Structure.removeFragmentFromStructureXLink(fragment, uri, req.getGroup(), req.getMember(), db);
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to update structure XLink", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
                return;
            }
            out.field("fragmentdeleted", true);
            uri.setLastModified(new Date());
        }
        out.endObject();
    }

    private boolean hasContent(Locator loc, long draftid, URI uri, Database db) throws IOException {
        boolean bl;
        Iterator xlinks = loc.getXLinksForLocator((Object)Predicates.predicateLocatorForXLinkByContentRoleEquals((Database)db, (String)"Documentation-Original", (boolean)false));
        while (xlinks.hasNext()) {
            if (((LocatorForXLink)xlinks.next()).getXLink().getId() == draftid) continue;
            return true;
        }
        if (!URIRule.isPSML((URI)uri)) {
            return false;
        }
        FragmentIDsLoader handler = new FragmentIDsLoader();
        InternalURIFetcher fetcher = new InternalURIFetcher(uri, null);
        try {
            XMLHelpers.parse((InputStream)fetcher.getContent(), (ContentHandler)handler);
            bl = handler.getFragmentIDs().contains(loc.getFragment());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fetcher.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FoundationException | IOException ex) {
                LOGGER.error("Failed to parse original document", ex);
                return true;
            }
        }
        fetcher.close();
        return bl;
    }
}

