/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.organization;

import com.pageseeder.base.generator.Output;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.UIConfig;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.ResourceCompressor;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.IMAGE})
@PublicAPI(value=PublicAPI.Support.UNSUPPORTED)
public final class OrganizationFaviconServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationFaviconServlet.class);
    private Favicon cache = null;
    private static final String CACHE_CONTROL = "public max-age=604800";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Favicon favicon;
        boolean reload = "no-cache".equals(req.getHeader("Cache-Control"));
        try {
            favicon = this.getFavicon(req.getServletContext(), reload);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to load favicon!", (Throwable)ex);
            res.sendRedirect("/weborganic/ui/favicons/blue/favicon.svg");
            return;
        }
        long since = req.getDateHeader("If-Modified-Since");
        if (since > 0L && since == favicon.getLastModified()) {
            res.setStatus(304);
            res.setDateHeader("Last-Modified", favicon.lastModified);
            res.setHeader("Cache-Control", CACHE_CONTROL);
            return;
        }
        byte[] bytes = favicon.getBytes();
        res.setCharacterEncoding("utf-8");
        res.setContentType("image/svg+xml");
        res.setHeader("Vary", "Accept-Encoding");
        res.setDateHeader("Last-Modified", favicon.lastModified);
        res.setHeader("Cache-Control", CACHE_CONTROL);
        if (HttpRequests.acceptsGZipCompression((HttpServletRequest)req)) {
            bytes = ResourceCompressor.compress((byte[])favicon.getBytes());
            res.setHeader("Content-Encoding", "gzip");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(bytes);
        res.setContentLength(bytes.length);
        res.flushBuffer();
    }

    private Favicon getFavicon(ServletContext context, boolean reload) throws IOException {
        Favicon favicon = this.cache;
        if (favicon == null || reload) {
            Favicon latest = OrganizationFaviconServlet.loadFavicon(context);
            if (favicon == null || !favicon.equals(latest)) {
                LOGGER.info("Updating favicon cache");
                this.cache = latest;
                return latest;
            }
        }
        return favicon;
    }

    private static Favicon loadFavicon(ServletContext context) throws IOException {
        OrganizationManager manager;
        String globalTemplate = GlobalSettings.getGlobalTemplate((String)"");
        UIConfig.Theme theme = UIConfig.Theme.ANY;
        byte[] bytes = null;
        if (!globalTemplate.isEmpty() && !(manager = OrganizationManager.instance()).hasError()) {
            UIConfig config = manager.getUIConfig();
            theme = config.getTheme();
            bytes = OrganizationFaviconServlet.getCustomFavicon(context, globalTemplate, config);
        }
        if (bytes == null) {
            bytes = OrganizationFaviconServlet.getDefaultFavicon(context, theme);
        }
        return new Favicon(bytes);
    }

    private static byte[] getDefaultFavicon(ServletContext context, UIConfig.Theme theme) throws IOException {
        String themeColor = theme == UIConfig.Theme.ANY ? "blue" : theme.name().toLowerCase();
        String path = "/weborganic/ui/favicons/" + themeColor + "/favicon.svg";
        LOGGER.info("Loading default favicon from {}", (Object)path);
        File iconFile = new File(context.getRealPath(path));
        return Files.readAllBytes(iconFile.toPath());
    }

    private static byte[] getCustomFavicon(ServletContext context, String globalTemplate, UIConfig config) {
        String iconFilename = config.getIcon();
        if (iconFilename != null && !iconFilename.isEmpty()) {
            String path = "/WEB-INF/config/template/" + globalTemplate + "/organization/style/" + iconFilename;
            LOGGER.info("Loading custom favicon from {}", (Object)path);
            File iconFile = new File(context.getRealPath(path));
            if (iconFile.exists()) {
                return OrganizationFaviconServlet.processFavicon(iconFile, config.getTheme());
            }
        }
        return null;
    }

    private static byte[] processFavicon(File iconFile, UIConfig.Theme theme) {
        try {
            String background = OrganizationFaviconServlet.getBackground(theme);
            Transformer transformer = OrganizationFaviconServlet.getFaviconTransformer();
            transformer.setParameter("background-color", background);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(iconFile), new StreamResult(buffer));
            return buffer.toByteArray();
        }
        catch (TransformerException ex) {
            LOGGER.error("Unable to generate custom favicon due to {}", (Object)ex.getMessage());
            return null;
        }
    }

    private static String getBackground(UIConfig.Theme theme) {
        switch (theme) {
            case CONTRAST: {
                return "hsl(211, 25%, 16.7%)";
            }
            case GREEN: {
                return "hsl(152, 73.9%, 31.6%)";
            }
            case PURPLE: {
                return "hsl(273, 45%, 40%)";
            }
            case RED: {
                return "hsl(10, 100%, 35.9%)";
            }
            case STEEL: {
                return "hsl(211, 28%, 37.1%)";
            }
            case TEAL: {
                return "hsl(180, 50%, 32%)";
            }
            case YELLOW: {
                return "hsl(45, 85%, 35%)";
            }
        }
        return "hsl(205, 98.9%, 37.1%)";
    }

    private static Transformer getFaviconTransformer() throws TransformerException {
        Transformer transformer;
        block8: {
            String filepath = "/com/pageseeder/organization/favicon.xsl";
            TransformerFactory factory = XMLHelpers.safeTransformerFactory();
            InputStream is = OrganizationFaviconServlet.class.getResourceAsStream(filepath);
            try {
                transformer = factory.newTemplates(new StreamSource(is)).newTransformer();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return factory.newTransformer();
                }
            }
            is.close();
        }
        return transformer;
    }

    private static final class Favicon {
        private final byte[] bytes;
        private final long lastModified;

        Favicon(byte[] favicon) {
            this.bytes = favicon;
            this.lastModified = System.currentTimeMillis();
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Favicon favicon = (Favicon)o;
            return Arrays.equals(this.getBytes(), favicon.getBytes());
        }

        public int hashCode() {
            return Arrays.hashCode(this.getBytes());
        }
    }
}

