/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.organization;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.pageseeder.psml.md.MarkdownParser;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(parameters={"name"})
public class MarkdownDocument
implements Generator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkdownDocument.class);

    @ContentPermission(value=NoCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String document = req.getParameter((Parameter)StandardParameters.name);
        document = RuleUtils.replaceNonFilenameChars((String)document);
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        if (globalTemplate != null) {
            String path = "/WEB-INF/config/template/" + globalTemplate + "/organization/" + document + ".md";
            File file = new File(Settings.getContextPath(), path);
            LOGGER.debug("Loading organization document {}", (Object)file);
            if (file.exists() && file.isFile()) {
                try (FileReader fileReader = new FileReader(file, StandardCharsets.UTF_8);){
                    MarkdownParser parser = new MarkdownParser();
                    PSMLElement psml = parser.parse((Reader)fileReader);
                    XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
                    psml.toXML((XMLWriter)xml);
                    Object doc = xml.toString();
                    if (!((String)doc).startsWith("<document")) {
                        doc = "<document>" + (String)doc + "</document>";
                    }
                    res.getXMLWriter().writeXML((String)doc);
                }
            } else {
                res.setError(GeneratorStatus.NOT_FOUND, "Invalid document path " + path);
            }
        } else {
            res.setError(GeneratorStatus.BAD_REQUEST, "There is no globalTemplate property specified");
        }
    }
}

