/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.db.CreateFailedException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.DeleteFailedException;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.Moderator;
import com.pageseeder.db.model.Role;
import com.pageseeder.member.MemberErrorID;
import java.util.Collection;
import org.slf4j.LoggerFactory;

public class Memberships {
    protected static MemberForGroup findModerator(Group group, Database db) {
        Collection mfgs;
        try {
            mfgs = DatabaseQuery.getMemberForGroupsByGroupId((Database)db, (Long)group.getId());
        }
        catch (QueryFailedException ex) {
            LoggerFactory.getLogger(Memberships.class).error("Failed to load group members", (Throwable)ex);
            return null;
        }
        for (MemberForGroup mfg : mfgs) {
            if (mfg.getModerator() == null) continue;
            return mfg;
        }
        return null;
    }

    protected static void setAsModerator(MemberForGroup mfg, Database db) throws InsertFailedException, CreateFailedException {
        if (mfg.getModerator() != null) {
            throw new IllegalArgumentException("Member is already a moderator");
        }
        Moderator mod = Moderator.create((Database)db);
        mod.setQuota(Integer.valueOf(0));
        mod.setQuotaReceived(Integer.valueOf(0));
        mod = mod.insert(db);
        mfg.setModerator(mod);
    }

    protected static void removeAsModerator(MemberForGroup mfg, Database db) throws DeleteFailedException {
        if (mfg.getModerator() == null) {
            return;
        }
        Moderator other = mfg.getModerator();
        mfg.setModerator(null);
        other.delete(db);
    }

    protected static MemberForGroup getMemberForGroup(Member member, Group group) {
        for (MemberForGroup mfg : member.getGroupsForMemberCol()) {
            if (!mfg.getGroup().getId().equals(group.getId())) continue;
            return mfg;
        }
        return null;
    }

    protected static boolean checkRole(String role, GeneratorResponse res) {
        if (role != null) {
            if (Role.forAttribute((String)role) != null) {
                return true;
            }
            if (Role.forTitle((String)role) != null) {
                return true;
            }
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.ILLEGAL_ROLE);
            return false;
        }
        return true;
    }
}

