/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewMemberGroupsCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class ListMembershipsForMember
implements Generator,
SingleCheck,
Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListMembershipsForMember.class);
    private static final Comparator<Membership> SORT_BY_GROUP_NAME = Comparator.comparing(m -> m.getGroup().getName());

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        boolean self = req.getParameter((Parameter)StandardParameters.self, false);
        if (self) {
            return new NoCheck();
        }
        boolean extendedmember = req.getParameter((Parameter)StandardParameters.extendedmember, false);
        return extendedmember ? new ViewMemberCheck(Members.getMember(req)) : new ViewMemberGroupsCheck(Members.getMember(req));
    }

    public String getETag(GeneratorRequest req) throws DatabaseException {
        boolean self = req.getParameter((Parameter)StandardParameters.self, false);
        Member m = self ? req.getAuthenticatedMember() : Members.getMember(req);
        boolean subgroups = req.getParameter((Parameter)StandardParameters.subgroups, true);
        boolean inherited = req.getParameter((Parameter)StandardParameters.inherited, false);
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        boolean extendedmember = req.getParameter((Parameter)StandardParameters.extendedmember, false);
        return m != null ? MD5.hash((String)(new MembershipCache().getETag(m.getId()) + Boolean.toString(subgroups) + self + archived + inherited + extendedmember)) : null;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member m;
        Database db = req.getDatabase();
        boolean self = req.getParameter((Parameter)StandardParameters.self, false);
        try {
            m = self ? req.getAuthenticatedMember() : Members.getMember(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load member from DB");
            return;
        }
        if (m == null) {
            if (self) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_LOGGED_IN);
            } else {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            }
            return;
        }
        boolean checkSelf = m.getId().equals(req.getAuthenticatedMember().getId());
        boolean admin = MemberRule.isAdministrator((Database)db, (Member)req.getAuthenticatedMember());
        boolean subgroups = req.getParameter((Parameter)StandardParameters.subgroups, true);
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        boolean inherited = req.getParameter((Parameter)StandardParameters.inherited, false);
        boolean extendedmember = req.getParameter((Parameter)StandardParameters.extendedmember, false);
        List all_memberships = MemberForGroupRule.getMemberMemberships((Collection)m.getGroupsForMemberCol((Object)Predicates.predicateMemberForGroupRegistered((Database)db, (boolean)archived)), (boolean)subgroups, (Database)db);
        List<Membership> memberships = new ArrayList();
        if (!(self || checkSelf || admin)) {
            UserDetails details = new UserDetailsManager().get(db, req.getAuthenticatedMember().getId(), false);
            List groupnames = MemberRule.getManagerGroupnames((UserDetails)details);
            for (Membership membership : all_memberships) {
                if (!groupnames.contains(membership.getGroup().getName())) continue;
                memberships.add(membership);
            }
        } else {
            memberships = all_memberships;
        }
        memberships.sort(SORT_BY_GROUP_NAME);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("memberships");
        boolean isAdmin = extendedmember && (self || checkSelf ? admin : MemberRule.isAdministrator((Database)db, (Member)m));
        out.writeMember(m, true, extendedmember, "member", null, extendedmember && isAdmin);
        MemberDetailsConfig.Visibility visibility = self ? MemberDetailsConfig.Visibility.MEMBER : (!checkSelf || admin ? MemberDetailsConfig.Visibility.MANAGER : MemberDetailsConfig.Visibility.MEMBER);
        out.startCollection("memberships", OutputPrinter.CollectionOption.JSON_ONLY);
        ArrayList<String> fakeProjectMemberships = new ArrayList<String>();
        for (Membership membership : memberships) {
            Group group = membership.getGroup();
            if (archived != GroupRule.isArchived((Group)group) || "admin".equals(group.getName())) continue;
            MemberDetailsConfig config = this.tryGetMemberDetailsConfig(group);
            out.writeMembership(membership, UniversalPrinter.MembershipFormatOption.GROUP_ONLY, config, visibility, db);
            if (!inherited) continue;
            this.addInheritedProjectMemberships(group.getName(), memberships, fakeProjectMemberships, db, out);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private MemberDetailsConfig tryGetMemberDetailsConfig(Group group) {
        MemberDetailsConfig config = null;
        try {
            config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
        }
        catch (FoundationException ex) {
            LOGGER.error("Unable to configure the member details for group: {}", (Object)group.getName());
        }
        return config;
    }

    private void addInheritedProjectMemberships(String groupName, List<Membership> memberships, List<String> alreadyDone, Database db, UniversalPrinter out) throws QueryFailedException {
        String project = GroupRule.getParentProjectName((String)groupName);
        if (project == null) {
            return;
        }
        if (!alreadyDone.contains(project) && memberships.stream().noneMatch(mb -> mb.getGroup().getName().equals(project))) {
            out.startObject("membership");
            out.field("status", "normal");
            out.field("role", "guest");
            out.field("inherited", true);
            out.writeGroup(DatabaseQuery.getGroupByName((Database)db, (String)project), true, false, false, db);
            out.endObject();
            alreadyDone.add(project);
        }
        this.addInheritedProjectMemberships(project, memberships, alreadyDone, db, out);
    }
}

