/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON, OutputType.CSV})
public final class ListMembersForGroup
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;
    private static final Map<String, String> CSV_COLUMNS = new LinkedHashMap<String, String>();

    @ContentPermission(value=ViewMembersCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ManageAccountCheck();
        }
        if ("manager".equals(req.getParameter((Parameter)StandardParameters.role))) {
            return new EditGroupCheck(group);
        }
        return new ViewMembersCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        List memberships;
        List mfgs;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        String members = req.getParameter((Parameter)StandardParameters.members);
        String usernames = req.getParameter((Parameter)StandardParameters.usernames);
        boolean subgroups = req.getParameter((Parameter)StandardParameters.subgroups, true);
        boolean deleted = req.getParameter((Parameter)StandardParameters.deleted, false);
        boolean limitReached = false;
        if ("admin".equals(group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.GROUP_NOT_ALLOWED);
            return;
        }
        MemberDetailsConfig config = null;
        if (group.getDetailsForm() != null) {
            try {
                config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
            }
            catch (FoundationException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_CONFIGURE_MEMBER_DETAILS);
                return;
            }
        }
        List<String> membernames = null;
        ArrayList<Long> memberids = null;
        if (members != null) {
            memberids = new ArrayList<Long>();
            for (String memberid : members.split(",")) {
                try {
                    memberids.add(Long.parseLong(memberid));
                }
                catch (NumberFormatException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_MEMBER_ID, "Invalid member id: " + memberid);
                    return;
                }
            }
        } else if (usernames != null) {
            membernames = Arrays.asList(usernames.split(","));
        }
        if (subgroups && (memberids == null || memberids.isEmpty()) && (membernames == null || membernames.isEmpty())) {
            mfgs = DatabaseQuery.getMembersForGroupByGroupIdSubgroups((Database)db, (int)pagesize, (Long)group.getId(), (boolean)deleted);
            if (mfgs.size() > pagesize && mfgs.size() > 0) {
                Long lastmemberid = ((MemberForGroup)mfgs.get(mfgs.size() - 1)).getMember().getId();
                for (int i = mfgs.size() - 1; i >= 0 && lastmemberid.equals(((MemberForGroup)mfgs.get(i)).getMember().getId()); --i) {
                    mfgs.remove(i);
                }
                limitReached = true;
            }
            memberships = MemberForGroupRule.getGroupMemberships((Collection)group.getMemberGroups(), (Collection)mfgs);
        } else {
            mfgs = DatabaseQuery.getMembersForGroupByGroupIdAlphaCol((Database)db, (int)page, (int)pagesize, (Long)group.getId(), (boolean)deleted, membernames, memberids);
            if (mfgs.size() > pagesize) {
                mfgs.remove(mfgs.size() - 1);
                limitReached = true;
            }
            memberships = MemberForGroupRule.getGroupMemberships(null, (Collection)mfgs);
        }
        memberships.sort(MemberForGroupRule.SORT_MEMBERSHIP_BY_MEMBER_NAME);
        boolean manager = "manager".equals(req.getParameter((Parameter)StandardParameters.role));
        MemberDetailsConfig.Visibility visibility = manager ? MemberDetailsConfig.Visibility.MANAGER : MemberDetailsConfig.Visibility.GROUP;
        UniversalPrinter out = res.getUniversalWriter();
        if (out.getType() == OutputType.CSV) {
            out.setCSVOutput("membership", this.toCSVColumns(config, visibility));
            out.setCSVDateTimeFields(List.of("created"));
        }
        out.startObject("memberships");
        out.field("count", (long)memberships.size());
        if (limitReached) {
            out.field("limitreached", true);
        }
        out.writeGroup(group);
        out.startCollection("memberships", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Membership m : memberships) {
            out.writeMembership(m, UniversalPrinter.MembershipFormatOption.MEMBER_ONLY, config, visibility, db);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private Map<String, String> toCSVColumns(MemberDetailsConfig config, MemberDetailsConfig.Visibility visibility) {
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        columns.putAll(CSV_COLUMNS);
        if (config != null) {
            for (int i = 1; i <= 15; ++i) {
                if (!config.isDefined(i) || !config.isVisibleTo(i, visibility)) continue;
                MemberDetailsConfig.FieldConfig fc = config.getFieldConfig(i);
                columns.put("details." + fc.name(), (String)(fc.getTitle() != null ? fc.getTitle() : "Field " + i));
            }
        }
        return columns;
    }

    static {
        CSV_COLUMNS.put("member.id", "Member ID");
        CSV_COLUMNS.put("member.firstname", "First name");
        CSV_COLUMNS.put("member.surname", "Surname");
        CSV_COLUMNS.put("member.email", "Email");
        CSV_COLUMNS.put("member.username", "Username");
        CSV_COLUMNS.put("status", "Status");
        CSV_COLUMNS.put("notification", "Notification");
        CSV_COLUMNS.put("role", "Role");
        CSV_COLUMNS.put("created", "Added");
    }
}

