/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.Collection;

@Requires(database=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class ListInvitationsForMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        return new ViewMemberCheck(Members.getMember(req));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        try {
            Member m = Members.getMember(req);
            if (m == null) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
                return;
            }
            Collection mfgs = m.getGroupsForMemberCol((Object)Predicates.predicateMemberForGroupEditorFlagsContain((Database)req.getDatabase(), (String)"n", (boolean)true));
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("invitations");
            out.writeMember(m);
            out.startCollection("invitations", OutputPrinter.CollectionOption.JSON_ONLY);
            for (MemberForGroup mfg : mfgs) {
                out.writeMembership(new Membership(mfg), UniversalPrinter.MembershipFormatOption.GROUP_ONLY, null, MemberDetailsConfig.Visibility.MEMBER, null);
            }
            out.endCollection();
            out.endObject();
            out.flush();
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load member from DB");
        }
    }
}

