/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import com.pageseeder.membership.Memberships;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, member=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class EditMembership
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditMembership.class);

    @ContentPermission(value=ViewMemberCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Member member = Members.getMember(req);
        String password = req.getParameter((Parameter)StandardParameters.member_password);
        String currentpwd = req.getParameter((Parameter)StandardParameters.current_password);
        if (password != null && currentpwd == null) {
            return new ManageAccountCheck();
        }
        if (req.getParameter((Parameter)StandardParameters.force_email_change, false) || req.getParameter((Parameter)StandardParameters.role) != null || !req.getParameter((Parameter)StandardParameters.password_email, true)) {
            return new ManageAccountCheck();
        }
        return new ViewMemberCheck(member);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Notification notification;
        UserDetailsManager user_manager;
        boolean changedMembership;
        boolean changedMember;
        MemberDetailsConfig config;
        Group group;
        MemberForGroup mfg;
        boolean welcome_email;
        boolean deregister;
        boolean accept;
        String role;
        String notify;
        String listed;
        Database db;
        Member member;
        block58: {
            member = Members.getMember(req);
            if (member == null) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
                return;
            }
            db = req.getDatabase();
            String firstname = req.getParameter((Parameter)StandardParameters.firstname);
            String surname = req.getParameter((Parameter)StandardParameters.surname);
            String email = req.getParameter((Parameter)StandardParameters.email);
            String username = req.getParameter((Parameter)StandardParameters.member_username);
            String password = req.getParameter((Parameter)StandardParameters.member_password);
            String currentpwd = req.getParameter((Parameter)StandardParameters.current_password);
            listed = req.getParameter((Parameter)StandardParameters.listed);
            notify = req.getParameter((Parameter)StandardParameters.notification);
            role = req.getParameter((Parameter)StandardParameters.role);
            accept = req.getParameter((Parameter)StandardParameters.accept, false);
            deregister = req.getParameter((Parameter)StandardParameters.deregister, false);
            welcome_email = req.getParameter((Parameter)StandardParameters.welcome_email, true);
            boolean pwdemail = req.getParameter((Parameter)StandardParameters.password_email, true);
            boolean mem_admin = MemberRule.isAdministrator((Database)db, (Member)member);
            if (!Members.checkNames(firstname, surname, res)) {
                return;
            }
            if (!Members.checkEmailUsername(email, username, member, mem_admin, db, res)) {
                return;
            }
            if (!Members.checkPassword(password, mem_admin, res)) {
                return;
            }
            if (password != null && currentpwd != null) {
                try {
                    if (!SecurityUtils.checkPassword((String)currentpwd, (String)member.getPassword())) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INCORRECT_PASSWORD);
                        return;
                    }
                }
                catch (FoundationException e) {
                    throw new GeneratorException((Throwable)e);
                }
            }
            if ((mfg = Memberships.getMemberForGroup(member, group = req.getGroup())) == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_A_MEMBER, "User '" + member.getUsername() + "' is not a member of " + String.valueOf(group));
                return;
            }
            if (deregister && accept) {
                String message = "User '" + member.getUsername() + "' cannot simultaneously accept and deregister";
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.CONTRADICTORY_DEREGISTRATION, message);
                return;
            }
            config = null;
            if (group.getDetailsForm() != null) {
                try {
                    config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
                }
                catch (FoundationException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_CONFIGURE_MEMBER_DETAILS);
                    return;
                }
            }
            changedMember = false;
            changedMembership = false;
            if (firstname != null) {
                if (!firstname.equals(member.getFirstName())) {
                    changedMember = true;
                }
                member.setFirstName(firstname);
            }
            if (surname != null) {
                if (!surname.equals(member.getSurname())) {
                    changedMember = true;
                }
                member.setSurname(surname);
            }
            if (email != null) {
                if (email.length() == 0) {
                    email = "No Email";
                }
                if (!email.equalsIgnoreCase(member.getEmail())) {
                    if ("true".equals(req.getParameter((Parameter)StandardParameters.force_email_change))) {
                        if (!email.equals(member.getEmail())) {
                            changedMember = true;
                        }
                        String previousEmail = member.getEmail();
                        member.setEmail(email);
                        SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.EMAIL_CHANGE, (String)"Email address changed by admin from {} to {}", (Object[])new Object[]{previousEmail, member.getEmail()});
                    } else {
                        try {
                            Emails.sendChangeEmail((Database)db, (Group)group, (Member)member, (String)email, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                        }
                        catch (EmailException e) {
                            res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_SEND_EMAIL_CONFIRM);
                            return;
                        }
                    }
                }
            }
            user_manager = new UserDetailsManager();
            if (username != null) {
                String new_username;
                String string = new_username = username.length() > 0 ? username : member.getEmail();
                if (!new_username.equals(member.getUsername())) {
                    changedMember = true;
                }
                member.setUsername(new_username);
            }
            try {
                if (password == null) break block58;
                member.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
                member.setLastPasswordChange(new Date());
                member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'p'));
                changedMember = true;
                LOGGER.info("Password changed {}for {}", (Object)(currentpwd == null ? "by admin " : ""), (Object)(MemberRule.hasEmail((Member)member) ? member.getEmail() : member.getUsername()));
                if (!pwdemail) break block58;
                try {
                    Emails.sendPasswordChangeEmail((Database)db, (Member)member, (Group)req.getGroup(), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
                catch (EmailException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_SEND_PASSWORD_CONFIRM);
                    return;
                }
            }
            catch (FoundationException e) {
                throw new GeneratorException((Throwable)e);
            }
        }
        Role r = Role.forAttribute((String)role);
        if (r == null) {
            r = Role.forTitle((String)role);
        }
        if (role != null && r == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.ILLEGAL_ROLE);
            return;
        }
        if (r != null) {
            if (r == Role.MODERATOR || r == Role.MODERATOR_AND_APPROVER) {
                MemberForGroup moderator = Memberships.findModerator(group, db);
                if (moderator != null && !moderator.getId().equals(mfg.getId())) {
                    Memberships.removeAsModerator(moderator, db);
                }
                if (mfg.getModerator() == null) {
                    Memberships.setAsModerator(mfg, db);
                }
            } else if (mfg.getModerator() != null) {
                Memberships.removeAsModerator(mfg, db);
            }
            String editorFlags = r.updateFlags(mfg.getEditorFlags());
            if (editorFlags == null && mfg.getEditorFlags() != null || editorFlags != null && mfg.getEditorFlags() == null || editorFlags != null && mfg.getEditorFlags() != null && !editorFlags.equals(mfg.getEditorFlags()) || mfg.getEditor().booleanValue() != r.isEditor()) {
                changedMembership = true;
            }
            mfg.setEditorFlags(editorFlags);
            mfg.setEditor(Boolean.valueOf(r.isEditor()));
            new UserDetailsManager().remove(member.getId());
        }
        boolean welcomeEmailFailed = false;
        String flags = mfg.getEditorFlags();
        if (accept) {
            if (flags == null || flags.indexOf(110) == -1 && flags.indexOf(115) == -1) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_INVITATION);
                return;
            }
            String newflags = Flags.remove((String)Flags.remove((String)Flags.remove((String)flags, (char)'d'), (char)'n'), (char)'s');
            if (!flags.equals(newflags)) {
                changedMembership = true;
            }
            mfg.setEditorFlags(newflags);
            user_manager.remove(member.getId());
            if (welcome_email) {
                try {
                    Member inviter = req.getAuthenticatedMember();
                    Emails.sendMembershipComplete((Database)db, (MemberForGroup)mfg, (Member)(inviter.getId().equals(member.getId()) ? null : inviter), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
                catch (EmailException ex) {
                    welcomeEmailFailed = true;
                    req.getLogger((Object)this).error("Failed to send new member email", (Throwable)ex);
                }
            }
        }
        if (deregister) {
            if (mfg.getModerator() != null) {
                Memberships.removeAsModerator(mfg, db);
            }
            if (mfg.getEditor().booleanValue() || !"d".equals(mfg.getEditorFlags())) {
                changedMembership = true;
            }
            mfg.setEditor(Boolean.FALSE);
            mfg.setEditorFlags("d");
            user_manager.remove(member.getId());
        }
        if ((notification = Notification.forType((String)notify)) != null) {
            if (notification != Notification.forType((String)mfg.getNotification())) {
                changedMembership = true;
            }
            mfg.setNotification(notification.type());
        }
        if (listed != null) {
            if ("true".equals(listed) == mfg.getListed().booleanValue()) {
                changedMembership = true;
            }
            mfg.setListed(Boolean.valueOf("true".equals(listed)));
        }
        boolean admin = false;
        Member auth_mem = req.getAuthenticatedMember();
        if (auth_mem != null) {
            UserDetails userdetails = user_manager.get(db, auth_mem.getId());
            admin = MemberRule.isAdministrator((Map)userdetails.flags());
        }
        if (config != null) {
            List fields = MemberGroupDetailsRule.toFieldValues((GeneratorRequest)req);
            MemberGroupDetails mgd = MemberGroupDetailsRule.updateDetails((Database)db, (Member)member, (List)fields, (Group)group, (MemberForGroup)mfg, (boolean)admin);
            mfg.setMemberGroupDetails(mgd);
            changedMembership = true;
        }
        req.getTransaction().commit();
        if (changedMember) {
            ChangesManager.getInstance().modifyMember(db, member);
        }
        if (changedMember || changedMembership) {
            ChangesManager.getInstance().modifyMembership(db, mfg);
        }
        new MembershipCache().remove(member.getId());
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("membership-modification");
        if (welcomeEmailFailed) {
            out.field("welcome-email-failed", true);
        }
        out.writeMembership(new Membership(mfg), config, MemberDetailsConfig.Visibility.MEMBER, db);
        out.endObject();
        out.flush();
    }
}

