/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.IOException;

@Requires(member=true, database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class GetPersonalGroup
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Group grp = GroupRule.getMemberPersonalGroup((Database)req.getDatabase(), (Member)req.getMember());
        UniversalPrinter out = res.getUniversalWriter();
        if (grp != null) {
            out.writeGroup(grp);
        } else {
            out.startObject("no-group");
            out.endObject();
        }
        out.flush();
    }
}

