/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import com.pageseeder.member.ProfilePictureServlet;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true)
@PublicAPI
public final class EditMember
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditMember.class);

    @ContentPermission(value=ViewMemberCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Member mem;
        String token = req.getParameter((Parameter)StandardParameters.token);
        String password = req.getParameter((Parameter)StandardParameters.member_password);
        String currentpwd = req.getParameter((Parameter)StandardParameters.current_password);
        if (password != null && currentpwd == null && token == null || req.getParameter((Parameter)StandardParameters.disabled) != null || req.getParameter((Parameter)StandardParameters.force_email_change, false) || !req.getParameter((Parameter)StandardParameters.password_email, true)) {
            return new ManageAccountCheck();
        }
        try {
            mem = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            return new NoCheck();
        }
        if (token != null && mem != null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(mem);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Member member;
        Database db = req.getDatabase();
        try {
            member = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load member from DB");
            return;
        }
        if (member == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        String tokenString = req.getParameter((Parameter)StandardParameters.token);
        PersistentToken token = null;
        if (tokenString != null && ((token = OAuthQuery.getPersistentToken((Database)db, (String)tokenString, (Member)member)) == null || !token.hasPurpose(PersistentToken.Purpose.activate_member) || token.hasExpired())) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Invalid token used to update details of member {} ({})", (Object[])new Object[]{member.getUsername(), member.getId()});
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID);
            return;
        }
        String firstname = req.getParameter((Parameter)StandardParameters.firstname);
        String surname = req.getParameter((Parameter)StandardParameters.surname);
        String email = req.getParameter((Parameter)StandardParameters.email);
        String username = req.getParameter((Parameter)StandardParameters.member_username);
        String password = req.getParameter((Parameter)StandardParameters.member_password);
        String currentpwd = req.getParameter((Parameter)StandardParameters.current_password);
        String onvacation = req.getParameter((Parameter)StandardParameters.on_vacation);
        String disabled = req.getParameter((Parameter)StandardParameters.disabled);
        String emailattach = req.getParameter((Parameter)StandardParameters.email_attachments);
        boolean pwdemail = req.getParameter((Parameter)StandardParameters.password_email, true);
        boolean forceEmail = req.getParameter((Parameter)StandardParameters.force_email_change, false);
        boolean admin = MemberRule.isAdministrator((Database)db, (Member)member);
        if (!Members.checkNames(firstname, surname, res)) {
            return;
        }
        if (!Members.checkEmailUsername(email, username, member, admin, db, res)) {
            return;
        }
        if (!Members.checkPassword(password, admin, res)) {
            return;
        }
        if (password != null && currentpwd != null) {
            try {
                if (!SecurityUtils.checkPassword((String)currentpwd, (String)member.getPassword())) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INCORRECT_PASSWORD);
                    return;
                }
            }
            catch (FoundationException e) {
                throw new GeneratorException((Throwable)e);
            }
        }
        if ("true".equals(disabled) && member.equals((Object)req.getAuthenticatedMember())) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Can't disable yourself");
            return;
        }
        String emailChangeConfirmEmailSentTo = null;
        if (firstname != null) {
            member.setFirstName(firstname);
        }
        if (surname != null) {
            member.setSurname(surname);
        }
        if (email != null) {
            if (email.isEmpty()) {
                email = "No Email";
            }
            if (!email.equalsIgnoreCase(member.getEmail())) {
                if (forceEmail) {
                    String previousEmail = member.getEmail();
                    member.setEmail(email);
                    SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.EMAIL_CHANGE, (String)"Email address changed by admin from {} to {}", (Object[])new Object[]{previousEmail, member.getEmail()});
                } else {
                    if ("No Email".equals(email)) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL);
                        return;
                    }
                    try {
                        Emails.sendChangeEmail((Database)db, (Group)req.getGroup(), (Member)member, (String)email, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                        emailChangeConfirmEmailSentTo = email;
                    }
                    catch (EmailException ex) {
                        res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_SEND_EMAIL_CONFIRM);
                        return;
                    }
                }
            }
        }
        if (username != null) {
            String new_username = username.length() > 0 ? username : member.getEmail();
            member.setUsername(new_username);
        }
        if (password != null) {
            if (member.hasSubmitPref('p')) {
                pwdemail = false;
            }
            try {
                member.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
                member.setLastPasswordChange(new Date());
                member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'p'));
            }
            catch (FoundationException e) {
                throw new GeneratorException((Throwable)e);
            }
            if (pwdemail) {
                try {
                    Emails.sendPasswordChangeEmail((Database)db, (Member)member, (Group)req.getGroup(), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
                catch (EmailException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_SEND_PASSWORD_CONFIRM);
                    return;
                }
            }
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.PASSWORD_CHANGE, (String)"Password changed {}for {}", (Object[])new Object[]{currentpwd == null ? "by admin " : "", MemberRule.hasEmail((Member)member) ? member.getEmail() : member.getUsername()});
        }
        if (onvacation != null) {
            if ("true".equals(onvacation)) {
                member.setSubmitPref(Flags.add((String)member.getSubmitPref(), (char)'v'));
                SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Member {} ({}) was set on vacation", (Object[])new Object[]{member.getUsername(), member.getId()});
            } else {
                member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'v'));
                member.setBounceReceived(Integer.valueOf(0));
                SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Member {} ({}) was set on vacation", (Object[])new Object[]{member.getUsername(), member.getId()});
            }
        }
        if (disabled != null) {
            if ("true".equals(disabled)) {
                member.setSubmitPref(Flags.add((String)member.getSubmitPref(), (char)'d'));
                new UserDetailsManager().remove(member.getId());
                AccessTokenManager.singleton().revokeForMember(member.getId().longValue());
                SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Member {} ({}) was disabled", (Object[])new Object[]{member.getUsername(), member.getId()});
            } else {
                member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'d'));
                SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Member {} ({}) was enabled", (Object[])new Object[]{member.getUsername(), member.getId()});
            }
        }
        if (emailattach != null) {
            if ("true".equals(emailattach)) {
                member.setSubmitPref(Flags.add((String)member.getSubmitPref(), (char)'t'));
            } else {
                member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'t'));
            }
        }
        if (token != null) {
            member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'u'));
            member.setActivated(new Date());
            SecurityUtils.login((Database)db, (String)member.getUsername(), (HttpServletRequest)req.getHttpServletRequest());
            token.delete(db);
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Member {} ({}) was activated", (Object[])new Object[]{member.getUsername(), member.getId()});
        }
        req.getTransaction().commit();
        ChangesManager.getInstance().modifyMember(db, member);
        new MembershipCache().remove(member.getId());
        if (firstname != null || surname != null) {
            ProfilePictureServlet.clearCache(member.getId());
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-modification");
        if (emailChangeConfirmEmailSentTo != null) {
            out.field("email-change-confirm-sent-to", email);
        }
        out.writeMember(member, true);
        out.endObject();
        out.flush();
    }
}

