/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.Date;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true)
@PublicAPI
public final class CreateMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        long nbMembers;
        String first_name = req.getParameter((Parameter)StandardParameters.firstname, "Member");
        String timestamp = Long.toString(new Date().getTime());
        String surname = req.getParameter((Parameter)StandardParameters.surname, timestamp.substring(timestamp.length() - 4));
        String email = req.getParameter((Parameter)StandardParameters.email, "");
        String password = req.getParameter((Parameter)StandardParameters.member_password);
        String username = req.getParameter((Parameter)StandardParameters.member_username, "");
        boolean sendNewMemberNotification = req.getParameter((Parameter)StandardParameters.welcome_email, true);
        boolean createPersonalGroup = req.getParameter((Parameter)StandardParameters.personal_group, false);
        boolean autoActivate = req.getParameter((Parameter)StandardParameters.auto_activate, false);
        Database db = req.getDatabase();
        if (!Members.checkNames(first_name, surname, res)) {
            return;
        }
        if (!Members.checkEmailUsername(email, username, null, false, req.getDatabase(), res)) {
            return;
        }
        if (email.isEmpty()) {
            email = "No Email";
        } else if ("".equals(username)) {
            username = email;
        }
        if (password != null && !Members.checkPassword(password, false, res)) {
            return;
        }
        if (username.equals(password)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_CREDENTIALS);
            return;
        }
        Member mem = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
        if (mem == null && !"No Email".equals(email)) {
            mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
        }
        if (mem != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USER_EXISTS);
            return;
        }
        String max_mem = GlobalSettings.getString((String)"members", (String)"unlimited");
        if (!"unlimited".equals(max_mem) && (nbMembers = DatabaseQuery.getNumberMembers((Database)db).longValue()) >= (long)Integer.parseInt(max_mem)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MORE_MEMBERS);
            return;
        }
        Object flags = "";
        if (password == null) {
            password = RuleUtils.generatePassword();
            flags = (String)flags + "p";
        }
        mem = Member.create((Database)db);
        Date now = new Date();
        mem.setCreated(now);
        mem.setFirstName(first_name);
        mem.setSurname(surname);
        mem.setEmail(email);
        mem.setUsername(username);
        try {
            mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
        }
        catch (FoundationException e) {
            throw new GeneratorException((Throwable)e);
        }
        if (!autoActivate) {
            flags = (String)flags + "u";
        } else {
            mem.setActivated(now);
        }
        mem.setSubmitPref((String)flags);
        mem = mem.insert(db);
        ChangesManager.getInstance().createMember(db, mem);
        if (createPersonalGroup) {
            Group members = GroupRule.getMemberProject((Database)db);
            GroupRule.createMemberPersonalGroup((Database)db, (Member)mem, (Group)GroupRule.createMemberPersonalProject((Database)db, (Member)mem, (Group)members), null);
        }
        boolean welcomeEmailFailed = false;
        if (sendNewMemberNotification) {
            try {
                Member creator = req.getAuthenticatedMember();
                Emails.sendNewMember((Database)db, (Member)mem, (Group)req.getGroup(), (Member)creator, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            catch (EmailException ex) {
                welcomeEmailFailed = true;
                req.getLogger((Object)this).error("Failed to write new member email", (Throwable)ex);
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-creation");
        if (welcomeEmailFailed) {
            out.field("welcome-email-failed", true);
        }
        out.writeMember(mem, true);
        out.endObject();
        out.flush();
    }
}

