/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.IdentityConfig;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.util.Flags;
import com.pageseeder.group.Groups;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true)
@PublicAPI
public final class CreateAdministrator
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateAdministrator.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        MemberForGroup mfg;
        String email = req.getParameter((Parameter)StandardParameters.email, "");
        String username = req.getParameter((Parameter)StandardParameters.member_username);
        String password = req.getParameter((Parameter)StandardParameters.member_password);
        String first_name = req.getParameter((Parameter)StandardParameters.firstname, "Member");
        String timestamp = Long.toString(new Date().getTime());
        String surname = req.getParameter((Parameter)StandardParameters.surname, timestamp.substring(timestamp.length() - 4));
        boolean sendNotification = req.getParameter((Parameter)StandardParameters.send_email, true);
        boolean autoActivate = req.getParameter((Parameter)StandardParameters.auto_activate, false);
        Database db = req.getDatabase();
        Group group = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
        Group email_group = Groups.getGroup(req);
        Member mem = null;
        if (email != null && !email.isEmpty()) {
            mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
            if (mem != null && username != null && !username.equals(mem.getUsername())) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_EMAIL_DO_NOT_MATCH);
                return;
            }
        } else if (username != null) {
            mem = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
        }
        boolean memberCreated = false;
        if (mem == null) {
            long nbMembers;
            if (!Members.checkEmailUsername(email, username, null, true, req.getDatabase(), res)) {
                return;
            }
            String max_mem = GlobalSettings.getString((String)"members", (String)"unlimited");
            if (!"unlimited".equals(max_mem) && (nbMembers = DatabaseQuery.getNumberMembers((Database)db).longValue()) >= (long)Integer.parseInt(max_mem)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MORE_MEMBERS);
                return;
            }
            mem = Member.create((Database)db);
            mem.setCreated(new Date());
            mem.setFirstName(first_name);
            mem.setSurname(surname);
            mem.setEmail(Strings.isEmpty((String)email) ? "No Email" : email);
            mem.setUsername(Strings.isEmpty((String)username) ? email : username);
            Object memflags = "";
            if (password != null) {
                if (!Members.checkPassword(password, true, res)) {
                    return;
                }
            } else {
                password = RuleUtils.generatePassword((int)12);
                memflags = (String)memflags + "p";
            }
            if (mem.getUsername().equals(password)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_CREDENTIALS);
                return;
            }
            try {
                mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
            }
            catch (FoundationException e) {
                throw new GeneratorException((Throwable)e);
            }
            if (!autoActivate) {
                memflags = (String)memflags + "u";
            } else {
                mem.setActivated(new Date());
            }
            mem.setSubmitPref((String)memflags);
            mem = mem.insert(db);
            memberCreated = true;
        }
        if ((mfg = DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)group.getId(), (Long)mem.getId())) != null) {
            if (!MemberForGroupRule.isDeletedMember((MemberForGroup)mfg)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_ALREADY_IN_GROUP, "Member is already an administrator.");
                return;
            }
        } else {
            mfg = MemberForGroup.create((Database)db);
        }
        mfg.setListed(Boolean.TRUE);
        mfg.setNotification("None");
        mfg.setMember(mem);
        mfg.setEditor(Boolean.TRUE);
        group.addMembersForGroup(mfg);
        mfg.insert(db);
        IdentityConfig identityConfig = SecurityUtils.getIdentityConfig();
        if (!identityConfig.allowsPasswordForEmail(mem.getEmail())) {
            sendNotification = false;
        }
        if (sendNotification && !MemberRule.hasEmail((Member)mem)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_HAS_NO_EMAIL, "If send-email is true, member must have an email address.");
            return;
        }
        try {
            String newPwd = RuleUtils.generatePassword((int)12);
            if (!MemberRule.isMemberActivated((Member)mem)) {
                mem.setSubmitPref(Flags.add((String)mem.getSubmitPref(), (char)'p'));
                if (sendNotification) {
                    Emails.sendNewMember((Database)db, (Member)mem, (Group)email_group, (Member)req.getAuthenticatedMember(), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
            } else if (sendNotification) {
                String useragent = req.getHeader("User-Agent");
                Emails.sendResetPasswordEmail((Database)db, (Group)email_group, (Member)mem, (Emails.ResetReason)Emails.ResetReason.FORCED, (String)useragent, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)newPwd));
        }
        catch (EmailException e) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to send reset password/activate email to the member: " + e.getMessage());
            return;
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to encode new password", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to encode new password: " + ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("administrator-creation");
        if (memberCreated) {
            out.field("member-created", true);
        }
        out.writeMember(mem, true);
        out.endObject();
        out.flush();
        new UserDetailsManager().remove(mem.getId());
        if (memberCreated) {
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.OTHER, (String)("Created new administrator member: " + mem.getUsername() + " (" + mem.getId() + ")"));
        } else {
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.OTHER, (String)("Added member to administrators: " + mem.getUsername() + " (" + mem.getId() + ")"));
        }
    }
}

