/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Output;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.MFA;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.model.AuthorizationCode;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.CORS;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.security.IdentityConfig;
import com.pageseeder.base.security.LockedAccountException;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.util.Authenticators;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;

@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class Authenticate
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.process(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.process(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest req, HttpServletResponse res) {
        long start = System.currentTimeMillis();
        WebRequest wr = new WebRequest(req, res);
        String action = wr.getParameter("action");
        Database db = wr.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            AuthResponse response;
            tr.begin();
            String origin = req.getHeader("Origin");
            if (origin != null && CORS.isAcceptableOrigin((String)origin, (Database)db)) {
                res.setHeader("Access-Control-Allow-Origin", HttpRequests.toSafeHeader((String)origin));
                res.setHeader("Access-Control-Allow-Credentials", "true");
            }
            if ("logout".equals(action)) {
                response = this.logout(db, wr);
            } else if ("code".equals(action)) {
                response = this.getAuthCode(db, wr);
            } else if ("challenge".equals(action)) {
                response = this.checkChallengeResponse(db, wr);
            } else if ("login".equals(action)) {
                String code = wr.getParameter("auth_code");
                if (code != null) {
                    response = this.loginWithCode(db, wr);
                } else {
                    if (!"POST".equals(req.getMethod())) {
                        wr.sendError(405, "Only POST allowed");
                        tr.abort();
                        return;
                    }
                    String token = wr.getParameter("id_token");
                    response = token != null ? this.loginWithToken(db, wr) : this.loginWithPassword(db, wr);
                }
            } else {
                wr.sendError(400, "Invalid action");
                tr.abort();
                WebUtilities.logAccess((HttpServletRequest)req, (int)400, (String)"authenticate", (long)start, (AccessEvent.Permission)AccessEvent.Permission.PUBLIC);
                return;
            }
            UniversalPrinter out = WebUtilities.getUniversalPrinter((HttpServletRequest)req, (HttpServletResponse)res);
            response.write(out);
            tr.commit();
            if (!"logout".equals(action)) {
                WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"authenticate", (long)start, (AccessEvent.Permission)AccessEvent.Permission.PUBLIC);
            }
        }
        catch (StartTransactionException ex) {
            wr.sendErrorSilently(500, (Exception)((Object)ex));
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"authenticate", (long)start, (AccessEvent.Permission)AccessEvent.Permission.PUBLIC);
        }
        catch (Exception ex) {
            tr.abort();
            wr.sendErrorSilently(500, ex);
            WebUtilities.logAccess((HttpServletRequest)req, (int)500, (String)"authenticate", (long)start, (AccessEvent.Permission)AccessEvent.Permission.PUBLIC);
        }
        finally {
            db.close();
            db = null;
        }
    }

    private AuthResponse logout(Database db, WebRequest wr) throws DatabaseException {
        SecurityUtils.logout((Database)db, (HttpServletRequest)wr.request(), (HttpServletResponse)wr.response());
        return new AuthResponse(AuthStatus.LOGOUT);
    }

    private AuthResponse getAuthCode(Database db, WebRequest wr) throws DatabaseException, OAuthException {
        String token = wr.getParameter("id_token");
        if (token != null) {
            String clientId = wr.getParameter("client_id", "");
            Client client = OAuthQuery.getClientByIdentifier((Database)db, (String)clientId);
            if (client == null) {
                SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in with unregistered client");
                return new AuthResponse(AuthStatus.FAILED);
            }
            String redirectUri = Objects.toString(client.getRedirectURI(), "");
            Member mem = SecurityUtils.identifyMember((Database)db, (String)token, (String)SecurityUtils.getRemoteIP((HttpServletRequest)wr.request()));
            if (mem == null) {
                SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in unknown member");
                return new AuthResponse(AuthStatus.FAILED);
            }
            String scope = client.filterScopes(wr.getParameter("scope", ""));
            String authCode = CodeManager.singleton().issue(clientId, redirectUri, mem.getId().longValue(), scope);
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Issued auth code for client {} to member {}", (Object[])new Object[]{clientId, mem.getUsername()});
            return new AuthResponse(AuthStatus.AUTH_CODE, authCode);
        }
        return new AuthResponse(AuthStatus.FAILED);
    }

    private AuthResponse loginWithToken(Database db, WebRequest wr) {
        String token = wr.getParameter("id_token");
        Member mem = SecurityUtils.identifyMember((Database)db, (String)token, (String)SecurityUtils.getRemoteIP((HttpServletRequest)wr.request()));
        if (mem == null) {
            return new AuthResponse(AuthStatus.FAILED);
        }
        SecurityUtils.login((Database)db, (String)mem.getUsername(), (HttpServletRequest)wr.request(), (boolean)true);
        return new AuthResponse(AuthStatus.SUCCESS);
    }

    private AuthResponse loginWithCode(Database db, WebRequest wr) throws DatabaseException {
        String code = wr.getParameter("auth_code");
        String clientId = wr.getParameter("client_id", "");
        Client client = OAuthQuery.getClientByIdentifier((Database)db, (String)clientId);
        if (client == null) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in with unregistered client");
            return new AuthResponse(AuthStatus.FAILED);
        }
        String redirectUri = Objects.toString(client.getRedirectURI(), "");
        AuthorizationCode authorizationCode = CodeManager.singleton().consumeIfMatch(code, clientId, redirectUri);
        if (authorizationCode == null || authorizationCode.hasExpired()) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Supplied auth code has expired or is invalid");
            return new AuthResponse(AuthStatus.FAILED);
        }
        long memberId = authorizationCode.getMemberId();
        Member mem = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
        if (mem == null) {
            return new AuthResponse(AuthStatus.FAILED);
        }
        SecurityLog.setupUser((Member)mem);
        String email = mem.getEmail();
        IdentityConfig config = SecurityUtils.getIdentityConfig();
        if (!config.allowsIDTokenForEmail(email)) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in internal user with an identity provider");
            return new AuthResponse(AuthStatus.FAILED);
        }
        SecurityUtils.login((Database)db, (String)mem.getUsername(), (HttpServletRequest)wr.request(), (boolean)true);
        return new AuthResponse(AuthStatus.SUCCESS);
    }

    private AuthResponse loginWithPassword(Database db, WebRequest wr) throws DatabaseException {
        List authenticators;
        boolean mfaEnabled;
        IdentityConfig config = SecurityUtils.getIdentityConfig();
        if (!config.allowsPasswordForEmail(wr.getParameter("login-username"))) {
            return new AuthResponse(AuthStatus.EXTERNAL_ONLY);
        }
        String[] credentials = new String[]{wr.getParameter("login-username"), wr.getParameter("login-password")};
        try {
            boolean valid = SecurityUtils.checkPassword((Database)db, (String[])credentials, (String)SecurityUtils.getRemoteIP((HttpServletRequest)wr.request()));
            if (!valid) {
                return new AuthResponse(AuthStatus.FAILED);
            }
        }
        catch (LockedAccountException ex) {
            return new AuthResponse(AuthStatus.LOCKED);
        }
        Member member = DatabaseQuery.getMemberByUsername((Database)db, (String)credentials[0]);
        assert (member != null);
        SecurityLog.setupUser((Member)member);
        if (!config.allowsPasswordForEmail(member.getEmail())) {
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in member that does not allow password login");
            return new AuthResponse(AuthStatus.EXTERNAL_ONLY);
        }
        if (!MemberRule.isMemberActivated((Member)member)) {
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in member requiring activation");
            return new AuthResponse(AuthStatus.ACTIVATION_REQUIRED, member);
        }
        if (MemberRule.isMemberDisabled((Member)member)) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in disabled member");
            return new AuthResponse(AuthStatus.MEMBER_DISABLED, member);
        }
        if (!CSRF.validateOriginReferer((HttpServletRequest)wr.request(), (Database)db)) {
            return new AuthResponse(AuthStatus.FAILED);
        }
        boolean bl = mfaEnabled = !GlobalSettings.getBoolean((String)"mfaDisable", (boolean)false);
        if (mfaEnabled && !(authenticators = Authenticators.listVerifiedAuthenticatorsForMember((Database)db, (long)member.getId())).isEmpty()) {
            ChallengeRequest challenge = MFA.challenge((Database)db, (Member)member, (HttpServletRequest)wr.request(), (List)authenticators);
            if (challenge.isSuccessful()) {
                return new AuthResponse(AuthStatus.CHALLENGE, authenticators, challenge.getChallenge());
            }
            System.err.println(challenge.getStatus());
            return new AuthResponse(AuthStatus.FAILED);
        }
        SecurityUtils.login((Database)db, (String)credentials[0], (HttpServletRequest)wr.request(), (boolean)true);
        if (wr.getBooleanParameter("remember", false)) {
            SecurityUtils.setRememberMeCookie((Database)db, (HttpServletRequest)wr.request(), (HttpServletResponse)wr.response(), (Member)member);
        }
        return new AuthResponse(AuthStatus.SUCCESS);
    }

    private AuthResponse checkChallengeResponse(Database db, WebRequest wr) throws DatabaseException {
        Long memberId = (Long)wr.request().getSession().getAttribute("ps-challenge-memberid");
        if (memberId == null) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Not a challenge session, cannot identify member");
            return new AuthResponse(AuthStatus.FAILED);
        }
        Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
        if (member == null) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.AUTHENTICATION, (String)"Attempting to sign in with invalid member ID");
            return new AuthResponse(AuthStatus.FAILED);
        }
        SecurityLog.setupUser((Member)member);
        String requestedAuthenticator = wr.getParameter("authenticator");
        String challengeId = wr.getParameter("challenge", "");
        if (requestedAuthenticator != null && challengeId.isEmpty()) {
            List authenticators = Authenticators.listVerifiedAuthenticatorsForMember((Database)db, (long)member.getId());
            ChallengeRequest challenge = MFA.challenge((Database)db, (Member)member, (HttpServletRequest)wr.request(), (List)authenticators);
            if (challenge.isSuccessful()) {
                return new AuthResponse(AuthStatus.CHALLENGE, authenticators, challenge.getChallenge());
            }
            return new AuthResponse(AuthStatus.FAILED);
        }
        ChallengeResult result = MFA.checkChallenge((HttpServletRequest)wr.request(), (Database)db);
        if (result == ChallengeResult.LOCKED_OUT) {
            return new AuthResponse(AuthStatus.LOCKED);
        }
        if (result != ChallengeResult.SUCCESS) {
            return new AuthResponse(AuthStatus.FAILED);
        }
        if (!CSRF.validateOriginReferer((HttpServletRequest)wr.request(), (Database)db)) {
            return new AuthResponse(AuthStatus.FAILED);
        }
        boolean remember = MFA.hasRememberMe((HttpServletRequest)wr.request());
        SecurityUtils.login((Database)db, (String)member.getUsername(), (HttpServletRequest)wr.request(), (boolean)true);
        if (remember) {
            SecurityUtils.setRememberMeCookie((Database)db, (HttpServletRequest)wr.request(), (HttpServletResponse)wr.response(), (Member)member);
        }
        return new AuthResponse(AuthStatus.SUCCESS);
    }

    private static final class AuthResponse {
        final AuthStatus status;
        final @Nullable Member activationMember;
        final @Nullable String authCode;
        final @Nullable List<Authenticator> authenticators;
        final @Nullable Challenge challenge;

        public AuthResponse(AuthStatus status) {
            this(status, null, null, null, null);
        }

        public AuthResponse(AuthStatus status, Member member) {
            this(status, null, member, null, null);
        }

        public AuthResponse(AuthStatus status, String code) {
            this(status, code, null, null, null);
        }

        public AuthResponse(AuthStatus status, List<Authenticator> authenticators, @Nullable Challenge challenge) {
            this(status, null, null, authenticators, challenge);
        }

        private AuthResponse(AuthStatus status, @Nullable String code, @Nullable Member member, @Nullable List<Authenticator> authenticators, @Nullable Challenge challenge) {
            this.status = status;
            this.authCode = code;
            this.activationMember = member;
            this.authenticators = authenticators;
            this.challenge = challenge;
        }

        void write(UniversalPrinter out) {
            out.startObject("authenticate");
            out.field("status", this.status.id());
            if (this.activationMember != null && MemberRule.hasEmail((Member)this.activationMember)) {
                out.field("email", this.activationMember.getEmail());
            }
            if (this.authCode != null) {
                out.field("code", this.authCode);
            }
            if (this.challenge != null) {
                this.challenge.print((OutputPrinter)out);
            }
            if (this.authenticators != null) {
                out.startCollection("authenticators");
                for (Authenticator authenticator : this.authenticators) {
                    out.writeAuthenticator(authenticator);
                }
                out.endCollection();
            }
            IdentityConfig config = SecurityUtils.getIdentityConfig();
            String href = config.getPortalHref();
            String title = config.getPortalTitle();
            if (href != null) {
                out.startObject("portal");
                out.field("href", href);
                if (title != null) {
                    out.field("title", title);
                }
                out.endObject();
            }
            out.endObject();
            out.flush();
        }
    }

    private static enum AuthStatus {
        LOGOUT,
        FAILED,
        LOCKED,
        ACTIVATION_REQUIRED,
        MEMBER_DISABLED,
        SUCCESS,
        AUTH_CODE,
        EXTERNAL_ONLY,
        CHALLENGE;


        public String id() {
            return this.name().toLowerCase();
        }
    }
}

