/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.OverallSummaryBuilder;
import com.pageseeder.base.logback.XLogException;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.mail.MailLogger;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;

@Requires(database=true)
@Output(types={OutputType.XML})
public final class ViewSummaryLogs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("mail-logs");
        Logger logger = req.getLogger((Object)this);
        try {
            OverallSummaryBuilder summary = new OverallSummaryBuilder((XLoggerAdaptor)MailLogger.getInstance());
            summary.build();
            summary.toXML(xml);
        }
        catch (XLogException ex) {
            logger.error("unable to generate log summary", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("Failed to load mail logs for {}", (Object)req.getGroup(), (Object)ex);
        }
        finally {
            xml.closeElement();
        }
        xml.flush();
    }
}

