/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.EmailSender;
import com.pageseeder.base.mail.EmailTemplate;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(group=true, member=true, parameters={"template", "content"})
public class SendEmail
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendEmail.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Notify n = Notify.fromString(req.getParameter((Parameter)StandardParameters.notify, "normal"));
        if (n == Notify.RECIPIENTS || !"external".equals(req.getParameter((Parameter)StandardParameters.template, "external")) || req.getParameter((Parameter)StandardParameters.from) != null) {
            return new ManageAccountCheck();
        }
        EditURICheck check = new EditURICheck(req.getGroup());
        if (n == Notify.SELF) {
            check = new ViewMembersCheck(req.getGroup());
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        if (Emails.areDisabled()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Emails are disabled on this server.");
            return;
        }
        Group group = req.getGroup();
        Database db = req.getDatabase();
        String content = req.getParameter((Parameter)StandardParameters.content);
        String templateName = req.getParameter((Parameter)StandardParameters.template);
        String notify = req.getParameter((Parameter)StandardParameters.notify, "normal");
        String from = req.getParameter((Parameter)StandardParameters.from, "member");
        String recipients = req.getParameter((Parameter)StandardParameters.recipients);
        String groups = req.getParameter((Parameter)StandardParameters.groups);
        String attachments = req.getParameter((Parameter)StandardParameters.attachments);
        String subject = req.getParameter((Parameter)StandardParameters.subject, "PageSeeder Email");
        boolean defaultTemplates = req.getParameter((Parameter)StandardParameters.default_, false);
        EmailTemplate template = EmailTemplate.forFilename((String)templateName);
        if (template == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Unknown template: " + templateName);
            return;
        }
        Notify n = Notify.fromString(notify);
        if (n == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid notify parameter " + notify + ": only 'normal', 'announce', 'self' and 'recipients' are supported");
            return;
        }
        if (n == Notify.RECIPIENTS && recipients == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing parameter 'recipients'");
            return;
        }
        From f = From.fromString(from);
        if (f == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid from parameter " + from + ": only 'member', 'group', 'pageseeder' and 'system' are supported");
            return;
        }
        UserDetails userdetails = new UserDetailsManager().get(db, req.getMember().getId(), false);
        ArrayList<Group> grpc = new ArrayList<Group>();
        grpc.add(group);
        if (groups != null) {
            String[] groupnames;
            for (String groupname : groupnames = groups.split(",")) {
                Group grp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
                if (grp == null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Invalid group name: " + groupname);
                    return;
                }
                if (!MemberRule.isContributorForGroup((UserDetails)userdetails, (String)groupname)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Not a contributor of group: " + groupname);
                    return;
                }
                grpc.add(grp);
            }
        }
        EmailSender sender = new EmailSender(template);
        boolean staticContent = true;
        if (template == EmailTemplate.external && !content.startsWith("<notification")) {
            sender.setNotificationAttributes(Collections.singletonMap("name", "external"));
            staticContent = false;
        }
        sender.setXMLSource(content, staticContent, defaultTemplates);
        try {
            sender.createContent(null, group);
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create email content (" + ex.getMessage() + ")");
        }
        catch (TransformerException ex) {
            LOGGER.error("Failed to create email content", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Invalid XSLT template (" + ex.getMessageAndLocation() + ")");
            return;
        }
        if (template == EmailTemplate.external) {
            if (f == From.SYSTEM) {
                sender.setFromSystem();
            } else if (f == From.PAGESEEDER) {
                sender.setFromPageSeeder();
            } else if (f == From.GROUP) {
                sender.setFromGroup();
            } else {
                sender.setFromMember(req.getMember());
            }
        } else {
            sender.setFromTemplate(template, req.getMember());
        }
        if (n == Notify.SELF) {
            sender.setDefaultSubject(group.getName(), subject);
            sender.addRecipient(req.getMember(), group);
        } else if (n == Notify.RECIPIENTS) {
            sender.setDefaultSubject(group.getName(), subject);
            for (String email : recipients.split(",")) {
                sender.addRecipient(email, null, group);
            }
        } else {
            ArrayList<String> emails_added = new ArrayList<String>();
            for (Group grp : grpc) {
                sender.setDefaultSubject(grp.getName(), subject);
                Collection members = n == Notify.ANNOUNCE ? DatabaseQuery.getMembersByGroupId((Database)db, (Long)grp.getId()) : DatabaseQuery.getMembersByGroupIdNotification((Database)db, (Long)grp.getId(), (String)"Immediate");
                for (Member mem : members) {
                    if (!MemberRule.hasEmail((Member)mem) || MemberRule.onVacation((Member)mem) || emails_added.contains(mem.getEmail())) continue;
                    sender.addRecipient(mem, grp);
                    emails_added.add(mem.getEmail());
                }
            }
        }
        if (attachments != null) {
            for (String url : attachments.split(",")) {
                int slash = url.lastIndexOf(47);
                String filename = slash == -1 ? url : url.substring(slash + 1);
                byte[] data = this.retrieveAttachment(url, res);
                if (data == null) {
                    return;
                }
                sender.addAttachment(filename, data);
            }
        }
        boolean delayed = false;
        if (!sender.getRecipientTos().isEmpty()) {
            try {
                delayed = !Emails.sendEmail((EmailSender)sender, (String)req.getMember().getUsername(), (Group)group, (Database)db, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            catch (EmailException ex) {
                LOGGER.error("Failed to send email", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to send email (" + ex.getMessage() + ")");
                return;
            }
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("email-notification");
        xml.attribute("delayed", String.valueOf(delayed));
        xml.closeElement();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] retrieveAttachment(String url, GeneratorResponse res) {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
        }
        catch (MalformedURLException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid attachment URL " + url + " (" + ex.getMessage() + ")");
            return null;
        }
        catch (IOException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to connect to " + url + " (" + ex.getMessage() + ")");
            return null;
        }
        try {
            int status = connection.getResponseCode();
            if (status == 200) {
                try (InputStream in = connection.getInputStream();){
                    byte[] byArray = IOUtils.toByteArray((InputStream)in);
                    return byArray;
                }
            }
            res.setError(GeneratorStatus.SERVER_ERROR, "HTTP error when downloading attachment " + url + " (" + connection.getResponseMessage() + ")");
            try (InputStream errorStream = connection.getErrorStream();){
                String response = IOUtils.toString((InputStream)errorStream, (String)connection.getContentEncoding());
                LOGGER.error("Failed to download attachment {}, response was: {}", (Object)url, (Object)response);
                return null;
            }
        }
        catch (IOException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to download attachment " + url + " (" + ex.getMessage() + ")");
        }
        return null;
    }

    private static enum From {
        MEMBER,
        GROUP,
        PAGESEEDER,
        SYSTEM;


        static From fromString(String s) {
            for (From n : From.values()) {
                if (!n.name().toLowerCase().equals(s)) continue;
                return n;
            }
            return null;
        }
    }

    private static enum Notify {
        NORMAL,
        ANNOUNCE,
        SELF,
        RECIPIENTS;


        static Notify fromString(String s) {
            for (Notify n : Notify.values()) {
                if (!n.name().toLowerCase().equals(s)) continue;
                return n;
            }
            return null;
        }
    }
}

