/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.base.organization.EmailConfig;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Host;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailHosts {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailHosts.class);
    public static Collection<String> internalHosts = null;

    public static boolean isValid(String emailAddress, Database db) throws DatabaseException {
        if (Strings.isEmpty((String)emailAddress)) {
            return false;
        }
        String emailDomain = GlobalSettings.get((String)"emailDomain");
        ArrayList<String> allowedDomains = new ArrayList<String>();
        if ("pshosts".equals(emailDomain)) {
            allowedDomains.addAll(MailHosts.loadHosts(db));
        } else {
            allowedDomains.add(emailDomain);
        }
        OrganizationManager org_manager = OrganizationManager.instance();
        Set configs = org_manager.getEmailConfigTemplates();
        for (String template : configs) {
            EmailConfig config = org_manager.getEmailConfig(template);
            if (config == null || config.getEmailDomain() == null) continue;
            allowedDomains.add(config.getEmailDomain());
        }
        LOGGER.debug("Checking domain of email for: {}", (Object)emailAddress);
        for (String domain : allowedDomains) {
            if (!emailAddress.endsWith("@" + domain)) continue;
            return true;
        }
        return false;
    }

    private static Collection<String> loadHosts(Database db) throws DatabaseException {
        if (internalHosts != null) {
            return internalHosts;
        }
        ArrayList<String> hosts = new ArrayList<String>();
        for (Host h : DatabaseQuery.getAllHostsAlpha((Database)db, (boolean)false, (int)-1, (int)-1, (boolean)false)) {
            hosts.add(h.getName());
        }
        internalHosts = hosts;
        return hosts;
    }

    public static void clearInternalHosts() {
        internalHosts = null;
    }
}

