/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.mail.IncomingMailHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.server.SMTPServer;

public final class IncomingMailServer
implements MessageHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncomingMailServer.class);
    private static final IncomingMailServer INSTANCE = new IncomingMailServer();
    private static final String INTERNAL_KEY_PASSWORD = "GHkjnl865$f";
    private SMTPServer server = null;
    private String disabledMessage = null;

    private IncomingMailServer() {
    }

    public static IncomingMailServer getInstance() {
        return INSTANCE;
    }

    public @Nullable String getDisabledMessage() {
        return this.disabledMessage;
    }

    public void start() {
        boolean enabled;
        this.disabledMessage = null;
        boolean bl = enabled = !"false".equals(GlobalSettings.getString((String)"mailServer", (String)"true"));
        if (!enabled) {
            this.disabledMessage = "Incoming emails are disabled: the mailServer global property is set to false";
            LOGGER.info(this.disabledMessage);
            return;
        }
        int port = GlobalSettings.getInt((String)"mailPort", (int)25);
        String domain = GlobalSettings.get((String)"emailDomain");
        String mailIp = GlobalSettings.get((String)"mailIp");
        String tlsKey = GlobalSettings.get((String)"mailTlsKey");
        String tlsCertificate = GlobalSettings.get((String)"mailTlsCertificate");
        boolean tlsRequired = "true".equals(GlobalSettings.get((String)"mailTlsRequired"));
        if (Strings.isEmpty((String)domain)) {
            this.disabledMessage = "Incoming emails are disabled: the emailDomain global property is not set";
            LOGGER.info(this.disabledMessage);
            return;
        }
        String mailHostname = "pshosts".equals(domain) ? GlobalSettings.get((String)"webSiteAddress") : domain;
        InetAddress address = null;
        if (!Strings.isEmpty((String)mailIp)) {
            try {
                address = InetAddress.getByName(mailIp);
            }
            catch (UnknownHostException ex) {
                this.disabledMessage = "Incoming emails are disabled: invalid mailIp global property: " + mailIp;
                LOGGER.error(this.disabledMessage, (Throwable)ex);
                return;
            }
        }
        try {
            SMTPServer.Builder builder = SMTPServer.port((int)port).connectionTimeout(1, TimeUnit.MINUTES).backlog(100).maxMessageSize(0).maxConnections(20).maxRecipients(20).messageHandlerFactory((MessageHandlerFactory)this).softwareName("PageSeeder").serverThreadName("Incoming mail server").hostName(mailHostname);
            if (address != null) {
                builder.bindAddress(address);
            }
            if (!Strings.isEmpty((String)tlsKey) && !Strings.isEmpty((String)tlsCertificate)) {
                builder.startTlsSocketFactory(this.loadSSLContext());
                builder.enableTLS(true);
                builder.requireTLS(tlsRequired);
            }
            this.server = builder.build();
        }
        catch (IOException ex) {
            this.disabledMessage = "Incoming emails are disabled: " + ex.getMessage();
            LOGGER.error(this.disabledMessage, (Throwable)ex);
            return;
        }
        IncomingMailHandler.shutdown = false;
        this.server.start();
        LOGGER.info("Incoming mail server started successfully");
    }

    private SSLContext loadSSLContext() throws IOException {
        KeyStore ks = this.loadKeyStore();
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, INTERNAL_KEY_PASSWORD.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new IOException("Unable to create key manager: " + ex.getMessage(), ex);
        }
    }

    private KeyStore loadKeyStore() throws IOException {
        PrivateKey key = IncomingMailServer.loadPrivateKey();
        List<Certificate> certs = IncomingMailServer.loadCertificates();
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            for (int i = 0; i < certs.size(); ++i) {
                keyStore.setCertificateEntry("cert_" + i, certs.get(i));
            }
            keyStore.setKeyEntry("client-key", key, INTERNAL_KEY_PASSWORD.toCharArray(), certs.toArray(new Certificate[certs.size()]));
            return keyStore;
        }
        catch (GeneralSecurityException ex) {
            throw new IOException("Cannot build keystore: " + ex.getMessage(), ex);
        }
    }

    private static PrivateKey loadPrivateKey() throws IOException {
        try (FileInputStream is = new FileInputStream(GlobalSettings.getString((String)"mailTlsKey", (String)""));){
            PEMParser pr = new PEMParser((Reader)new InputStreamReader(is));
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object o = pr.readObject();
            if (o instanceof PrivateKeyInfo) {
                PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)o);
                return privateKey;
            }
            if (o instanceof PEMKeyPair) {
                PrivateKey privateKey = converter.getKeyPair((PEMKeyPair)o).getPrivate();
                return privateKey;
            }
            throw new IOException("Private key format not supported: " + o.getClass().getName());
        }
    }

    private static List<Certificate> loadCertificates() throws IOException {
        ArrayList<Certificate> arrayList;
        FileInputStream is = new FileInputStream(GlobalSettings.getString((String)"mailTlsCertificate", (String)""));
        try {
            Object o;
            ArrayList<Certificate> certs = new ArrayList<Certificate>();
            PEMParser pr = new PEMParser((Reader)new InputStreamReader(is));
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
            while ((o = pr.readObject()) != null) {
                if (o instanceof X509CertificateHolder) {
                    certs.add(converter.getCertificate((X509CertificateHolder)o));
                    continue;
                }
                throw new IOException("Certificates must be in X509 format");
            }
            arrayList = certs;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CertificateException ex) {
                throw new IOException("Unable to load private key:" + ex.getMessage(), ex);
            }
        }
        ((InputStream)is).close();
        return arrayList;
    }

    public void stop() {
        IncomingMailHandler.shutdown = true;
        if (this.server != null) {
            this.server.stop();
            LOGGER.info("Incoming mail server stopped");
        }
    }

    public MessageHandler create(MessageContext ctxt) {
        return new IncomingMailHandler();
    }
}

