/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.common.http.HttpRedirect;
import com.pageseeder.common.net.URLCoder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pageseeder.furi.Parameters;
import org.pageseeder.furi.URIParameters;
import org.pageseeder.furi.URITemplate;

public final class EmailPermalinkServlet
extends HttpServlet {
    private static final long serialVersionUID = 20220221L;
    private static final List<String> URI_PARAMETER_NAMES = Arrays.asList("member", "group", "comment", "uri", "fragment");

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String path = req.getServletPath();
        URITemplate template = EmailPermalinkServlet.getTemplateV6(path);
        if (template != null) {
            URIParameters parameters = new URIParameters();
            for (String name : URI_PARAMETER_NAMES) {
                String value = req.getParameter(name);
                if (value == null) continue;
                parameters.set(name, value);
            }
            StringBuilder url = new StringBuilder(req.getContextPath());
            url.append(template.expand((Parameters)parameters));
            boolean hasQuery = url.indexOf("?") >= 0;
            Map map = req.getParameterMap();
            for (Map.Entry e : map.entrySet()) {
                String name = (String)e.getKey();
                if (URI_PARAMETER_NAMES.contains(name)) continue;
                for (String value : (String[])e.getValue()) {
                    if (hasQuery) {
                        url.append('&');
                    } else {
                        url.append('?');
                        hasQuery = true;
                    }
                    url.append(URLCoder.encode((String)name)).append('=').append(URLCoder.encode((String)value));
                }
            }
            String frag_param = req.getParameter("fragment");
            String location = String.valueOf(url) + (String)(frag_param != null && !"default".equals(frag_param) ? (frag_param.startsWith("page=") ? "#" : "#fragment-") + frag_param : "");
            HttpRedirect.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)location);
        } else {
            res.sendError(404);
        }
    }

    private static URITemplate getTemplateV6(String path) {
        switch (path) {
            case "/email/changeemail": {
                return new URITemplate("/ui/m/{member}/email.html");
            }
            case "/email/changepassword": {
                return new URITemplate("/ui/m/{member}/password.html");
            }
            case "/email/comment": {
                return new URITemplate("/ui/g/{group}/discussions/{comment}.html");
            }
            case "/email/comments": {
                return new URITemplate("/ui/g/{group}/discussions.html");
            }
            case "/email/download": {
                return new URITemplate("/ui/d/{uri}/download.html");
            }
            case "/email/getstarted": {
                return new URITemplate("/ui/m/{member}/getstarted.html");
            }
            case "/email/home": {
                return new URITemplate("/ui/g/{group}/home.html");
            }
            case "/email/members": {
                return new URITemplate("/ui/g/{group}/admin/members.html");
            }
            case "/email/moderatecommment": 
            case "/email/moderatecomment": {
                return new URITemplate("/ui/g/{group}/discussions/{comment}/moderate.html");
            }
            case "/email/moderatemember": {
                return new URITemplate("/ui/g/{group}/admin/members/{member}/moderate.html");
            }
            case "/email/mydetails": {
                return new URITemplate("/ui/account/personal.html");
            }
            case "/email/mygroups": {
                return new URITemplate("/ui/account/memberships.html");
            }
            case "/email/myinvitation": {
                return new URITemplate("/ui/account/memberships.html?group={group}");
            }
            case "/email/myoptions": {
                return new URITemplate("/ui/account/personal.html");
            }
            case "/email/mytasks": {
                return new URITemplate("/ui/account/tasks.html");
            }
            case "/email/newcomment": {
                return new URITemplate("/ui/g/{group}/discussions.html?form=true");
            }
            case "/email/unsubscribe": {
                return new URITemplate("/ui/unsubscribe.html?group={group}");
            }
            case "/email/uri": {
                return new URITemplate("/ui/g/{group}/d/{uri}.html");
            }
            case "/email/workflow": {
                return new URITemplate("/ui/g/{group}/d/{uri}.html?workflow");
            }
        }
        return null;
    }
}

