/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.servlets;

import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.load.LoadingZone;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(value=PublicAPI.Support.SUPPORTED)
public final class LoadingZoneGet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingZoneGet.class);
    private static final long serialVersionUID = 4396961890691991734L;
    private static final int BUFFER_SIZE = 2048;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        WebRequest wreq;
        String group;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((group = (wreq = new WebRequest(req, res)).getParameter("group", true)) == null) {
            return;
        }
        String path = wreq.getParameter("path", true);
        if (path == null) {
            return;
        }
        Database db = WebRequest.getDatabase((HttpServletResponse)res);
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            String xlinkid;
            tr.begin();
            Permissions perm = new Permissions();
            Group thegroup = GroupRule.getGroup((Database)db, (String)group);
            if (thegroup == null) {
                res.sendError(404, "Group not found");
                tr.abort();
                return;
            }
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new EditURICheck(thegroup))) {
                tr.abort();
                return;
            }
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)perm.getMemberId());
            String uploadid_param = req.getParameter("uploadid");
            String uploadid = LoadingZone.getUploadID(uploadid_param, xlinkid = req.getParameter("xlinkid"), db, member);
            if (uploadid == null && (uploadid_param != null || xlinkid != null)) {
                res.sendError(400, "Invalid uploadid or xlinkid");
                return;
            }
            LoadingZone zone = new LoadingZone(thegroup.getName(), thegroup.getOwnerDirectory(), member.getId(), uploadid);
            File toget = zone.existingFile(path).getFile();
            if (!toget.getCanonicalPath().startsWith(zone.baseDirectory().getCanonicalPath())) {
                LOGGER.error("Path is outside base folder: {}", (Object)toget.getPath());
                throw new IOException("Path is outside base folder");
            }
            if (!toget.exists() || !toget.isFile()) {
                res.sendError(404, "File path not found");
                tr.abort();
                return;
            }
            this.serveFile(toget, req, res);
            tr.commit();
        }
        catch (StartTransactionException ex) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (Throwable)ex, (ServletConfig)this.getServletConfig());
        }
        catch (Exception ex) {
            tr.abort();
            throw new ServletException((Throwable)ex);
        }
        finally {
            db.close();
            db = null;
        }
    }

    private void serveFile(File file, HttpServletRequest req, HttpServletResponse res) throws IOException {
        long modified_since = req.getDateHeader("If-Modified-Since");
        long last_modified = file.lastModified();
        if (modified_since != -1L && last_modified != 0L && last_modified <= modified_since + 1000L) {
            res.setStatus(304);
            return;
        }
        res.setContentType(Medias.getMediaType((String)URIRule.getFilename((String)file.getName())[1]));
        if (last_modified != 0L) {
            res.setDateHeader("Last-Modified", last_modified);
        }
        res.setHeader("Content-Disposition", HttpRequests.toSafeHeader((String)("attachment; filename=\"" + file.getName() + "\"")));
        ServletOutputStream outs = res.getOutputStream();
        try (FileInputStream ins = new FileInputStream(file);){
            int i;
            res.setContentLength(((InputStream)ins).available());
            byte[] buff = new byte[2048];
            do {
                if ((i = ((InputStream)ins).read(buff, 0, 2048)) <= 0) continue;
                outs.write(buff, 0, i);
            } while (i == 2048);
        }
    }
}

