/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.generators;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.load.AddWorkflow;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadFactory;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.load.SendNotification;
import com.pageseeder.uri.URIUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.SAXException;

@Requires(group=true, member=true)
public final class LoadingZoneStart
implements Generator,
SingleCheck {
    private static final String TRUE = "true";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        URL u = this.destinationURL(req, null);
        if (u == null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup(), u.toString()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        ProcessThread thread;
        Member member = req.getMember();
        Group group = req.getGroup();
        String uploadid = req.getParameter((Parameter)StandardParameters.uploadid);
        if (uploadid != null && !LoadingZone.isValidUploadID(uploadid)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid uploadid");
            return;
        }
        URL u = this.destinationURL(req, res);
        if (u == null) {
            return;
        }
        LoadingZone zone = new LoadingZone(group.getName(), req.getGroup().getOwnerDirectory(), member.getId(), uploadid);
        String xmlspec = req.getParameter((Parameter)StandardParameters.xmlspec);
        try {
            if ("preview".equals(req.getParameter((Parameter)StandardParameters.mode))) {
                if (xmlspec == null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "An xmlspec is required for mode=preview");
                    return;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(xmlspec.getBytes(StandardCharsets.UTF_8));
                thread = LoadingThreadFactory.createPreviewFromXMLRequest(in, member.getUsername(), group, req.getHttpServletRequest().getSession().getId(), SecurityUtils.getUserToken((HttpServletRequest)req.getHttpServletRequest()), zone);
            } else {
                LoadingThread lthread;
                if (xmlspec == null) {
                    lthread = LoadingThreadFactory.createDefault(member.getUsername(), true, group, zone);
                } else {
                    ByteArrayInputStream in = new ByteArrayInputStream(xmlspec.getBytes(StandardCharsets.UTF_8));
                    lthread = LoadingThreadFactory.createFromXMLRequest(in, member.getUsername(), true, group, req.getHttpServletRequest().getSession().getId(), SecurityUtils.getUserToken((HttpServletRequest)req.getHttpServletRequest()), zone);
                }
                lthread.setRemoveLoadingZone(uploadid != null);
                lthread.setGroupowner(group.getOwnerDirectory());
                lthread.setDestination(u);
                if (!this.overrideWithParameters(req, res, lthread)) {
                    return;
                }
                thread = lthread;
            }
        }
        catch (SAXException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid xmlspec: " + ex.getLocalizedMessage());
            return;
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start(thread);
        UniversalPrinter printer = res.getUniversalWriter();
        printer.startObject("load-start");
        printer.write((UniversallyPrintable)thread);
        printer.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private boolean overrideWithParameters(GeneratorRequest req, GeneratorResponse res, LoadingThread lthread) {
        String notify;
        String notify_labels;
        String notify_content;
        String overwrite_properties;
        String index;
        String createxrefs;
        String validate = req.getParameter((Parameter)StandardParameters.validate);
        if (validate != null) {
            lthread.setValidateSchematron(TRUE.equals(validate));
        }
        if ((createxrefs = req.getParameter((Parameter)StandardParameters.createxrefs)) != null) {
            lthread.setCreateXRefs(TRUE.equals(createxrefs));
        }
        if ((index = req.getParameter((Parameter)StandardParameters.index)) != null) {
            lthread.setIndex(TRUE.equals(index));
        }
        String summary = req.getParameter((Parameter)StandardParameters.summary);
        String overwrite = req.getParameter((Parameter)StandardParameters.overwrite);
        if (overwrite != null || summary != null) {
            lthread.setOverwrite(TRUE.equals(overwrite) && TRUE.equals(summary) ? LoadingThread.OverwriteBehavior.SUMMARY_ALWAYS : (TRUE.equals(overwrite) ? LoadingThread.OverwriteBehavior.OVERWRITE : (TRUE.equals(summary) ? LoadingThread.OverwriteBehavior.SUMMARY_IF_NEEDED : LoadingThread.OverwriteBehavior.FAIL)));
        }
        if ((overwrite_properties = req.getParameter((Parameter)StandardParameters.overwrite_properties)) != null) {
            lthread.setOverwriteExistingProperties(TRUE.equals(overwrite_properties));
        }
        String status = req.getParameter((Parameter)StandardParameters.status);
        String priority = req.getParameter((Parameter)StandardParameters.priority);
        if (!URIUtils.checkStatus(res, status)) {
            return false;
        }
        if (!URIUtils.checkPriority(res, priority)) {
            return false;
        }
        if (status != null) {
            if (status.isEmpty()) {
                lthread.setWorkflow(null);
            } else {
                AddWorkflow workflow = new AddWorkflow(lthread);
                workflow.setStatus(status);
                workflow.setPriority(priority);
                String assign = req.getParameter((Parameter)StandardParameters.assignedto);
                if ("".equals(assign)) {
                    workflow.setAssignTo(0L);
                } else if (assign != null) {
                    if (Strings.isDigits((String)assign)) {
                        workflow.setAssignTo(Long.parseLong(assign));
                    } else {
                        res.setError(GeneratorStatus.BAD_REQUEST, "Invalid assignedto");
                        return false;
                    }
                }
                String due = req.getParameter((Parameter)StandardParameters.due);
                if ("".equals(due)) {
                    workflow.setDueDate(new Date(0L));
                } else if (due != null) {
                    try {
                        workflow.setDueDate(XLinkRule.parseDueDate((String)due));
                    }
                    catch (ParseException ex) {
                        res.setError(GeneratorStatus.BAD_REQUEST, "Invalid due date: " + ex.getMessage());
                        return false;
                    }
                }
                String description = req.getParameter((Parameter)StandardParameters.description);
                String contenttype = req.getParameter((Parameter)StandardParameters.workflow_contenttype, "text/plain");
                if (!contenttype.equals("text/plain") && !contenttype.equals("application/xhtml+xml")) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "The only content types allowed are: text/plain, application/xhtml+xml");
                    return false;
                }
                try {
                    description = XLinkRule.validateContent((String)contenttype, (String)description);
                }
                catch (FoundationException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Invalid description: " + ex.getMessage());
                    return false;
                }
                workflow.setDescription(description);
                workflow.setContentType(contenttype);
                String labels = req.getParameter((Parameter)StandardParameters.workflow_labels);
                if (labels != null) {
                    workflow.setLabels(Strings.split((String)labels, (char)','));
                }
                workflow.setNotification(Notify.fromString((String)req.getParameter((Parameter)StandardParameters.workflow_notify)));
                lthread.setWorkflow(workflow);
            }
        }
        SendNotification notification = lthread.getNotificationSender();
        String notify_subject = req.getParameter((Parameter)StandardParameters.notification_subject);
        if (notify_subject != null) {
            notification.setSubject(notify_subject);
        }
        if ((notify_content = req.getParameter((Parameter)StandardParameters.notification_content)) != null) {
            notification.setMessage(notify_content);
        }
        if ((notify_labels = req.getParameter((Parameter)StandardParameters.notification_labels)) != null) {
            notification.setLabels(Strings.split((String)notify_labels, (char)','));
        }
        if ((notify = req.getParameter((Parameter)StandardParameters.notify)) != null) {
            notification.setNotify(notify);
        }
        return true;
    }

    private URL destinationURL(GeneratorRequest req, GeneratorResponse res) throws DatabaseException {
        Object url = req.getParameter((Parameter)StandardParameters.url);
        String folder = req.getParameter((Parameter)StandardParameters.folder, "");
        try {
            if (url != null) {
                int pathStart;
                int schemeEnd = ((String)(url = URLDecoder.decode((String)url, StandardCharsets.UTF_8.name()))).indexOf("://");
                if (schemeEnd > 0 && (pathStart = ((String)url).indexOf(47, schemeEnd + 3)) > 0) {
                    url = ((String)url).substring(0, pathStart) + RuleUtils.replaceNonFolderCharsKeepSlashes((String)((String)url).substring(pathStart));
                }
            } else {
                GroupURI guri = GroupURIRule.getDefaultGroupURI((Group)req.getGroup());
                if (guri == null) {
                    if (res != null) {
                        res.setError(GeneratorStatus.SERVER_ERROR, "There is no default Group URI in the group.");
                    }
                    return null;
                }
                folder = RuleUtils.replaceNonFolderCharsKeepSlashes((String)URLDecoder.decode(folder, StandardCharsets.UTF_8.name()));
                while (folder.startsWith("/")) {
                    folder = folder.substring(1);
                }
                url = GroupURIs.truncatePath((String)GroupURIRule.getURIString((GroupURI)guri)) + "/" + folder;
            }
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        while (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        try {
            return URIRule.computeURL((String)url, (Database)req.getDatabase());
        }
        catch (MalformedURLException ex) {
            if (res != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Invalid destination url: " + ex.getMessage());
            }
            return null;
        }
    }
}

