/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.generators;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.FileAttributes;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingZone;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

@Requires(group=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class LoadingZoneDelete
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String uploadid;
        try {
            uploadid = LoadingZone.getUploadID(req, res);
            if (uploadid != null && uploadid.isEmpty()) {
                return;
            }
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load upload ID: " + ex.getMessage());
            return;
        }
        LoadingZone zone = new LoadingZone(req.getGroup().getName(), req.getGroup().getOwnerDirectory(), req.getMember().getId(), uploadid);
        UniversalPrinter out = res.getUniversalWriter();
        String path = req.getParameter((Parameter)StandardParameters.path);
        String mediatype = req.getParameter((Parameter)StandardParameters.mediatype);
        if (path != null) {
            if ("/".equals(path) || path.length() == 0) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Invalid path parameter: " + path);
                return;
            }
            File toget = zone.existingFile(path).getFile();
            ArrayList<File> filesDeleted = new ArrayList<File>();
            boolean deleted = false;
            out.startObject("file");
            out.field("path", path);
            out.field("name", toget.getName());
            if (toget.exists()) {
                if (toget.isDirectory()) {
                    out.field("type", "folder");
                    filesDeleted.addAll(Files.descendants((File)toget, (boolean)true));
                    deleted = FileUtils.deleteQuietly((File)toget);
                } else {
                    out.field("type", "file");
                    String type = Medias.getMediaType((File)toget);
                    if (type != null) {
                        out.field("mediatype", type);
                    }
                    deleted = FileUtils.deleteQuietly((File)toget);
                    filesDeleted.add(toget);
                }
                if (deleted) {
                    for (File f : filesDeleted) {
                        File original;
                        String apath = Files.path((File)zone.baseDirectory(), (File)f);
                        if (!apath.toLowerCase().endsWith(".psml")) {
                            File psml = new File(new File(zone.baseDirectory(), "META-INF"), apath + ".psml");
                            if (!psml.exists() || !psml.isFile()) continue;
                            FileUtils.deleteQuietly((File)psml);
                            continue;
                        }
                        if (!apath.toLowerCase().startsWith("meta-inf/") || !(original = new File(zone.baseDirectory(), apath.replaceAll("(^meta\\-inf/)|(^META\\-INF/)|(\\.psml$)|(\\.PSML$)", ""))).exists()) continue;
                        FileAttributes.clear((File)original);
                    }
                    out.field("status", "deleted");
                } else {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Unable to delete this file");
                }
            } else {
                out.field("status", "not-found");
                res.setStatus(GeneratorStatus.NOT_FOUND);
            }
            out.endObject();
        } else if (mediatype != null) {
            zone.addMediaType(mediatype, null, null, null);
            out.startObject("mediatype");
            out.field("value", mediatype);
            for (IncomingFile file : zone.getIncomingFiles()) {
                boolean deleted = false;
                if (file.exists()) {
                    if (file.getFile().isDirectory()) continue;
                    deleted = FileUtils.deleteQuietly((File)file.getFile());
                }
                if (deleted) {
                    File psml;
                    if (!file.getPath().toLowerCase().endsWith(".psml") && (psml = new File(new File(zone.baseDirectory(), "META-INF"), file.getPath() + ".psml")).exists() && psml.isFile()) {
                        FileUtils.deleteQuietly((File)psml);
                    }
                    FileAttributes.clear((File)file.getFile());
                    continue;
                }
                res.setError(GeneratorStatus.SERVER_ERROR, "Unable to delete file " + file.getPath());
                return;
            }
            out.field("status", "deleted");
            out.endObject();
        } else {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid parameters: one of 'path' or 'mediatype' is required");
            return;
        }
        out.flush();
    }
}

