/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.generators;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.DatabaseException;
import java.io.IOException;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class LoadingZone
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getMember() == null) {
            return new NoCheck();
        }
        String uploadid = req.getParameter((Parameter)StandardParameters.uploadid);
        Long xlinkid = req.getParameter((Parameter)StandardParameters.xlinkid, -1L);
        if (uploadid == null && xlinkid > 0L) {
            return new ViewMemberCheck(req.getMember());
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String uploadid;
        UniversalPrinter out = res.getUniversalWriter();
        if (req.getMember() == null) {
            out.startObject("loadingzone");
            out.endObject();
            out.flush();
            return;
        }
        try {
            uploadid = com.pageseeder.load.LoadingZone.getUploadID(req, res);
            if (uploadid != null && uploadid.isEmpty()) {
                return;
            }
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load upload ID: " + ex.getMessage());
            return;
        }
        com.pageseeder.load.LoadingZone zone = new com.pageseeder.load.LoadingZone(req.getGroup().getName(), req.getGroup().getOwnerDirectory(), req.getMember().getId(), uploadid);
        zone.loadExistingFiles();
        out.write(zone.printable(false, req.getParameter((Parameter)StandardParameters.media, false)));
        out.flush();
    }
}

