/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.edits;

import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.UnforeseenException;
import java.io.IOException;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class ContentPart {
    private final String stringContent;
    private final String stringComparisonContent;
    private final XRef xrefContent;

    public ContentPart(String content, String comparison) {
        this.stringContent = content;
        this.stringComparisonContent = comparison;
        this.xrefContent = null;
    }

    public ContentPart(XRef xref) {
        this.stringContent = null;
        this.stringComparisonContent = null;
        this.xrefContent = xref;
    }

    public XRef getXRef() {
        return this.xrefContent;
    }

    public boolean hasXRef() {
        return this.xrefContent != null;
    }

    public String toComparisonString() {
        if (this.stringComparisonContent != null) {
            return this.stringComparisonContent;
        }
        XMLStringWriter xsw = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            this.xrefContent.xRefToPSMLForComparison((XMLWriter)xsw);
        }
        catch (IOException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
        return xsw.toString();
    }

    public String toString() {
        if (this.stringContent != null) {
            return this.stringContent;
        }
        if (this.xrefContent != null) {
            XMLStringWriter xsw = new XMLStringWriter(XML.NamespaceAware.No);
            try {
                this.xrefContent.xRefToPSML((XMLWriter)xsw, null, true, true);
            }
            catch (IOException ex) {
                throw new UnforeseenException((Throwable)ex);
            }
            return xsw.toString();
        }
        return "";
    }
}

