/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.model.Group;
import com.pageseeder.load.AddWorkflow;
import com.pageseeder.load.AntScript;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.Index;
import com.pageseeder.load.LoadingThreadAction;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.load.MalwareScan;
import com.pageseeder.load.MediateFragments;
import com.pageseeder.load.OverwriteSummary;
import com.pageseeder.load.Register;
import com.pageseeder.load.SendNotification;
import com.pageseeder.load.ValidatePSML;
import com.pageseeder.load.ValidateSchematron;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadingThread
extends ProcessThread {
    private static final Logger GENERAL_LOGGER = LoggerFactory.getLogger(LoadingThread.class);
    private final List<AntScript> scripts = new ArrayList<AntScript>();
    private URL _url = null;
    private int nbOfWarnings = 0;
    private LoadingThreadAction currentAction = null;
    private String overwriteSummaryAsXML = null;
    private boolean overwriteConflict = false;
    private Throwable badError = null;
    private boolean _validate = true;
    private boolean _validateSchematron = true;
    private OverwriteBehavior _overwrite = OverwriteBehavior.FAIL;
    private boolean _overwriteExistingProperties = false;
    private boolean _createXRefs = true;
    private boolean _index = true;
    private final LoadingZone loadingZone;
    private final File backupDirectory;
    private String _groupowner = null;
    private boolean _removeLoadingZone = false;
    private boolean _createManifest = true;
    private AddWorkflow _workflow = null;
    private SendNotification _notificationSender = null;
    private final boolean _isContributor;

    public LoadingThread(String username, boolean contributor, Group group, LoadingZone lZone) {
        super(username, "Loading", group);
        this.loadingZone = lZone;
        this.backupDirectory = new File(this.loadingZone.baseDirectory().getAbsolutePath() + ".backup");
        this.backupDirectory.mkdir();
        this._isContributor = contributor;
        this._notificationSender = new SendNotification(this);
    }

    public LoadingThread(String username, boolean contributor, Long groupid, String groupname, LoadingZone lZone) {
        super(username, "Loading", groupid, groupname);
        this.loadingZone = lZone;
        this.backupDirectory = new File(this.loadingZone.baseDirectory().getAbsolutePath() + ".backup");
        this.backupDirectory.mkdir();
        this._isContributor = contributor;
        this._notificationSender = new SendNotification(this);
    }

    public void setRemoveLoadingZone(boolean removeLoadingZone) {
        this._removeLoadingZone = removeLoadingZone;
    }

    public void setCreateManifest(boolean createManifest) {
        this._createManifest = createManifest;
    }

    public void setGroupowner(String groupowner) {
        this._groupowner = groupowner;
    }

    public String getGroupOwner() {
        return this._groupowner;
    }

    public void setWorkflow(AddWorkflow workflow) {
        this._workflow = workflow;
    }

    public void setNotificationSender(SendNotification notificationSender) {
        this._notificationSender = notificationSender;
    }

    public SendNotification getNotificationSender() {
        return this._notificationSender;
    }

    public boolean hadConflicts() {
        return this.overwriteConflict;
    }

    public void cancel() {
        super.cancel();
        if (this.currentAction != null) {
            this.currentAction.cancel();
        }
    }

    public void setDestination(URL url) {
        this._url = url;
    }

    public void setOverwrite(OverwriteBehavior overwrite) {
        this._overwrite = overwrite;
    }

    public void setOverwriteExistingProperties(boolean overwriteExistingProperties) {
        this._overwriteExistingProperties = overwriteExistingProperties;
    }

    public void setCreateXRefs(boolean createXRefs) {
        this._createXRefs = createXRefs;
    }

    public void setIndex(boolean index) {
        this._index = index;
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    public void setValidateSchematron(boolean validateSchematron) {
        this._validateSchematron = validateSchematron;
    }

    public void addAntScript(AntScript script) {
        this.scripts.add(script);
    }

    public void process() {
        try {
            int nb;
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing documents to upload...", false);
            this.loadingZone.loadExistingFiles();
            if (this.loadingZone.isEmpty()) {
                this.updateStatus(ProcessStage.Status.COMPLETED, "No files to load!");
                return;
            }
            this.setName("Loading " + nb + " document/folder" + ((nb = this.loadingZone.getIncomingFiles().size()) == 1 ? "" : "s"));
            this.processFiles();
        }
        catch (Throwable t) {
            this.badError = t;
            GENERAL_LOGGER.error("Unexpected error during upload", t);
            this.fail("Upload failed unexpectedly: " + (t.getMessage() == null ? t.getClass().getName() : t.getMessage()));
        }
        finally {
            LoadingThread.deleteFile(this.backupDirectory);
            if (this._removeLoadingZone) {
                LoadingThread.deleteFile(this.loadingZone.baseDirectory());
            }
        }
        int nbfiles = this.loadingZone.getIncomingFiles().size();
        int nburls = this.loadingZone.getIncomingURLs().size();
        this.complete(this.toMessage(nbfiles, nburls, this.nbOfWarnings));
    }

    public void setDefaults() {
        this.scripts.clear();
        this._validate = true;
        this._validateSchematron = true;
        this._overwrite = OverwriteBehavior.FAIL;
        this._createXRefs = true;
        this._notificationSender = new SendNotification(this);
        this._index = true;
    }

    public void writeThreadElements(OutputPrinter out) {
        if (this.currentAction != null) {
            this.currentAction.print(out);
        }
        if (this.overwriteSummaryAsXML != null && out.getType() == OutputType.XML) {
            out.field("summary", this.overwriteSummaryAsXML, OutputPrinter.FieldOption.XML_COPY);
        }
        if (this.nbOfWarnings > 0) {
            out.field("warnings", (long)this.nbOfWarnings, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (this.badError != null) {
            StringWriter sw = new StringWriter();
            this.badError.printStackTrace(new PrintWriter(sw));
            out.field("stacktrace", sw.toString(), OutputPrinter.FieldOption.XML_ELEMENT);
        }
    }

    public void updateStatus(ProcessStage.Status status, String message, boolean log) {
        if (status == ProcessStage.Status.WARNING) {
            ++this.nbOfWarnings;
            if (this._notificationSender != null) {
                this._notificationSender.addWarning(message);
            }
        }
        super.updateStatus(status, message, log);
    }

    private void processFiles() throws IOException {
        this.updateStatus(ProcessStage.Status.INPROGRESS, "Analysing documents to upload...", false);
        MalwareScan scan = new MalwareScan(this);
        this.currentAction = scan;
        scan.run(this.loadingZone.getIncomingFiles());
        if (this.wasCancelled() || this.hasError()) {
            return;
        }
        this.currentAction = null;
        HashMap<IncomingFile, File> backups = new HashMap<IncomingFile, File>();
        for (AntScript script : this.scripts) {
            if (this.wasCancelled()) {
                return;
            }
            this.currentAction = script;
            this.saveBackup(script.getProcessedFile(), backups);
            script.setConfirmed(this._overwrite == OverwriteBehavior.OVERWRITE || this._overwrite == OverwriteBehavior.RENAME);
            script.run();
        }
        ArrayList<IncomingFile> created = new ArrayList<IncomingFile>();
        if (!this.scripts.isEmpty()) {
            ArrayList<IncomingFile> original = new ArrayList<IncomingFile>(this.loadingZone.getIncomingFiles());
            this.loadingZone.loadExistingFiles();
            ArrayList<IncomingFile> all = new ArrayList<IncomingFile>(this.loadingZone.getIncomingFiles());
            for (IncomingFile file : all) {
                if (!file.exists()) {
                    this.loadingZone.removeFile(file);
                } else {
                    LoadingThread.deleteFile((File)backups.remove(file));
                }
                if (original.contains(file)) continue;
                created.add(file);
            }
            original.clear();
            all.clear();
        }
        if (this.wasCancelled() || this.hasError()) {
            this.revert(backups, created);
            return;
        }
        String[] eventLabels = this._notificationSender == null ? null : this._notificationSender.getLabels();
        Register reg = new Register(this, this.loadingZone, this._url, this._overwrite, this._createManifest, eventLabels);
        reg.setOverwriteProperties(this._overwriteExistingProperties);
        reg.addFiles(this.loadingZone.getIncomingFiles());
        for (IncomingFile f : this.loadingZone.getMetadataFiles()) {
            if (f.getFile().isDirectory() || !f.getPath().startsWith("META-INF/_urls/")) continue;
            f.inspect(this.loadingZone);
            reg.addURL(f);
        }
        OverwriteSummary summary = reg.checkOverwrite();
        if (summary == null || summary == OverwriteSummary.CONFLICT_SUMMARY || !summary.isEmpty()) {
            boolean bl = this.overwriteConflict = summary == OverwriteSummary.CONFLICT_SUMMARY;
            if (summary != null) {
                this.overwriteSummaryAsXML = summary.getXML();
            }
            this.revert(backups, created);
            this.handleMetadataFiles(reg.getFilesWithMetadataCreated(), false, true);
            return;
        }
        this.currentAction = null;
        if (this._validate) {
            ValidatePSML validator = new ValidatePSML(this);
            this.currentAction = validator;
            this.updateStatus(ProcessStage.Status.INPROGRESS, null, false);
            Iterator<IncomingFile> psmls = new ArrayList<IncomingFile>();
            for (IncomingFile file : this.loadingZone.getMetadataFiles()) {
                if (!file.getFile().getName().toLowerCase().endsWith(".psml")) continue;
                psmls.add(file);
            }
            if (!psmls.isEmpty()) {
                validator.setErrorsAsWarnings(true);
                validator.run((Collection<IncomingFile>)((Object)psmls));
                validator.setErrorsAsWarnings(false);
            }
            validator.run(this.loadingZone.getIncomingFiles());
        }
        this.handleMetadataFiles(reg.getFilesWithMetadataCreated(), true, false);
        if (this.wasCancelled() || this.hasError()) {
            this.revert(backups, created);
            return;
        }
        this.currentAction = reg;
        this.updateStatus(ProcessStage.Status.INPROGRESS, null, false);
        reg.perform();
        if (this.wasCancelled() || this.hasError()) {
            this.revert(backups, created);
            return;
        }
        if (this.wasCancelled()) {
            return;
        }
        MediateFragments mediator = new MediateFragments(this, this._createXRefs, this._overwriteExistingProperties, eventLabels, reg.getReverts(), this._url);
        for (IncomingFile incomingFile : this.loadingZone.getIncomingFiles()) {
            File backup = reg.getBackupFile(incomingFile);
            IncomingFile metadata = this.loadingZone.getCorrespondingMetadataFile(incomingFile);
            boolean justCreated = reg.wasCreated(incomingFile.getUriID());
            boolean metadataElement = "true".equals(incomingFile.getAttribute("has-metadata"));
            boolean skip = metadata != null && !metadataElement || metadata == null && !this._createXRefs && justCreated && !metadataElement;
            mediator.addURI(incomingFile.getUriID(), justCreated, backup, metadata == null ? null : metadata.getFile(), skip);
        }
        for (IncomingFile incomingFile : this.loadingZone.getIncomingURLs()) {
            boolean justCreated = reg.wasCreated(incomingFile.getUriID());
            if (!"true".equals(incomingFile.getAttribute("has-metadata")) || !justCreated && !this._overwriteExistingProperties) continue;
            mediator.addURI(incomingFile.getUriID(), justCreated, null, incomingFile.getFile(), false);
        }
        this.currentAction = mediator;
        this.updateStatus(ProcessStage.Status.INPROGRESS, null, false);
        mediator.run();
        if (this.wasCancelled() || this.hasError()) {
            reg.revert();
            reg.cleanup();
            return;
        }
        reg.cleanup();
        this.currentAction = null;
        Set<Long> pubupdates = reg.getPublicationUpdateUris();
        pubupdates.addAll(mediator.getPublicationUpdateUris());
        for (Long puriid : pubupdates) {
            Publications.updateURI((Long)puriid);
        }
        if (this._validateSchematron) {
            ValidateSchematron validateSchematron = new ValidateSchematron(this);
            this.currentAction = validateSchematron;
            this.updateStatus(ProcessStage.Status.INPROGRESS, null, false);
            validateSchematron.run(this.loadingZone.getIncomingFiles());
            if (this.wasCancelled() || this.hasError()) {
                return;
            }
            this.currentAction = null;
        }
        Index index = new Index(this);
        if (this._workflow != null) {
            this.currentAction = this._workflow;
            this.updateStatus(ProcessStage.Status.INPROGRESS, null, false);
            this._workflow.addWorkflow(this.loadingZone.getIncomingFiles(), index);
            if (this.wasCancelled() || this.hasError()) {
                return;
            }
            this.currentAction = null;
        }
        if (this._index) {
            if (this.wasCancelled()) {
                return;
            }
            index.setPublicationUpdates(reg.getPublicationUpdates());
            for (Long destFolderID : reg.getCreatedFolderURIIDs()) {
                index.addURI(destFolderID, true);
            }
            for (IncomingFile file : this.loadingZone.getIncomingFiles()) {
                index.addURI(file.getUriID(), reg.wasCreated(file.getUriID()));
            }
            for (IncomingFile f : this.loadingZone.getMetadataFiles()) {
                Long uriid = f.getUriID();
                if (uriid == null) continue;
                index.addURI(f.getUriID(), reg.wasCreated(f.getUriID()));
            }
            for (Long xrefUriID : reg.getXRefUris()) {
                index.addURI(xrefUriID, reg.wasCreated(xrefUriID));
            }
            for (Long targetUriID : mediator.getTargetTranscludingUris()) {
                index.addURI(targetUriID, reg.wasCreated(targetUriID));
            }
            index.setCommentUris(reg.getCommentUris());
            this.currentAction = index;
            this.updateStatus(ProcessStage.Status.INPROGRESS, null, false);
            index.run();
            if (this.wasCancelled() || this.hasError()) {
                return;
            }
            this.currentAction = null;
        }
        if (this._notificationSender != null) {
            this.currentAction = this._notificationSender;
            this.updateStatus(ProcessStage.Status.INPROGRESS, null, false);
            this._notificationSender.setDestinationFolderURIID(reg.getDestinationFolderURIID());
            this._notificationSender.send(this.loadingZone.getIncomingFiles());
            if (this.wasCancelled() || this.hasError()) {
                return;
            }
            this.currentAction = null;
        }
        for (File f : this.loadingZone.baseDirectory().listFiles()) {
            LoadingThread.deleteFile(f);
        }
    }

    private void saveBackup(IncomingFile processedFile, Map<IncomingFile, File> backups) {
        File backup = new File(this.backupDirectory, processedFile.getPath());
        try {
            FileUtils.copyFile((File)processedFile.getFile(), (File)backup, (boolean)true);
        }
        catch (IOException e) {
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to create backup file for " + processedFile.getPath() + ": " + e.getMessage());
            return;
        }
        backups.put(processedFile, backup);
    }

    private void revert(Map<IncomingFile, File> backups, List<IncomingFile> created) {
        for (Map.Entry<IncomingFile, File> e : backups.entrySet()) {
            IncomingFile original = e.getKey();
            File backup = e.getValue();
            try {
                if (!original.getFile().exists()) {
                    FileUtils.copyFile((File)backup, (File)original.getFile(), (boolean)true);
                }
                LoadingThread.deleteFile(backup);
            }
            catch (IOException ex) {
                this.updateStatus(ProcessStage.Status.WARNING, "Failed to revert backup file for " + original.getPath() + ": " + ex.getMessage());
            }
        }
        for (IncomingFile createdFile : created) {
            LoadingThread.deleteFile(createdFile.getFile());
        }
    }

    private void handleMetadataFiles(List<IncomingFile> files, boolean inspect, boolean revert) throws IOException {
        for (IncomingFile f : files) {
            IncomingFile md = this.loadingZone.getCorrespondingMetadataFile(f);
            if (inspect && md != null && !"true".equals(md.getAttribute("com.pageseeder.load.validation_failed"))) {
                f.inspect(this.loadingZone);
            }
            if (!revert) continue;
            this.loadingZone.removeFile(md);
            File mf = md.getFile();
            if (!mf.getCanonicalPath().startsWith(this.loadingZone.baseDirectory().getCanonicalPath())) {
                GENERAL_LOGGER.error("Path is outside base folder: " + md.getFile().getPath());
                throw new IOException("Path is outside base folder");
            }
            FileUtils.deleteQuietly((File)mf);
        }
    }

    public static void deleteFile(File file) {
        File[] all;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (all = file.listFiles()) != null && all.length > 0) {
            for (File child : all) {
                LoadingThread.deleteFile(child);
            }
        }
        file.delete();
    }

    private String toMessage(int documentCount, int urlCount, int warningCount) {
        if (this.overwriteSummaryAsXML != null) {
            return "Overwrite confirmation needed";
        }
        StringBuilder m = new StringBuilder();
        m.append("Successfully uploaded ").append(documentCount).append(" document");
        if (documentCount > 1) {
            m.append('s');
        }
        if (urlCount > 0) {
            m.append(" and ").append(urlCount).append(" URL");
        }
        if (urlCount > 1) {
            m.append('s');
        }
        if (warningCount > 0) {
            m.append(" with ").append(warningCount).append(" warning");
            if (warningCount > 1) {
                m.append('s');
            }
        }
        return m.toString();
    }

    public static enum OverwriteBehavior {
        FAIL,
        SUMMARY_ALWAYS,
        SUMMARY_IF_NEEDED,
        SUMMARY_RENAME,
        RENAME,
        OVERWRITE;

    }
}

