/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.document.PSMLMetadata;
import com.pageseeder.base.inspect.FileInspection;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.util.FileAttributes;
import com.pageseeder.base.util.Medias;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.utils.PatternResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncomingFile
implements UniversallyPrintable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncomingFile.class);
    private File file = null;
    private final String originalPath;
    private final String mediatype;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String path;
    private Long uriid = null;

    public IncomingFile(File original, String originalpath, LoadingZone zone) {
        String p;
        this.file = original;
        this.setFilename(this.file.getName());
        try {
            p = Files.path((File)zone.baseDirectory(), (File)original);
        }
        catch (IOException ex) {
            p = null;
        }
        this.path = p;
        this.originalPath = originalpath != null ? originalpath.replaceFirst("(/|\\\\)$", "") : p;
        if (this.file.isDirectory()) {
            this.mediatype = "folder";
        } else {
            String extension = URIRule.getExtension((String)original.getName());
            if (!extension.isEmpty()) {
                this.attributes.put("extension", extension);
                this.mediatype = Medias.getMediaType((String)extension);
            } else {
                this.mediatype = "application/octet-stream";
            }
        }
        if (this.file.exists()) {
            this.inspect(zone);
        }
    }

    public boolean isMetadataPSML() {
        String p = this.path.toLowerCase();
        return p.startsWith("meta-inf/") || "meta-inf".equals(p);
    }

    public boolean equals(Object obj) {
        return obj instanceof IncomingFile && this.path.equals(((IncomingFile)obj).getPath());
    }

    public String toString() {
        return this.path;
    }

    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getExtension() {
        return this.attributes.get("extension");
    }

    public String getMediatype() {
        return this.mediatype;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public String getFilename() {
        return this.attributes.get("filename");
    }

    public void setFilename(String filename) {
        if (PatternResolver.hasTokens(filename)) {
            this.attributes.put("filename", filename);
        }
    }

    public String getBehavior() {
        return this.attributes.get("behavior");
    }

    public String getDescription() {
        return this.attributes.get("description");
    }

    public String getDocumentid() {
        return this.attributes.get("docid");
    }

    public String[] getLabels() {
        String labels = this.attributes.get("labels");
        if (labels == null) {
            return null;
        }
        return Strings.split((String)labels, (char)',');
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.attributes.get("type");
    }

    public String getUsertitle() {
        return this.attributes.get("title");
    }

    public void setAttribute(String key, String value) {
        if (value == null || value.length() == 0) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public void setDescription(String description) {
        this.setAttribute("description", description);
    }

    public void setDocumentid(String documentid) {
        this.setAttribute("docid", documentid);
    }

    public void setLabels(String[] labels) {
        if (labels == null || labels.length == 0) {
            this.attributes.remove("labels");
        } else {
            this.attributes.put("labels", String.join((CharSequence)",", labels));
        }
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public void setUsertitle(String usertitle) {
        this.setAttribute("title", usertitle);
    }

    public void setUriID(Long uid) {
        this.uriid = uid;
    }

    public Long getUriID() {
        return this.uriid;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Collection<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public IncomingFile inspect(LoadingZone zone) {
        Map atts = FileAttributes.getAttributes((File)this.file);
        if (atts == null) {
            try {
                File metadata = this.getMetadataFile(zone);
                atts = FileInspection.inspectPSML((File)this.file, (File)metadata);
                if (!atts.containsKey("title") && !this.originalPath.equals(this.path)) {
                    atts.put("title", URIRule.getFilenameAsString((String)this.originalPath));
                }
                FileAttributes.putAttributes((File)this.file, (Map)atts);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load metadata file for {}", (Object)this.path, (Object)ex);
            }
        }
        if (atts != null) {
            for (Map.Entry att : atts.entrySet()) {
                if (this.attributes.containsKey(att.getKey())) continue;
                this.attributes.put((String)att.getKey(), (String)att.getValue());
            }
        }
        return this;
    }

    public void save(InputStream in) throws IOException {
        try (FileOutputStream out = FileUtils.openOutputStream((File)this.file);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public void updatePath(String newpath) {
        this.path = newpath;
    }

    public void resolve() {
        Map<String, String> tokens = this.buildTokens();
        this.setUsertitle(PatternResolver.resolve(this.getUsertitle(), tokens));
        this.setDocumentid(PatternResolver.resolve(this.getDocumentid(), tokens));
        String newfilename = PatternResolver.resolve(this.getFilename(), tokens);
        if (newfilename != null && !newfilename.equals(this.getFilename())) {
            int lastSlash = this.path.lastIndexOf(47);
            this.path = lastSlash == -1 ? newfilename : this.path.substring(0, lastSlash + 1) + "/" + newfilename;
        }
    }

    private File getMetadataFile(LoadingZone zone) throws IOException {
        File base = new File(zone.baseDirectory(), "META-INF");
        File metadata = new File(base, this.path + ".psml");
        if (!metadata.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            LOGGER.error("Path results in a file outside base folder: " + this.path);
            throw new IOException("Path results in a file outside base folder");
        }
        return metadata;
    }

    public boolean hasMetadataFile(LoadingZone zone) throws IOException {
        return this.getMetadataFile(zone).exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkMetadataFile(LoadingZone zone) throws IOException {
        File metadata = this.getMetadataFile(zone);
        if (metadata.exists()) return false;
        if (!this.file.isFile()) return false;
        if ("psml".equals(this.getExtension())) {
            return false;
        }
        try {
            metadata.getParentFile().mkdirs();
            metadata.createNewFile();
            if (!metadata.exists()) {
                LOGGER.error("Failed to create metadata file for {} in {}: {}", (Object)this.path, (Object)zone.groupName());
                return false;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to create metadata file for {} in {}: {}", new Object[]{this.path, zone.groupName(), ex.getLocalizedMessage(), ex});
            return false;
        }
        try (FileOutputStream stream = new FileOutputStream(metadata);){
            if (!PSMLMetadata.generateMetadataFile((File)this.file, (String)zone.groupTemplate(), (String)zone.groupName(), (OutputStream)stream)) {
                stream.close();
                metadata.delete();
                boolean bl = false;
                return bl;
            }
            zone.addIncomingFile(new IncomingFile(metadata, null, zone));
            FileAttributes.clear((File)this.file);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to write metadata file for {} in {}: {}", new Object[]{this.path, zone.groupName(), ex.getLocalizedMessage(), ex});
            return false;
        }
    }

    public void print(OutputPrinter out) {
        this.print(out, true);
    }

    public void print(OutputPrinter out, boolean close) {
        String type;
        out.startObject("file");
        out.field("name", this.path.substring(this.path.lastIndexOf(47) + 1));
        out.field("path", this.path);
        boolean isUrl = this.getAttribute("url") != null;
        ArrayList<String> reserved = new ArrayList<String>(Arrays.asList("name", "path", "type", "original", "length", "modified", "text", "status", "mediatype"));
        if (isUrl) {
            reserved.add("extension");
        }
        for (String att : this.attributes.keySet()) {
            if ("labels".equals(att)) {
                String labels = this.attributes.get(att);
                if (labels == null || labels.isEmpty()) continue;
                out.field("labels", labels.split(","));
                continue;
            }
            if (reserved.contains(att)) continue;
            out.field(att, this.attributes.get(att));
        }
        if (this.file.exists()) {
            if (this.file.isDirectory()) {
                out.field("type", "folder");
            } else if (isUrl) {
                out.field("original", this.originalPath);
                out.field("type", "url");
                out.field("mediatype", "application/vnd.pageseeder.url+xml");
            } else {
                out.field("original", this.originalPath);
                out.field("type", "file");
                type = Medias.getMediaType((File)this.file);
                if (type != null) {
                    out.field("mediatype", type);
                }
                out.field("length", Long.toString(this.file.length()));
                out.field("modified", ISO8601.format((long)this.file.lastModified(), (ISO8601)ISO8601.DATETIME));
                out.field("text", Boolean.toString(Medias.isText((String)type)));
            }
        } else {
            out.field("status", "not-found");
            type = Medias.getMediaType((File)this.file);
            if (type != null) {
                boolean isText = Medias.isText((String)type);
                out.field("mediatype", type);
                out.field("text", Boolean.toString(isText));
            }
        }
        if (close) {
            out.endObject();
        }
    }

    private Map<String, String> buildTokens() {
        HashMap<String, String> tokens = new HashMap<String, String>();
        String filename = URIRule.getFilenameAsString((String)this.path);
        String extension = this.attributes.get("extension");
        tokens.put("filename", filename.replaceFirst("\\..*?$", ""));
        tokens.put("extension", extension);
        IncomingFile.addNonToken("title", this.getUsertitle(), tokens);
        IncomingFile.addNonToken("docid", this.getDocumentid(), tokens);
        IncomingFile.addNonToken("document-type", this.getAttribute("document-type"), tokens);
        Calendar now = Calendar.getInstance();
        tokens.put("year", IncomingFile.leftPadding(now.get(1)));
        tokens.put("month", IncomingFile.leftPadding(now.get(2) + 1));
        tokens.put("date", IncomingFile.leftPadding(now.get(5)));
        return tokens;
    }

    private static String leftPadding(int nb) {
        return nb < 10 ? "0" + nb : String.valueOf(nb);
    }

    private static void addNonToken(String key, String value, Map<String, String> tokens) {
        if (value == null || key == null) {
            return;
        }
        if (!PatternResolver.hasTokens(value)) {
            tokens.put(key, value);
        }
    }
}

