/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.security.AntiCSRFToken;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThreadAction;
import com.pageseeder.load.PreviewThread;
import com.pageseeder.publish.PublishLogMessage;
import com.pageseeder.publish.Publisher;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AntScript
implements LoadingThreadAction {
    private static final long DEFAULT_STATUS_CHECK_DELAY = 4000L;
    private final ProcessThread parent;
    private final String sourceProject;
    private final String sourceDoctype;
    private final String target;
    private final IncomingFile toProcess;
    private final String jsessionid;
    private final String userToken;
    private final Map<String, String> params = new HashMap<String, String>();
    private long statusCheckDelay = 4000L;
    private String currentProcessID = null;
    private String finalPublisherPath = null;
    private String finalPreviewPath = null;
    private String downloadWorkingLink = null;
    private int progress = 0;
    private String currentTarget = null;
    private boolean confirmed = false;
    private boolean cancelled = false;

    public AntScript(ProcessThread dad, String projectname, String documenttype, String targt, String js, String token, IncomingFile f) {
        this.parent = dad;
        this.target = targt;
        this.jsessionid = js;
        this.userToken = token;
        this.toProcess = f;
        this.sourceProject = projectname;
        this.sourceDoctype = documenttype;
    }

    public void setConfirmed(boolean conf) {
        this.confirmed = conf;
    }

    public void setStatusCheckDelay(long statusCheckdelay) {
        this.statusCheckDelay = statusCheckdelay;
    }

    public IncomingFile getProcessedFile() {
        return this.toProcess;
    }

    public void addParam(String name, String value) {
        this.params.put(name, value);
    }

    @Override
    public String name() {
        return "Script";
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("progress", (long)this.progress);
        if (this.currentTarget != null) {
            out.field("target", this.currentTarget);
        }
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
        if (this.finalPreviewPath != null) {
            out.field("previewpath", this.finalPreviewPath, OutputPrinter.FieldOption.XML_ELEMENT);
        } else if (this.finalPublisherPath != null) {
            out.field("publisherpath", this.finalPublisherPath, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (this.downloadWorkingLink != null) {
            out.field("downloadworkinglink", this.downloadWorkingLink, OutputPrinter.FieldOption.XML_ELEMENT);
        }
    }

    @Override
    public void cancel() {
        if (this.currentProcessID != null) {
            Publisher publisher = new Publisher(Publisher.PublisherAction.CANCEL);
            publisher.setProcessID(this.currentProcessID);
            try {
                publisher.run();
            }
            catch (IOException e) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to cancel script: " + e.getLocalizedMessage());
            }
        }
        this.cancelled = true;
    }

    /*
     * Loose catch block
     */
    public void run() {
        try {
            Transaction tr;
            Database db;
            block29: {
                block30: {
                    Member mem;
                    Group group;
                    block27: {
                        block28: {
                            block25: {
                                block26: {
                                    block23: {
                                        block24: {
                                            db = Database.open();
                                            if (!this.cancelled) break block23;
                                            if (db == null) break block24;
                                            db.close();
                                        }
                                        return;
                                    }
                                    tr = new Transaction(db);
                                    tr.begin();
                                    try {
                                        group = DatabaseQuery.getGroupById((Database)db, (Long)this.parent.getGroupID());
                                    }
                                    catch (QueryFailedException e) {
                                        tr.abort();
                                        this.parent.fail("Failed to load group with name " + this.parent.getGroupID() + ": " + e.getMessage());
                                        if (db != null) {
                                            db.close();
                                        }
                                        return;
                                    }
                                    if (group != null) break block25;
                                    this.parent.fail("Could not find group with name " + this.parent.getGroupID() + ": ");
                                    if (db == null) break block26;
                                    db.close();
                                }
                                return;
                            }
                            try {
                                mem = DatabaseQuery.getMemberByUsername((Database)db, (String)this.parent.getUsername());
                            }
                            catch (QueryFailedException e) {
                                tr.abort();
                                this.parent.fail("Failed to load member with username " + this.parent.getUsername() + ": " + e.getMessage());
                                if (db != null) {
                                    db.close();
                                }
                                return;
                            }
                            if (mem != null) break block27;
                            this.parent.fail("Could not find member with username " + this.parent.getUsername());
                            if (db == null) break block28;
                            db.close();
                        }
                        return;
                    }
                    this.process(group, mem);
                    if (!this.cancelled) break block29;
                    if (db == null) break block30;
                    db.close();
                }
                return;
            }
            try {
                tr.commit();
                {
                    catch (DatabaseException ex) {
                        tr.abort();
                        this.parent.fail("Failed to run ANT target " + this.target + ": " + ex.getMessage());
                    }
                }
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        catch (OpenDatabaseException e) {
            this.parent.fail("Failed to open the database:" + e.getMessage());
        }
    }

    private void process(Group group, Member mem) {
        Publisher publisher = new Publisher(Publisher.PublisherAction.PUBLISH);
        publisher.setActionType("upload");
        publisher.setConfigProjectName(this.sourceProject);
        publisher.setSourceDocumentType(this.sourceDoctype);
        publisher.setSourceType("document");
        String format = this.toProcess.getAttribute("format");
        if (format != null) {
            publisher.setParameter("style-format", format);
        }
        publisher.setJsessionid(this.jsessionid);
        publisher.setUsername(this.parent.getUsername());
        publisher.setUserID(mem.getId().toString());
        publisher.setUserFirstname(mem.getFirstName());
        publisher.setUserSurname(mem.getSurname());
        publisher.setUserToken(this.userToken);
        publisher.setAntiCSRFToken(AntiCSRFToken.generateToken((String)this.jsessionid));
        publisher.setGroup(group);
        this.setFileToProcess(publisher, this.toProcess);
        publisher.setTarget(this.target);
        for (String paramname : this.params.keySet()) {
            Object name = "ps-param-" + paramname;
            if ("ps-log-level".equals(paramname)) {
                name = "log-level";
            } else if ("ps-download-working".equals(paramname)) {
                name = "download-working";
            }
            publisher.setParameter((String)name, this.params.get(paramname));
        }
        publisher.setParameter("ps-started", String.valueOf(System.currentTimeMillis()));
        if (this.cancelled) {
            return;
        }
        this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "Running script on document " + this.toProcess.getPath() + "...");
        try {
            publisher.run();
        }
        catch (IOException e) {
            this.parent.fail("Failed to start ANT Script: " + e.getLocalizedMessage());
            return;
        }
        Stack<PublishLogMessage> msgs = publisher.getPublishMessages();
        if (!this.handleMessages(msgs)) {
            String string = this.currentProcessID = msgs.isEmpty() ? null : msgs.peek().getJobid();
            if (this.currentProcessID == null) {
                return;
            }
            while (true) {
                publisher = new Publisher(Publisher.PublisherAction.CHECK);
                publisher.setActionType(this.parent instanceof PreviewThread ? "upload-preview" : "upload");
                publisher.setConfigProjectName(this.sourceProject);
                publisher.setSourceDocumentType(this.sourceDoctype);
                publisher.setProcessID(this.currentProcessID);
                try {
                    publisher.run();
                }
                catch (IOException e) {
                    this.parent.fail("Failed to check status: " + e.getLocalizedMessage());
                    this.currentProcessID = null;
                    break;
                }
                if (this.handleMessages(publisher.getPublishMessages())) break;
                try {
                    Thread.sleep(this.statusCheckDelay);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    private boolean handleMessages(Stack<PublishLogMessage> msgs) {
        if (msgs == null) {
            return true;
        }
        for (PublishLogMessage msg : msgs) {
            this.currentTarget = msg.getTarget();
            String type = msg.getEventType();
            if ("in-progress".equals(type) || "info".equals(type) || "warn".equals(type) || "debug".equals(type)) {
                String content;
                if ("in-progress".equals(type) && msg.getProgress() != null) {
                    try {
                        this.progress = Integer.parseInt(msg.getProgress());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((content = msg.getContent()) != null && content.trim().length() > 0) {
                    if ((content = content.trim()).startsWith("<previewPath>") && content.endsWith("</previewPath>")) {
                        this.finalPreviewPath = content.substring("<previewPath>".length(), content.length() - "</previewPath>".length());
                        continue;
                    }
                    if (content.startsWith("<publisherPath>") && content.endsWith("</publisherPath>")) {
                        this.finalPublisherPath = content.substring("<publisherPath>".length(), content.length() - "</publisherPath>".length());
                        continue;
                    }
                    if (content.startsWith("<downloadWorkingLink>") && content.endsWith("</downloadWorkingLink>")) {
                        this.downloadWorkingLink = content.substring("<downloadWorkingLink>".length(), content.length() - "</downloadWorkingLink>".length());
                        continue;
                    }
                    if ("warn".equals(type)) {
                        this.parent.updateStatus(ProcessStage.Status.WARNING, content);
                        continue;
                    }
                    this.parent.updateStatus(ProcessStage.Status.INPROGRESS, content);
                    continue;
                }
                this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "In progress", false);
                continue;
            }
            if ("complete".equals(type)) {
                this.currentProcessID = null;
                return true;
            }
            if ("error".equals(type)) {
                this.parent.fail(msg.getContent());
                this.currentProcessID = null;
                return true;
            }
            if (!"cancel".equals(type)) continue;
            this.parent.updateStatus(ProcessStage.Status.INPROGRESS, msg.getContent());
            this.currentProcessID = null;
            return true;
        }
        return false;
    }

    private void setFileToProcess(Publisher publisher, IncomingFile toprocess) {
        publisher.setParameter("ps-uploadConfirmed", String.valueOf(this.confirmed));
        String path = toprocess.getPath();
        publisher.setParameter("ps-uploadPath", path);
        int lastSeparator = path.lastIndexOf(47);
        publisher.setParameter("ps-uploadFolder", lastSeparator == -1 ? "" : path.substring(0, lastSeparator));
        String filename = path.substring(lastSeparator + 1);
        publisher.setParameter("ps-uploadFilename", filename);
        int dot = filename.lastIndexOf(46);
        publisher.setParameter("ps-uploadFilenameNoExt", dot == -1 ? filename : filename.substring(0, dot));
        publisher.setParameter("ps-uploadExtension", dot == -1 ? "" : filename.substring(dot + 1));
    }
}

